/****************************************************************************
**
** $Id: logtree.h,v 1.29 2004/04/26 10:16:53 hemer Exp $
**
** Copyright (C) 2001-2004 Jose Hernandez <joseh@tesco.net>
**
** Partly based on cervisia's code by Bernd Gehrmann and others.
** Copyright (C) 1999 Bernd Gehrmann.  bernd@physik.hu-berlin.de
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/


#ifndef LOGTREE_H_20010626
#define LOGTREE_H_20010626

#include "config.h"

#include <qcolor.h>
#include <qdatetime.h>
#include <qptrlist.h>

#include "qttableview.h"

// Forward declarations
class TipLabel;


class LogTreeView : public QtTableView
{
	Q_OBJECT

public:

	class LogTreeItem {
	  public:
	    LogTreeItem();
	    ~LogTreeItem();
	    
	    QString file;
	    QString rev;
	    QString locked;
	    QString authorLocked;
	    QString date;
	    QString author;
	    QString state;
	    QString comment;
	    QString branch;
	    QString tagcomment;
	    QString BranchTagList;
	    QString RegularTagList;
	    QString branchpoint;
	    bool firstonbranch;
	    bool followed;
	    bool branched;
	    int row;
	    int col;
	    int tree;
	    bool selected;
	    unsigned char selection; 
	  };

	class LogTreeConnection {
	public:
	  LogTreeItem *start;
	  LogTreeItem *end;
	};

	LogTreeView (QWidget *parent=0, const char *name=0, WFlags f=0);
	~LogTreeView();

	void addRevision (const QString &, const QString &, const QString &,
			  const QString &, const QDateTime &, const QString &,
			  const QString &, const QString &, const QString &,
			  const QString &, const QString &);

	void setSelectedPair(int, int, QString &, QString &);
	void setSelectionColor (const unsigned char, const QColor &);
	QColor getSelectionColor (const unsigned char) const;

	void nextFile();
	void zoom(int);
	void recomputeCellSizes();
        
	virtual QSize sizeHint() const;
	void lookupTip(const QPoint &, QRect *, QString *);

protected:
    void wheelEvent( QWheelEvent *);
    void keyPressEvent ( QKeyEvent *);

signals:
	void revisionDblClicked (LogTreeView::LogTreeItem *);
	void revisionClicked(LogTreeView::LogTreeItem *, bool);

public slots:
	void toggleBranchTags (bool);
	void toggleRegularTags (bool);
	void zoomIn();
	void zoomOut();

protected:
	virtual void mouseDoubleClickEvent (QMouseEvent *);
	virtual void mousePressEvent(QMouseEvent *);
	virtual void setupPainter(QPainter *);
	virtual void paintCell(QPainter *, int, int);
	virtual int cellWidth(int);
	virtual int cellHeight(int);
    
private:

	void paintRevisionCell (QPainter *, LogTreeView::LogTreeItem *, bool, bool);
	void paintConnector (QPainter *, int, int, bool, bool);
	QString findCollision (int, int) const;
	void shiftBranch (QString branch);
	void shiftAll(int);
	void shiftCurrent(int);
	unsigned int treeForCol(int);
	void collectConnections();
	QRect cellPos(int,int);

	QString escapeHtmlTags(const QString &);

	QFontMetrics *m_pFM;
	QFont m_Font;

	QValueList<int> treeList;

	QPtrList<LogTreeItem> * currentItems;
	QPtrList<LogTreeConnection> * currentConnections;

	QPtrList< QPtrList<LogTreeItem> > itemFileList;
	QPtrList< QPtrList<LogTreeConnection> > connectionFileList;

	int currentRow, currentCol, currentTree, insertRow, startCol;
	bool newFile;
	int trunkRev;
	int rowOffset;
	int lastRevNum;

	QArray<int> colWidths;
	QArray<int> rowHeights;

	static QColor SelColor [2];
	bool bEnableBranchTags;
	bool bEnableRegularTags;
};

#endif //LOGTREE_H_20010626
