/****************************************************************************
**
** $Id: lincvs.cpp,v 1.438 2004/05/06 23:02:53 hemer Exp $
**
** Copyright (C) 1999-2004 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Frank Hemer <frank@hemer.org>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Tom Mishima <tmishima@mail.at-m.or.jp>
**    Joerg Preiss <auba@auba.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "config.h"

//----------------------------------------------------------------------------

#include <qaction.h>
#include <qtextcodec.h>
#include <qtabwidget.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qtextedit.h>
#include <qpopupmenu.h>
#include <qinputdialog.h>
#include <qkeycode.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qaccel.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qstringlist.h>
#include <qstatusbar.h>
#include <qregexp.h> 
#include <qtooltip.h>
#include <qdragobject.h>
#include <qclipboard.h>

//----------------------------------------------------------------------------

#ifndef Q_WS_WIN
#include <unistd.h>
#else
#include <io.h>
#endif

//----------------------------------------------------------------------------

#include "cvsconfig.h"
#include "lincvs.h"
#include "flatsplitter_impl.h"
#include "dialogs.h"
#include "pixmapcache.h"
#include "PixmapTimer.h"
#include "colortab.h"
#include "cvslistview.h"
#include "noncvslistview.h"
#include "cvsignorelistview.h"
#include "directory.h"
#include "DiffDialogImpl.h"
#include "LogDialogImpl.h"
#include "aboutdialogimpl.h"
#include "AnnotateDialogImpl.h"
#include "CommitDialogImpl.h"
#include "EditorsDialogImpl.h"
#include "HistoryDialogImpl.h"
#include "ProfilesDialogImpl.h"
#include "PropertiesDialogImpl.h"
#include "settingsdialogimpl.h"
#include "TagDialogImpl.h"
#include "TagStdDialogImpl.h"
#include "WatchersDialogImpl.h"
#include "AnnotateGrepLineDialogImpl.h"
#include "AnnotateGrepLinesDialogImpl.h"
#include "MergeDialogImpl.h"
#include "login.h"
#include "WrappersIgnoreDialogImpl.h"
#include "ImportDialogImpl.h"
#include "CheckoutDialogImpl.h"
#include "ResolvDialogImpl.h"
#include "FileListViewItem.h"
#include "CustomizeShortcutsDialogImpl.h"
#include "FileMapperDialogImpl.h"
#include "UpdateOtherRevisionDialogImpl.h"
#include "UpdateOtherRevisionStdDialogImpl.h"
#include "ImportVendorDialogImpl.h"
#include "GuiEventBlocker.h"

//----------------------------------------------------------------------------

ApplicationWindow::ApplicationWindow( QString startUpDir)
	: CvsControl( startUpDir),m_AutoRefreshEnabled(false)

// ApplicationWindow::ApplicationWindow(QString startUpDir) :
//   CvsControl( startUpDir),m_AutoRefreshEnabled(false),
//   CMainWindow(0, "LinCVS main window", WType_TopLevel | WDestructiveClose)

{
   if (bUseSmallIcons) setIcon (findEmbeddedPixmap ("lincvs-16"));
   else setIcon (findEmbeddedPixmap ("lincvs-32"));

   //store the default font
   Font::g_default = QApplication::font().toString();

   //set desired font
   if (!Font::g_general.isEmpty()) {
     QFont f;
     if (f.fromString(Font::g_general)) QApplication::setFont(f, true);
     else Font::g_general = QString::null;
   }
   m_timer.setName("statusTimer");
   m_updateTimer.setName("autoUpdateTimer");

   GuiEventBlocker::setBlocking(true);
   initMenuAndToolbar();
   GuiEventBlocker::setBlocking(false);
   blockGUI(true);
   initComponents();
   setStatusText( tr("Scanning Project Directories ..."));

   connect( qApp, SIGNAL(lastWindowClosed()), this, SLOT(slot_closeApp()));

#ifndef NO_CLIPBOARD
   connect (QApplication::clipboard(), SIGNAL(dataChanged()), this, SLOT(clipboardDataChanged()));
#endif

   if (bStartedInDir) {
       Timer::singleShot(0, this, SLOT(startInSingleDir()));
   }
   Timer::singleShot(100, this, SLOT(initialDirScanning()));

}

//----------------------------------------------------------------------------

ApplicationWindow::~ApplicationWindow()
{
    writeSettings();
}

//----------------------------------------------------------------------------

void ApplicationWindow::writeSetup() {

   GEOM_X = geometry().x();
   GEOM_Y = geometry().y();
   GEOM_WIDTH  = geometry().width();
   GEOM_HEIGHT = geometry().height();

   SPLITTER_POS_H = m_pWorkBenchTree->width();
   SPLITTER_POS_V = m_pFileViews->height();

   WORKBENCH_COLUMN_WIDTH = m_pWorkBenchTree->columnWidth(0);

   TOOLBARPOS = "";
   QTextStream stream(TOOLBARPOS,IO_WriteOnly);
   stream << *this;

   SizeProperties::g_fileHeader = m_pCvsFileList->getHeaderSetup();
}

//----------------------------------------------------------------------------

void ApplicationWindow::saveSettings() {
   writeSettings();//calls writeSetup()
   readSettings();
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_settings()
{
   stopTimers();
   SettingsDialogImpl *sd = new SettingsDialogImpl( m_pTools->whatsThisIconSet(),
						    this, "SettingsDlg", true,
						    Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
						    Qt::WStyle_DialogBorder | Qt::WType_Dialog |
						    Qt::WStyle_ContextHelp);   
   //set font slot
   connect( sd, SIGNAL(setFonts()), this, SLOT(slot_setFonts()));
   connect( sd, SIGNAL(refreshEntries()), this, SLOT(refreshAllCvsEntries()));
   connect( sd, SIGNAL( autoUpdateStateChanged()), this, SLOT( slot_applyAutoUpdate()));
   
   sd->exec();
   if (sd->isOnTheFlyScanningModeChanged() && (!ONTHEFLYSCANNING)) {// scan and initialize all projects
      blockGUI(true);
      Directory *item = (Directory *)m_pWorkBenchTree->firstChild();
      while (item) {
         setStatusText("Scanning: "+item->fullName());
         item->analyzeAll();
         item = (Directory *)item->nextSibling();
      }
      setStatusText("");
      blockGUI(false);
   }

   //disconnect set font slot
   disconnect(sd, SIGNAL(setFonts()), 0, 0);
   delete sd;
   
   slot_setFonts();
   setSettings();
   saveSettings();
   slot_checkStatus();
   startTimers();
}

//----------------------------------------------------------------------------

void ApplicationWindow::refreshAllCvsEntries() {

  qApp->setOverrideCursor(waitCursor); // takes some time on huge dirs
  Directory * myChild = (Directory*)(m_pWorkBenchTree->firstChild());
  while( myChild) {
    myChild->validateCvsFilesStatus(TRUE,TRUE);
    myChild = (Directory*)(myChild->nextSibling());
  }
  if ( (m_pCurCvsDir = getSelectedDir()) ) {
    m_pCurCvsDir->activateItem(FALSE);
  }
  qApp->restoreOverrideCursor();
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_setFonts()
{
   QString fontStr;
   QFont f;

   //font of app
   if (Font::g_general.isEmpty()) fontStr = Font::g_default;
   else fontStr = Font::g_general;
   f.fromString(fontStr);
   QApplication::setFont(f, true);

   //font of message widgets   
   if (!Font::g_message.isEmpty()) fontStr = Font::g_message;
   f.fromString(fontStr);
   m_pMessages->setFont(f);
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_profiles()
{
   CProfilesDialogImpl *profileDlg =
      new CProfilesDialogImpl(&cvsUsers, &cvsServers,
                              &cvsRepositories,
                              cvsProfileNameList,
                              cvsProfileContentList,
                              m_pTools->whatsThisIconSet(),
                              this);
   if (profileDlg->exec() == QDialog::Accepted) {
      cvsProfileNameList = profileDlg->profileNameList();
      cvsProfileContentList = profileDlg->profileContentList();
   }

    delete profileDlg;
    saveSettings();
}

//----------------------------------------------------------------------------

void ApplicationWindow::showDirProperties()
{
   if (!(m_pCurCvsDir = getSelectedDir() ) ) {
       return;
   }

   PropertiesDialogImpl Properties (m_pTools->whatsThisIconSet(), this, m_pCurCvsDir);
   Properties.exec();
   applyProjectSettings();//do it allways, not only on ok
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_checkOut() {

  QString * lastProfile = getCurrentProfile();
  CheckoutDialogImpl *dlg = new CheckoutDialogImpl( "Checkout Dialog",
                                                    m_pTools->whatsThisIconSet(),
						    lastProfile,
						    &cvsProfileNameList,
						    &cvsUsers,
						    &cvsServers,
						    &cvsRepositories,
						    &WORKDIRHISTORYLIST,
						    &MODULEHISTORYLIST,
						    &CHECKOUTASLIST,
						    this, "Checkout Dialog", true,
						    Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
						    Qt::WStyle_DialogBorder | Qt::WType_Dialog |
						    Qt::WStyle_ContextHelp);

  if (dlg->exec()) {

    //read dlg values
    QDir tmpLocalDir(dlg->localDir());
    if(!tmpLocalDir.exists()) {
      QMessageBox::warning(this, tr("Warning")+", "+tr("checkout stopped"),
			   tr("The directory doesn't exist:")+"\n"+
			   dlg->localDir(), QMessageBox::Ok, QMessageBox::NoButton);
      setStatusText( tr("Checkout aborted"), 4000 );
      delete dlg;
      return;
    }
    QString importLocalDirectory = tmpLocalDir.absPath();
    QString module = dlg->module();
    QString checkoutAs = dlg->checkoutAs();
    QString checkoutAsDOption = dlg->checkoutAsDOption();
    QString repository = dlg->repository();
    QString tmpCvsRsh = dlg->getCvsRsh();
    QString tmpRevTagDate = dlg->getRevTagDate();
    bool tmpRWPermission = dlg->getRWPermission();
    int sshAccess = dlg->getSshPreset();
    int mode = dlg->mode();
    int rshMode = dlg->rshMode();
    QString server = dlg->server();
    QString user = dlg->user();
    
    //prevent co of allready existing project
    QString tmpModule = checkoutAs;
    if (tmpModule.isEmpty()) tmpModule = checkoutAsDOption;
    if (tmpModule.isEmpty()) tmpModule = module;
    QString testpath = importLocalDirectory+"/"+tmpModule;
    tmpLocalDir.setPath(testpath);
    if (tmpLocalDir.exists()) {
      QMessageBox::warning(this, tr("Warning")+", "+tr("checkout stopped"),
			   tr("Project is allready there:")+"\n"+
			   importLocalDirectory+"/"+tmpModule, QMessageBox::Ok, QMessageBox::NoButton);
      setStatusText( tr("Checkout aborted"), 4000 );
      delete dlg;
      return;
    }

    checkout( importLocalDirectory,
	      module,
	      checkoutAs,
	      checkoutAsDOption,
	      repository,
	      tmpCvsRsh,
	      tmpRevTagDate,
	      server,
	      user,
	      sshAccess,
	      mode,
	      rshMode,
	      tmpRWPermission);
  }
  delete dlg;
}

void ApplicationWindow::slot_import() {

  QString * lastProfile = getCurrentProfile();
  QStringList vendorTagList = getVendorTagList();
  QStringList releaseTagList = getReleaseTagList();
  QString lastComment = getLastComment();
  ImportDialogImpl* dlg = new ImportDialogImpl( lastProfile,
						&cvsProfileNameList,
						&cvsUsers,
						&cvsServers,
						&cvsRepositories,
						&WORKDIRHISTORYLIST,
						&vendorTagList,
						&releaseTagList,
						&lastComment,
                                                m_pTools->whatsThisIconSet(),
						this, "Import Dialog", true,
						Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
						Qt::WStyle_DialogBorder | Qt::WType_Dialog |
						Qt::WStyle_ContextHelp);
  
  if (dlg->exec()) {

    //read dlg values
    QDir localDir(dlg->localDir());
    if(!localDir.exists()) {
      QMessageBox::warning(this, tr("Warning")+", "+tr("import stopped"),
			   tr("Directory doesn't exist:")+"\n"+
			   dlg->localDir(), QMessageBox::Ok, QMessageBox::NoButton);
      setStatusText( tr("Import aborted"), 4000 );
      delete dlg;
      return;
    }
    QString importLocalDirectory = localDir.absPath();
    QString module = dlg->module();
    QString importLastComment = dlg->comment();
    QString repository = dlg->repository();
    QString tmpCvsRsh = dlg->getCvsRsh();
    QString server = dlg->server();
    QString user = dlg->user();
    int mode = dlg->mode();
    int rshMode = dlg->rshMode();
    int sshAccess = dlg->getSshPreset();
    QStringList ignoreWildcards = dlg->getIgnoreWildcards();
    QStringList binaryWildcards = dlg->getBinaryWildcards();

    //read vendor and release tags,
    //ImportDialogImpl makes shure these are never empty
    QString tagV = dlg->tagV();
    QString tagR = dlg->tagR();

    import( importLocalDirectory,
	    module,
	    importLastComment,
	    user,
	    server,
	    repository,
	    tmpCvsRsh,
	    tagV,
	    tagR,
	    mode,
	    rshMode,
	    sshAccess,
	    ignoreWildcards,
	    binaryWildcards);
  }
  delete dlg;
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_importVendor() {
  if (!(m_pCurCvsDir = getSelectedDir())) {
    return;
  }
  static QString commitInfoTxt = "";
  QString cvsroot = m_pCurCvsDir->getCvsRoot();
  QString repository = m_pCurCvsDir->repository();
  QString topDir = m_pCurCvsDir->topCvsDir()->relativeName();
  QString workDir = m_pCurCvsDir->fullName();
  ImportVendorDialogImpl * dlg = new ImportVendorDialogImpl(tr("Import Vendor Dialog"),
							    m_pTools->whatsThisIconSet(),
							    topDir,
							    workDir,
							    commitInfoTxt,
							    this,
							    "Import Vendor Dialog",
							    true,
							    Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
							    Qt::WStyle_DialogBorder | Qt::WType_Dialog |
							    Qt::WStyle_ContextHelp);
  if (dlg->exec()) {
//     qDebug("VendorTag: "+dlg->getVendorTag()+
// 	   ", VendorBranch: "+dlg->getVendorBranch()+
// 	   ", ReleaseTag: "+dlg->getReleaseTag()+
// 	   ", ImportDir: "+dlg->getImportDir()+
// 	   ", commitInfo: "+dlg->getCommitInfo()+
// 	   ", ignore: "+dlg->getIgnoreWildcards().join(" ")+
// 	   ", binary: "+dlg->getBinaryWildcards().join(" "));

    importVendor(topDir,
		 cvsroot,
		 repository,
		 dlg->getImportDir(),
		 dlg->getCommitInfo(),
		 dlg->getVendorTag(),
		 dlg->getVendorBranch(),
		 dlg->getReleaseTag(),
		 dlg->getIgnoreWildcards(),
		 dlg->getBinaryWildcards());
  }
  commitInfoTxt = dlg->getCommitInfo();
  delete dlg;
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_export() {

  QStringList exportDirList = WORKDIRHISTORYLIST;//don't change current list for export
  QStringList exportModules = MODULEHISTORYLIST;
  QStringList exportCheckoutAs = CHECKOUTASLIST;
  
  m_pCurCvsDir = m_pWorkBenchTree->selectedItem();
  if(m_pCurCvsDir) {
    exportModules.prepend(m_pCurCvsDir->repository());//add current module to top of list
    simplifyStringList(&exportModules);
  }

  QString * lastProfile = getCurrentProfile();
  CheckoutDialogImpl *dlg = new CheckoutDialogImpl( "Export Dialog",
                                                    m_pTools->whatsThisIconSet(),
						    lastProfile,
						    &cvsProfileNameList,
						    &cvsUsers,
						    &cvsServers,
						    &cvsRepositories,
						    &exportDirList,
						    &exportModules,
						    &exportCheckoutAs,
						    this, "Export Dialog", true,
						    Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
						    Qt::WStyle_DialogBorder | Qt::WType_Dialog |
						    Qt::WStyle_ContextHelp);

  if (dlg->exec()) {

    //read dlg values
    QDir newDir(dlg->localDir());
    if(!newDir.exists()) {
      if(!newDir.mkdir(dlg->localDir())) {
	showWarning( tr("Warning")+", "+tr("export stopped"),
		     tr("Couldn't create local dir:")+"\n"+ 
		     dlg->localDir() );
	setStatusText( tr("Export aborted"), 4000 );
	delete dlg;
	return;
      }
    }

    //read dlg values
    QString dir = dlg->localDir();
    QString module = dlg->module();
    QString checkoutAs = dlg->checkoutAs();
    QString checkoutAsDOption = dlg->checkoutAsDOption();
    QString repository = dlg->repository();
    QString tmpCvsRsh = dlg->getCvsRsh();
    QString tmpRevTagDate = dlg->getRevTagDate();
    QString server = dlg->server();
    QString user = dlg->user();
    int sshAccess = dlg->getSshPreset();
    int mode = dlg->mode();
    int rshMode = dlg->rshMode();
    bool tmpRWPermission = dlg->getRWPermission();
    
    exportProject( dir,
		   module,
		   checkoutAs,
		   checkoutAsDOption,
		   repository,
		   tmpCvsRsh,
		   tmpRevTagDate,
		   server,
		   user,
		   sshAccess,
		   mode,
		   rshMode,
		   tmpRWPermission);
  }
  delete dlg;
}

//----------------------------------------------------------------------------

void ApplicationWindow::resolveFile() {
  if (!(m_pCurCvsDir = getSelectedDir())) {
    return;
  }
  QString fname =  getNameOfFirstSelectedFile();
  if (fname.isEmpty()) {
    return;
  }

  QString FFN;
  FFN = m_pCurCvsDir->fullName() + "/" + fname;

  qApp->processEvents();//close popup menu
  ResolvDialogImpl* dlg = new ResolvDialogImpl(FFN, m_pTools->whatsThisIconSet(),
					       this, "ResolvDialog", true,
					       Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
					       Qt::WStyle_DialogBorder | Qt::WType_Dialog |
					       Qt::WStyle_ContextHelp | Qt::WDestructiveClose);

  dlg->exec();
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_updateOtherRevisionDir() {

  if (!(m_pCurCvsDir = getSelectedDir())) {
    return;
  }
  QString moduleName = m_pCurCvsDir->topCvsDir()->relativeName();

  if (LookAndFeel::g_stdDlg) {
    UpdateOtherRevisionStdDialogImpl * dlg =
      new UpdateOtherRevisionStdDialogImpl(TRUE,
					   getCurrentTagList(),
					   moduleName,
					   tr("Update Other Revision"),
					   m_pTools->whatsThisIconSet(),
					   this, "Update Other Revision",
					   true,  //modal
					   Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
					   Qt::WStyle_DialogBorder | Qt::WType_Dialog |
					   Qt::WStyle_ContextHelp);
    if(dlg->exec()) {
      QString cvsParameter = "";
      if(!dlg->cvsParameter().isNull()) {
	cvsParameter = dlg->cvsParameter();
      }
      if (dlg->useStickyTag()) {
	updateRevDir(cvsParameter);
      } else {
	revertToRevDir(cvsParameter);
      }
    }
    delete dlg;

  } else {
    UpdateOtherRevisionDialogImpl * dlg =
      new UpdateOtherRevisionDialogImpl(TRUE,
					getCurrentTagList(),
					moduleName,
					tr("Update Other Revision"),
					m_pTools->whatsThisIconSet(),
					this, "Update Other Revision",
					true,  //modal
					Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
					Qt::WStyle_DialogBorder | Qt::WType_Dialog |
					Qt::WStyle_ContextHelp);
    connect( dlg, SIGNAL(getSelectedTags()), this, SLOT(readCurrentTagList()));
    connect( dlg, SIGNAL(getProjectTags()), this, SLOT(updateProjectTagList()));
    connect( this, SIGNAL(tagListFetched()), dlg, SLOT(tagListUpdated()));

    if(dlg->exec()) {
      QString cvsParameter = "";
      if(!dlg->cvsParameter().isNull()) {
	cvsParameter = dlg->cvsParameter();
      }
      if (dlg->useStickyTag()) {
	updateRevDir(cvsParameter);
      } else {
	revertToRevDir(cvsParameter);
      }
    }
    delete dlg;
  }

}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_updateOtherRevisionFile() {

  if (!(m_pCurCvsDir = getSelectedDir())) {
    return;
  }
  QString moduleName = m_pCurCvsDir->topCvsDir()->relativeName();
  QStringList tmp = getSelectedFilesList();
  bool moreThanOneFile = (tmp.count()>1);

  if (LookAndFeel::g_stdDlg) {
    UpdateOtherRevisionStdDialogImpl * dlg =
      new UpdateOtherRevisionStdDialogImpl(moreThanOneFile,
					   getCurrentTagList(),
					   moduleName,
					   tr("Update Other Revision"),
					   m_pTools->whatsThisIconSet(),
					   this, "Update Other Revision",
					   true,  //modal
					   Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
					   Qt::WStyle_DialogBorder | Qt::WType_Dialog |
					   Qt::WStyle_ContextHelp);
    if(dlg->exec()) {
      QString cvsParameter = "";
      if(!dlg->cvsParameter().isNull()) {
	cvsParameter = dlg->cvsParameter();
      }
      if (dlg->useStickyTag()) {
	updateRevFile(cvsParameter);
      } else {
	revertToRevFile(cvsParameter);
      }
    }
    delete dlg;

  } else {

    UpdateOtherRevisionDialogImpl * dlg =
      new UpdateOtherRevisionDialogImpl(moreThanOneFile,
					getCurrentTagList(),
					moduleName,
					tr("Update Other Revision"),
					m_pTools->whatsThisIconSet(),
					this, "Update Other Revision",
					true,  //modal
					Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
					Qt::WStyle_DialogBorder | Qt::WType_Dialog |
					Qt::WStyle_ContextHelp);
    
    connect( dlg, SIGNAL(getSelectedTags()), this, SLOT(readCurrentTagList()));
    connect( dlg, SIGNAL(getProjectTags()), this, SLOT(updateProjectTagList()));
    connect( this, SIGNAL(tagListFetched()), dlg, SLOT(tagListUpdated()));
    
    if(dlg->exec()) {
      QString cvsParameter = "";
      if(!dlg->cvsParameter().isNull()) {
	cvsParameter = dlg->cvsParameter();
      }
      if (dlg->useStickyTag()) {
	updateRevFile(cvsParameter);
      } else {
	revertToRevFile(cvsParameter);
      }
    }
    delete dlg;
  }
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_tagDir() {

  if (!(m_pCurCvsDir = getSelectedDir())) {
    return;
  }
  QString files = "";

  QString dir = m_pCurCvsDir->fullName();
  QString topModule = m_pCurCvsDir->topCvsDir()->relativeName();
  QString command;

  if (LookAndFeel::g_stdDlg) {
    TagStdDialogImpl *dlg = new TagStdDialogImpl(m_pCurCvsDir->repository(), 
						 getCurrentTagList(), topModule, 
						 m_pTools->whatsThisIconSet(),
						 this, tr("Tag a Directory") );
    if (dlg->exec()) {
      command = dlg->getCommand();
      callCVS(topModule, dir, command, files, TAG_CMD);
    }
    delete dlg;
  } else {
    TagDialogImpl *dlg = new TagDialogImpl(m_pCurCvsDir->repository(), 
					   getCurrentTagList(), topModule,
					   m_pTools->whatsThisIconSet(),
					   this, tr("Tag a Directory") );
    if (dlg->exec()) {
      command = dlg->getCommand();
      callCVS(topModule, dir, command, files, TAG_CMD);
    }
    delete dlg;
  }
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_tagFile() {

  if (!(m_pCurCvsDir = getSelectedDir())) {
    return;
  }
  QString files = getNamesOfSelectedFiles();
  if (files.isEmpty()) return;

  QString dir = m_pCurCvsDir->fullName();
  QString topModule = m_pCurCvsDir->topCvsDir()->relativeName();
  QString command;

  if (LookAndFeel::g_stdDlg) {
    TagStdDialogImpl *dlg = new TagStdDialogImpl(QString::null, getCurrentTagList(), 
						 topModule, 
						 m_pTools->whatsThisIconSet(),
						 this, tr("Tag File(s)") );
    if (dlg->exec()) {
      command = dlg->getCommand();
      callCVS(topModule, dir, command, files, TAG_CMD);
    }
    delete dlg;
  } else {
    TagDialogImpl *dlg = new TagDialogImpl(QString::null, getCurrentTagList(), 
					   topModule,
					   m_pTools->whatsThisIconSet(),
					   this, tr("Tag File(s)") );
    if (dlg->exec()) {
      command = dlg->getCommand();
      callCVS(topModule, dir, command, files, TAG_CMD);
    }
    delete dlg;
  }
}

//----------------------------------------------------------------------------

void ApplicationWindow::test() {
  CvsControl::test();
}

//----------------------------------------------------------------------------

//#define BLOCKGUIDEBUG
void ApplicationWindow::blockGUI(bool block, int flags /* = BLOCKALL */) {

  static bool isLocked = false;
  if (isLocked) {
#ifdef BLOCKGUIDEBUG
    qDebug("locked blockGUI("+QString(block ? "true" : "false")+","+QString::number(flags)+") call, suppressed");
#endif
    return;
  }

  bool doBlock = (GuiEventBlocker::isBlocked() != block);

#ifdef BLOCKGUIDEBUG
  if (doBlock) {
    qDebug("blockGUI("+QString(block ? "true" : "false")+","+QString::number(flags)+")");
  } else {
    qDebug("repeated blockGUI("+QString(block ? "true" : "false")+","+QString::number(flags)+") call");
  }
#endif

  if (!doBlock) {
    if (flags == BLOCKNOCONTROLS) {
#ifdef BLOCKGUIDEBUG
      qDebug("blockGUI BLOCKNOCONTROLS done");
#endif
      return;
    }
  }

  if (block) {
    if (doBlock) {
      lockNotifications(true);
      m_timer.pause();
      m_updateTimer.pause();
      GuiEventBlocker::setBlocking(true);
      isLocked = true;
      qApp->processEvents();//clear event queue
      isLocked = false;
    }
    if (!(flags & BLOCKNOCURSOR)) QApplication::setOverrideCursor(waitCursor);
  }

  if (!(flags & BLOCKNOCONTROLS)) {
    m_pTools->m_pStopAction->setEnabled(block);
    m_pTools->setEnabled(!block);
    menuBar()->setEnabled(!block);
  }

  if (!block) {
    if (!(flags & BLOCKNOCURSOR)) QApplication::restoreOverrideCursor();
    if (doBlock) {
      GuiEventBlocker::setBlocking(false);
      m_updateTimer.proceed();
      m_timer.proceed();
      lockNotifications(false);
    }
  }
#ifdef BLOCKGUIDEBUG
  qDebug("blockGUI done");
#endif
}
#undef BLOCKGUIDEBUG
//----------------------------------------------------------------------------

bool ApplicationWindow::isGuiBlocked() {
  return GuiEventBlocker::isBlocked();
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_stopStatusTimer() {
  stopTimers(TSTATUS);
}

//----------------------------------------------------------------------------

void ApplicationWindow::lockNotifications(bool lock) {
  if (lock) {
    lockDirWatch();
  } else {
    unlockDirWatch();
  }
}

//----------------------------------------------------------------------------

void ApplicationWindow::closeEvent( QCloseEvent* e )
{
    if (bAskForQuit) {
      if ( QMessageBox::information( this, tr("LinCVS"), 
				     tr("Are you sure you want to exit LinCVS?"), 
				     tr("&Exit"), tr("&Cancel")
				     ) == 0 ) {
	//kill ssh agent in destructor of this app window
	e->accept();
      } else {
	e->ignore();
      }
    } else {
	e->accept();
    }
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_closeApp() {
    KILLED = true;//for event loops or sock reads to detect shutdown
}

//----------------------------------------------------------------------------

void ApplicationWindow::initDone() {

  setStatusText(tr("Analyzing dirs, please wait ..."));

  /** Enable automatic status refresh */
  qApp->setOverrideCursor(waitCursor); // takes some time on huge dirs
  slot_checkStatus();//starts timer if required
  qApp->restoreOverrideCursor();

  setStatusText(tr("Ready"));

  blockGUI(false);

  //start updateTimer if required
  slot_toggleAutoUpdate();

}

//----------------------------------------------------------------------------

void ApplicationWindow::setStatusText( const QString &txt, int ms) {

  if (ms == 0) {
    m_statusMsg = txt;
    statusBar()->message( txt);
  } else {
    statusBar()->message( txt, ms);
  }

}

//----------------------------------------------------------------------------

void ApplicationWindow::statusMessageChanged( const QString & txt) {

  if ( txt == QString::null) {
    statusBar()->message( m_statusMsg);
    m_statusMsg = QString::null;
  } else if (m_statusMsg.isNull()) {
    m_statusMsg = txt;
  }
}

//----------------------------------------------------------------------------

void ApplicationWindow::checkInProgress(bool state) {
  m_pProgressWidget->setStatus(state);
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_refreshAll() {
  int tmp = Polling::checkStatusLevel;
  Polling::checkStatusLevel = Polling::ALLPROJECTS;
  slot_checkStatus();
  Polling::checkStatusLevel = tmp;
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_applyAutoUpdate() {
  applyProjectSettings();
}

//----------------------------------------------------------------------------

/**
 * activates or stops update timer
 * responsible for automatic running the cvs update cmd
 * if enabled in Directory/Properties
 */
void ApplicationWindow::slot_toggleAutoUpdate() {
  m_pTools->autoUpdateChanged();
  slot_applyAutoUpdate();
  if (AUTOUPDATE) {
    startTimers(TUPDATE);
  } else {
    stopTimers(TUPDATE);
  }
}

//----------------------------------------------------------------------------

/**
 * Initialises the application's menu and toolbar.  Note that some partial
 * initialisation may have already been done in the designer generated stub.
 */
void ApplicationWindow::initMenuAndToolbar()
{
  //main menu items
  m_pProjectMenu = new QPopupMenu( this );
  m_pMenubar->insertItem( QString(tr("&Project")), m_pProjectMenu, MENU_PROJECT );

  m_pDirMenu = new QPopupMenu( this );
  m_pMenubar->insertItem( QString(tr("&Directory")), m_pDirMenu, MENU_DIR );

  m_pFileMenu = new QPopupMenu( this );
  m_pMenubar->insertItem( QString(tr("&File")), m_pFileMenu, MENU_FILE );

  m_pOptionsMenu = new QPopupMenu( this );
  m_pMenubar->insertItem( QString(tr("&Options")), m_pOptionsMenu, MENU_OPTIONS );

  // Makes the Help menu right-align in Motif style
  m_pMenubar->insertSeparator();

  m_pHelpMenu = new QPopupMenu( this );
  m_pMenubar->insertItem( QString(tr("&Help")), m_pHelpMenu, MENU_HELP );

   
  // toolbar
  m_pTools = new cvsToolbar (this);
  addDockWindow( m_pTools, tr( "Toolbar" ), Top, FALSE );
  QMenuBar *mb = new QMenuBar( m_pTools );
  mb->setFrameStyle( QFrame::NoFrame );
  m_pTools->setStretchableWidget( mb );

  QTextStream stream(TOOLBARPOS,IO_ReadOnly);
  stream >> *this;
  
  connect( m_pTools, SIGNAL( autoUpdateStateChanged()),
	   this, SLOT( slot_toggleAutoUpdate()));

  // StatusBar
  m_pProgressWidget = new StatusWidget(statusBar());
  statusBar()->addWidget(m_pProgressWidget, 0, true);
  connect( statusBar(), SIGNAL(messageChanged(const QString &)),
	   this, SLOT( statusMessageChanged( const QString &)));
  
  /* Create the pixmap timer and connect the timeout signal
   * that will reset the timer image to its idle position
   * whenever an operation finishes.
   */
  m_pPixmapTimer = new CPixmapTimer(this, "progress icon indicator");
  connect(m_pPixmapTimer, SIGNAL(signalTimeout(const QPixmap &)),
	  m_pProgressWidget, SLOT(setPixmap(const QPixmap &)));

  // force update of the progress icon
  m_pPixmapTimer->slotStop();
  
  //init menu entries
  //while instanciating the following MenuItems, each is attached an increasing instanceNum(),
  //according to its position in the following list.
  //I started putting these in alphabetical order but:
  //For not to change the meaning of the .lincvsrc PopupMenuDir and file values, additional
  //entries !have! to be put to the end of this list, disregarding the alphabetical order.
  
  M_COMMIT = new MenuItem( Menu::DIR,findEmbeddedPixmap ("commit_16x16"),
			   tr("Commit ..."), SLOT(commitDir()) );
  
  M_COMMITFILE = new MenuItem(Menu::FILE,findEmbeddedPixmap("commit_16x16"),
			      tr("Commit ..."), SLOT(commitFile()));
  
  M_CUSTOMIZE = new MenuItem(Menu::DIR,tr("Customize"), SLOT(customizeDirPopupMenu()),
			     0, DP_Customize);
  
  M_CUSTOMIZEFILE = new MenuItem(Menu::FILE,tr("Customize"), SLOT(customizeFilePopupMenu()),
				 0,DP_Customize);
  
  M_DIFFSIDEBYSIDEFILE = new MenuItem(Menu::FILE,tr("Diff side-by-side"), SLOT(diffFileSideBySide()));
  
  M_DIFFTOCONSOLEFILE = new MenuItem(Menu::FILE,tr("Diff to console"), SLOT(diffFile()));
  
  M_DISABLEDIR = new MenuItem(Menu::DIR,findEmbeddedPixmap ("Disable16x16"),
			      tr("Disable Directory"), SLOT(disableProjectSlot()) );

  M_EDITFILE = new MenuItem(Menu::FILE,findEmbeddedPixmap ("FileWriteable16x16"),
			    tr("Edit"), SLOT(cvsEditFile()));

  M_EDITDIR = new MenuItem(Menu::DIR,findEmbeddedPixmap ("FileWriteable16x16"),
			   tr("Edit"), SLOT(cvsEditDir()));

  M_ENABLEDIR = new MenuItem(Menu::DIR,findEmbeddedPixmap ("Enable16x16"),
			     tr("Enable Directory"), SLOT(enableProjectSlot()) );

  M_EXPANDDIR = new MenuItem(Menu::DIR,tr("Expand all"), SLOT(expandDir()));

  M_HISTORY = new MenuItem(Menu::DIR,tr("History"), SLOT(historyDir()) );

  M_HISTORYFILE = new MenuItem(Menu::FILE,tr("History"), SLOT(historyFile()));

  M_LOGIN = new MenuItem(Menu::DIR,tr("Login"), SLOT(loginDir()) );

  M_LOGOUT = new MenuItem(Menu::DIR,tr("Logout"), SLOT(logoutDir()) );

  M_LOGTREEFILE = new MenuItem(Menu::FILE,findEmbeddedPixmap ("LogTree16x16"),
			       tr("Log tree"), SLOT(logFile()));

  M_PROPERTIES = new MenuItem(Menu::DIR,tr("Properties ..."), SLOT(showDirProperties()) );

  M_QUERYUPDATE = new MenuItem(Menu::DIR,findEmbeddedPixmap ("QueryUpdate16x16"),
			       tr("Query Update"), SLOT(queryUpdateDir()) );

  M_QUERYUPDATEFILE = new MenuItem(Menu::FILE,findEmbeddedPixmap ("QueryUpdate16x16"),
				   tr("Query Update"), SLOT(queryUpdateFile()));

  M_RELEASE = new MenuItem(Menu::DIR, tr("Release"), SLOT(release()) );

  M_RELEASEANDREMOVE = new MenuItem(Menu::DIR, tr("Release and remove"), SLOT(release_and_remove()) );

  M_REMOVE = new MenuItem(Menu::DIR,tr("Remove") );

  M_REMOVEFILE = new MenuItem(Menu::FILE,tr("Remove") );

  M_REMOVEFROMWORKBENCH = new MenuItem(Menu::DIR,findEmbeddedPixmap ("Delete16x16"),
				       tr("Remove From Workbench"), SLOT(removeProjectSlot()) );

  M_RENAMEFILE = new MenuItem(Menu::FILE,tr("Rename file ..."), SLOT(renameFile()));

  M_REREADDIR = new MenuItem(Menu::DIR,findEmbeddedPixmap ("refresh_16x16"),
			     tr("Reread tree"), SLOT(rereadProject()) );

  M_SEPARATOR = new MenuItem( Menu::NONE,tr("------------------"), 0 );

  M_SHOWEDITORS = new MenuItem(Menu::DIR,tr("Show Editors"), SLOT(editorsDir()));

  M_SHOWEDITORSFILE = new MenuItem(Menu::FILE,tr("Show Editors"), SLOT(editorsFile()));

  M_STATUS = new MenuItem(Menu::DIR,findEmbeddedPixmap ("FolderStatus16x16"),
			  tr("Status"), SLOT(statusDir()) );

  M_STATUSFILE = new MenuItem(Menu::FILE,findEmbeddedPixmap ("FileStatus16x16"),
			      tr("Status"), SLOT(statusFile()));

  M_TAG = new MenuItem(Menu::DIR,findEmbeddedPixmap ("Tag16x16"),
		       tr("Tag ..."), SLOT(slot_tagDir()) );

  M_TAGFILE = new MenuItem(Menu::FILE,findEmbeddedPixmap ("Tag16x16"),
			   tr("Tag ..."), SLOT(slot_tagFile()));

  M_UNEDITDIR = new MenuItem(Menu::DIR,findEmbeddedPixmap ("FileUnchanged16x16"),
			     tr("Unedit"), SLOT(cvsUneditDir()));

  M_UNEDITFILE = new MenuItem(Menu::FILE,findEmbeddedPixmap ("FileUnchanged16x16"),
			      tr("Unedit"), SLOT(cvsUneditFile()));

  M_UPDATE = new MenuItem(Menu::DIR,findEmbeddedPixmap ("update_16x16"),
			  tr("Update (patch)"), SLOT(updateDir()) );

  M_UPDATEFILE = new MenuItem(Menu::FILE,findEmbeddedPixmap ("update_16x16"),
			      tr("Update (patch)"), SLOT(updateFile()));

  M_UPDATEOTHER = new MenuItem(Menu::DIR,findEmbeddedPixmap ("Tag16x16"),
			       tr("Update Other Revision ..."), SLOT(slot_updateOtherRevisionDir()) );

  M_UPDATEOTHERFILE = new MenuItem(Menu::FILE,findEmbeddedPixmap ("Tag16x16"),
				   tr("Update Other Revision ..."), SLOT(slot_updateOtherRevisionFile()) );

  M_TEST = new MenuItem(Menu::NONE, tr("test"), SLOT(test()));


  M_LOCKFILE = new MenuItem(Menu::FILE,tr("Lock File"), SLOT(cvsLockFile()));
  M_LOCKDIR = new MenuItem(Menu::DIR,tr("Lock Files"), SLOT(cvsLockDir()));

  M_UNLOCKFILE = new MenuItem(Menu::FILE,tr("Unlock File"), SLOT(cvsUnlockFile()));
  M_UNLOCKDIR = new MenuItem(Menu::DIR,tr("Unlock Files"), SLOT(cvsUnlockDir()));

  M_SHOWWATCHERSFILE = new MenuItem(Menu::FILE,tr("Show Watchers"), SLOT(watchersFile()));
  M_SHOWWATCHERSDIR = new MenuItem(Menu::DIR,tr("Show Watchers"), SLOT(watchersDir()));

  M_OPENFILE = new MenuItem(Menu::FILE | Menu::NONCVSFILE | Menu::IGNOREFILE,tr("Open File"), SLOT(openFile()));

  M_BROWSEDIR = new MenuItem(Menu::DIR,findEmbeddedPixmap ("FolderClosed16x16"),
			     tr("Browse Dir"), SLOT(browseDir()));

  M_OPENSHELLDIR = new MenuItem(Menu::DIR,findEmbeddedPixmap ("FolderClosed16x16"),
				tr("Open Shell"), SLOT(openShellDir()));

  M_UPDATEDIRBRANCHFILE = new MenuItem(Menu::FILE,findEmbeddedPixmap ("Tag16x16"),
				       tr("Update (using dir branch)"), SLOT(updateFilesToDirBranch()));

  M_UPDATEDIRBRANCHDIR = new MenuItem(Menu::DIR,findEmbeddedPixmap ("Tag16x16"),
				      tr("Update (using dir branch)"), SLOT(updateToDirBranch()));

  M_REMOVELOCALOPTIONSFILE = new MenuItem(Menu::FILE, tr("Remove local (-kx) options"), SLOT(removeLocalOptionsFile()));

  M_REMOVELOCALOPTIONSDIR = new MenuItem(Menu::DIR, tr("Remove local (-kx) options"), SLOT(removeLocalOptionsDir()));

  M_EXPORTDIR = new MenuItem(Menu::DIR, tr("Export dir tree ..."), SLOT(exportFromModuleDir()));

  M_COLLAPSDIR = new MenuItem(Menu::DIR,tr("Collaps all"), SLOT(collapsDir()));

  M_VIEWFILE = new MenuItem(Menu::FILE | Menu::NONCVSFILE | Menu::IGNOREFILE,tr("View file"), SLOT(viewFile()));

  M_REPLACEFILE = new MenuItem(Menu::FILE,findEmbeddedPixmap ("update_16x16"),
			       tr("Update (replace)"), SLOT(replaceFile()));

  M_REPLACEDIR = new MenuItem(Menu::DIR,findEmbeddedPixmap ("update_16x16"),
			      tr("Update (replace)"), SLOT(replaceDir()));

  M_RESOLVE = new MenuItem(Menu::FILE, findEmbeddedPixmap ("FileConflict16x16"),
			   tr("Resolve ..."), SLOT(resolveFile()));

  M_DIFFTOCONSOLEDIR = new MenuItem(Menu::DIR,tr("Diff to console"), SLOT(diffDir()));

  M_ADVDIFFTOCONSOLEFILE = new MenuItem(Menu::FILE, tr("Diff (tag/s) to console ..."), SLOT(diffAdvancedFile()));

  M_ADVDIFFTOCONSOLEDIR = new MenuItem(Menu::DIR, tr("Diff (tag/s) to console ..."), SLOT(diffAdvancedDir()));

  M_QUERYUPDATEALL = new MenuItem(Menu::DIR,findEmbeddedPixmap ("QueryUpdate16x16"),
				  tr("Query Update all"), SLOT(queryUpdateAllDir()));

  M_REPLACEALLDIR = new MenuItem(Menu::DIR,findEmbeddedPixmap ("update_16x16"),
				 tr("Update all (replace)"), SLOT(replaceAllDir()));

  M_UPDATEALL = new MenuItem(Menu::DIR,findEmbeddedPixmap ("update_16x16"),
			     tr("Update all (patch)"), SLOT(updateAllDir()));

  M_UPDATEVIRTUALDIR = new MenuItem(Menu::NONE,findEmbeddedPixmap("update_16x16"),
				    tr("Update unknown dir"),SLOT(updateVirtualDir()));

  M_REMOVEFROMDISK = new MenuItem(Menu::FILE, tr("From disk"),SLOT(removeFileFromDisk()));

  M_REMOVEFROMREP = new MenuItem(Menu::FILE, tr("From repository"),SLOT(removeFileFromRep()));

  M_REMOVEFROMREPANDDISK = new MenuItem(Menu::FILE,findEmbeddedPixmap("Delete16x16"),
					tr("From repository and disk"),SLOT(removeFile()));

  M_REMOVEFROMDISKDIR = new MenuItem(Menu::DIR,  tr("From disk"),SLOT(removeDirIfNoCvsRegisteredFiles()));

  M_REMOVEFROMREPANDDISKDIR = new MenuItem(Menu::DIR,findEmbeddedPixmap("Delete16x16"),
					   tr("From repository and disk"),SLOT(removeDir()));

  M_ADDFILE = new MenuItem(Menu::NONE, tr("Add file"),SLOT(resurrectSelectedFiles()));

  M_ADDFOLDER = new MenuItem(Menu::NONCVSFILE | Menu::IGNOREFILE,findEmbeddedPixmap("FolderClosed16x16"),
			     tr("Add folder"),
			     SLOT(addSelectedFiles()));

  M_ADDASCIIFILE = new MenuItem(Menu::NONCVSFILE | Menu::IGNOREFILE,findEmbeddedPixmap("FileASCII16x16"),
				tr("Add ASCII file"),
				SLOT(addSelectedFiles()));
  
  M_ADDBINARYFILE = new MenuItem(Menu::NONCVSFILE | Menu::IGNOREFILE,findEmbeddedPixmap ("FileBinary16x16"),
				 tr("Add binary file"),
				 SLOT(addSelectedBinFiles()));
  
  M_CREATENEWFILE = new MenuItem(Menu::NONCVSFILE,findEmbeddedPixmap("FileUnknown16x16"),
				 tr("Create new file"),
				 SLOT(createNewFile()));
  
  M_CREATENEWDIR = new MenuItem(Menu::NONCVSFILE,findEmbeddedPixmap("FolderClosed16x16"),
				tr("Create new dir"),
				SLOT(createNewDir()));

  M_DELETENONCVSFROMDISKFILE = new MenuItem(Menu::NONCVSFILE,findEmbeddedPixmap ("Delete16x16"),
					    tr("Delete from disk"),
					    SLOT(removeNonCvsFileFromDisk()));

  M_DELETEIGNOREFROMDISKFILE = new MenuItem(Menu::IGNOREFILE,findEmbeddedPixmap ("Delete16x16"),
					    tr("Delete from disk"),
					    SLOT(removeCvsIgnoreFileFromDisk()));

  M_ADDPROJECT = new MenuItem(Menu::PROJECT, tr("Add project to workbench ..."),SLOT( slot_addProject()) );

  M_CHECKOUTPROJECT = new MenuItem(Menu::PROJECT, tr("Checkout ..."),SLOT( slot_checkOut()) );

  M_IMPORTPROJECT = new MenuItem(Menu::PROJECT, tr("Import ..."),SLOT( slot_import()) );

  M_EXPORTPROJECT = new MenuItem(Menu::PROJECT, tr("Export ..."),SLOT( slot_export()) );

  M_EXITPROJECT = new MenuItem(Menu::PROJECT, tr("Exit"),SLOT( close()) );

  M_SETTINGSOPTIONS = new MenuItem(Menu::OPTIONS, tr("Settings ..."),SLOT( slot_settings()) );

  M_PROFILESOPTIONS = new MenuItem(Menu::OPTIONS, tr("Profiles ..."),SLOT( slot_profiles()) );

  M_KEYSHORTCUTSOPTIONS = new MenuItem(Menu::OPTIONS, tr("Keyboard shortcuts ..."),SLOT( slot_customizeKeyShortcuts()) );

  M_OPENFILEMAPPINGOPTIONS = new MenuItem(Menu::OPTIONS, tr("Open file mapping ..."),SLOT( slot_customizeOpenFileMapping()) );

  M_VIEWFILEMAPPINGOPTIONS = new MenuItem(Menu::OPTIONS, tr("View file mapping ..."),SLOT( slot_customizeViewFileMapping()) );

  M_REFRESHOPTIONS = new MenuItem(Menu::OPTIONS, tr("Refresh"),SLOT( slot_refreshAll()) );

  M_HELP = new MenuItem(Menu::HELP, tr("Help ..."),SLOT( slot_help()) );

  M_ONLINEHELP = new MenuItem(Menu::HELP, tr("Online cvs help"),SLOT( slot_onlineHelp()) );

  M_DEBUGLOGHELP = new MenuItem(Menu::HELP, tr("Write bugreport ..."),SLOT( slot_debug()) );

  M_ABOUTHELP = new MenuItem(Menu::HELP, tr("About ..."),SLOT( slot_about()) );

  M_ABOUTQTHELP = new MenuItem(Menu::HELP, tr("About Qt ..."),SLOT( slot_aboutQt()) );

  M_RENAMEDIR = new MenuItem(Menu::DIR, tr("Rename project (solely local)"),SLOT( slot_renameLocalDir()) );

  M_COPYFILE = new MenuItem(Menu::FILE, tr("Copy"),SLOT(slot_copyFile()));

  M_PASTE = new MenuItem(Menu::DIR, tr("Paste"),SLOT(slot_paste()) );

  M_MERGEDIR = new MenuItem(Menu::DIR, findEmbeddedPixmap("merge_16x16"), tr("Merge ..."), SLOT( mergeDir()));

  M_MERGEFILE = new MenuItem(Menu::FILE, findEmbeddedPixmap("merge_16x16"), tr("Merge ..."), SLOT( mergeFile()));

  M_COPYOUTPUT = new MenuItem(Menu::OUTPUT, tr("Copy"), SLOT(copyOutput()));

  M_SELECTALLOUTPUT = new MenuItem(Menu::OUTPUT, tr("Select All"), SLOT(selectAllOutput()));

  M_TOGGLESHOWALLOUTPUT = new MenuItem(Menu::OUTPUT, tr("Toggle show all"), SLOT(toggleShowAllOutput()));

  M_CREATEPATCHDIR = new MenuItem(Menu::DIR, tr("Create patch"), SLOT(slot_createPatch()));

  M_LOGTREEDIR = new MenuItem(Menu::DIR, findEmbeddedPixmap("LogTree16x16"), tr("Log tree"), SLOT( logDir()));

  M_IMPORTVENDORDIR = new MenuItem(Menu::DIR, tr("Import Vendor ..."), SLOT(slot_importVendor()));

  M_RENAMENONCVSFILE = new MenuItem(Menu::FILE, tr("Rename non-cvs ..."), SLOT(slot_renameNonCvsFile()));

  M_REMOVECVSBACKED = new MenuItem(Menu::DIR, tr("Remove .#xxx files"), SLOT(slot_removeCvsBackedFiles()));

  //put additional MenuItems here:
  //M_NEWITEM = new MenuItem( tr("the_new_item_txt"), SLOT(newslot()));

  //create parent<->child dependencies here
  M_REMOVEFROMREPANDDISKDIR->setParent(M_REMOVE);
  M_REMOVEFROMDISKDIR->setParent(M_REMOVE);

  M_REMOVEFROMDISK->setParent(M_REMOVEFILE);
  M_REMOVEFROMREP->setParent(M_REMOVEFILE);
  M_REMOVEFROMREPANDDISK->setParent(M_REMOVEFILE);

  //create default choice for cvsdirlistview
  //use alphabetical order here
  allDirPopupMenuItems = new QVector<MenuItem>(1);
  allDirPopupMenuItems->insert(0,M_SEPARATOR);

  MenuItem * item = MenuItem::firstSorted();
  do {
    if ( item->menu() == Menu::DIR ) {
      if (item->getParent()) continue;
      unsigned int pos = allDirPopupMenuItems->count();
      allDirPopupMenuItems->resize(pos+1);
      allDirPopupMenuItems->insert(pos,item);
    }
  } while ( (item = item->nextSortedItem()) );

  //read menu for cvsdirlistview from cfg
  dirPopupMenu = new QPopupMenu(this);
  connect(dirPopupMenu,SIGNAL(aboutToShow ()),this,SLOT(fillDirPopupMenu()));
  QString menuContent = DIRPOPUPMENU;

  int count = menuContent.contains(':');
  if (count==0) {//fallback to default - should never happen
    menuContent = DEFDIRPOPUPMENU; //"29:17:27:11:26:35:0:31:37:26:13:14:26:8:33:10:26:9:6:25:23:26:19:21:20:26:16:26:2:";
    DIRPOPUPMENU = menuContent;// otherwise no entries are written to cfg
    count = menuContent.contains(':');
  }

  menuContent.truncate(menuContent.length());
  dirPopupMenuItems = new QVector<MenuItem>(count);
  
  unsigned int size = 0;
  unsigned int i;
  for (i = 0; i<(unsigned int)count; i++) {
    int z = menuContent.find(':');
    int id = menuContent.left(z).toInt();
    MenuItem *tmp = MenuItem::getInstance(id);
    if (tmp) {
      bool hasParent = FALSE;
      MenuItem * parent = tmp->getParent();//in case new parent<->child relations are set up, this is needed to keep old user configuration working
      while (parent) {
	hasParent = TRUE;
	tmp = parent;
	parent = parent->getParent();
      }
      if  ( (!hasParent) || (dirPopupMenuItems->find(tmp) == -1) ) {
	dirPopupMenuItems->insert(size++,tmp);
      }
    }
    menuContent=menuContent.mid(z+1);
  }
  dirPopupMenuItems->resize(size);
  
  //create default choice for cvsfilelistview
  allFilePopupMenuItems = new QVector<MenuItem>(1);
  allFilePopupMenuItems->insert(0,M_SEPARATOR);

  item = MenuItem::firstSorted();
  do {
    if ( item->menu() == Menu::FILE ) {
      if (item->getParent()) continue;
      unsigned int pos = allFilePopupMenuItems->count();
      allFilePopupMenuItems->resize(pos+1);
      allFilePopupMenuItems->insert(pos,item);
    }
  } while ( (item = item->nextSortedItem()) );
  
  //read menu for cvsfilelistview from cfg
  filePopupMenu = new QPopupMenu(this);
  connect(filePopupMenu,SIGNAL(aboutToShow ()),this,SLOT(fillFilePopupMenu()));
  menuContent = FILEPOPUPMENU;
  
  count = menuContent.contains(':');
  
  if (count==0) {//fallback to default - should never happen
    menuContent = DEFFILEPOPUPMENU; //"30:18:28:12:26:15:4:5:26:36:1:32:38:26:7:34:26:24:22:26:3:";
    FILEPOPUPMENU = menuContent;// otherwise no entries are written to cfg
    count = menuContent.contains(':');
  }
  
  menuContent.truncate(menuContent.length());
  filePopupMenuItems = new QVector<MenuItem>(count);
  size = 0;
  for (i = 0; i<(unsigned int)count; i++) {
    int z = menuContent.find(':');
    int id = menuContent.left(z).toInt();
    MenuItem *tmp = MenuItem::getInstance(id);
    if (tmp) {
      bool hasParent = FALSE;
      MenuItem * parent = tmp->getParent();//in case new parent<->child relations are set up, this is needed to keep old user configuration working
      while (parent) {
	hasParent = TRUE;
	tmp = parent;
	parent = parent->getParent();
      }
      if ( (!hasParent) || (filePopupMenuItems->find(tmp) == -1) ) {
	filePopupMenuItems->insert(size++,tmp);
      }
    }
    menuContent = menuContent.mid(z+1);
  }
  filePopupMenuItems->resize(size);
  
  //setup key-shortcuts
  menuContent = KEYBOARDSHORTCUTS;
  count = menuContent.contains(':');
  for (i = 0; i<(unsigned int)count; i++) {
    int z = menuContent.find(':');
    QString h = menuContent.left(z);
    int sep = h.find(',');
    int id = h.left(sep).toInt();
    int accel = h.mid(sep+1).toInt();
    MenuItem *tmp = MenuItem::getInstance(id);
    if (tmp) MenuItem::setAccel(tmp,accel);
    menuContent = menuContent.mid(z+1);
  }
  
}

//----------------------------------------------------------------------------

//never set a new m_pCurCvsDir here since this gets called when a dir 
//is deleted and the selection changes
void ApplicationWindow::setMenuItemState(bool show) {

  //dir
  bool enabled = FALSE;
  bool dirSelected = FALSE;
  bool cvsControlled = FALSE;
  bool topDir = FALSE;
  bool topCvsDir = FALSE;
  bool hasClipboardData = FALSE;

  //files
  bool cvsItemSelected = FALSE;
  bool nonCvsItemSelected = FALSE;
  bool ignoreItemSelected = FALSE;
  bool onlyRemovedFilesSelected = FALSE;
  bool isDir = FALSE;
  bool isFilesAndDirs = FALSE;
  bool multiFileSelection = FALSE;

  if (show) {

#ifndef NO_CLIPBOARD
    if (QApplication::clipboard()
	&& QApplication::clipboard()->data(QClipboard::Clipboard)
	&& QUriDrag::canDecode(QApplication::clipboard()->data(QClipboard::Clipboard) ) ) {
      hasClipboardData = TRUE;
    }
#endif

    Directory * dir = m_pWorkBenchTree->selectedItem();
    if (dir) {

      //------------ dir
      dirSelected = TRUE;
      if (!dir->isDisabled()) {
	enabled = TRUE;
      }
      if (dir->isCvsControlled()) {
	cvsControlled = TRUE;
      }
      if (dir == dir->topDir()) {
	topDir = TRUE;
      }
      if (dir == dir->topCvsDir()) {
	topCvsDir = TRUE;
      }

      //----------- file
      int count = selectCount(2);
      switch( m_pFileViews->currentPageIndex()) {

	case 0: {// cvs-fileview
	  if (count > 0) {
	    cvsItemSelected = TRUE;
	    if (count > 1) {
	      multiFileSelection = TRUE;
	    }
	    if (checkOnlyRemovedFilesSelected()) {
	      onlyRemovedFilesSelected = TRUE;
	    }
	  }
	  break;
	}
	case 1: {// non-cvsview
	  if (count > 0) {
	    nonCvsItemSelected = TRUE;
	    if (count > 1) {
	      multiFileSelection = TRUE;
	    }
	    if (isDirsSelected()) {
	      isDir = TRUE;
	      if ( multiFileSelection && isFilesAndDirsSelected()) {
		isFilesAndDirs = TRUE;
	      }
	    }
	  }
	  break;
	}
	case 2: {// cvs-ignoreview
	  if (count > 0) {
	    ignoreItemSelected = TRUE;
	    if (isDirsSelected()) {
	      isDir = TRUE;
	      if ( (count > 1) && isFilesAndDirsSelected()) {
		isFilesAndDirs = TRUE;
	      }
	    }
	  }
	  break;
	}
	default: {
	  qDebug("There is no such page index: "+QString::number( m_pFileViews->currentPageIndex())+" implemented");
	  return;
	}
      }
    }
  }

  //now set states

  //dir
  M_PASTE->setEnabled(hasClipboardData);
  M_STATUS->setEnabled(enabled && cvsControlled);
  M_QUERYUPDATE->setEnabled(enabled && cvsControlled);
  M_QUERYUPDATEALL->setEnabled(enabled && cvsControlled);
  M_SHOWEDITORS->setEnabled(enabled && cvsControlled);
  M_SHOWWATCHERSDIR->setEnabled(enabled && cvsControlled);
  M_HISTORY->setEnabled(enabled && cvsControlled);

  M_UPDATE->setEnabled(enabled && cvsControlled);
  M_UPDATEALL->setEnabled(enabled && cvsControlled);
  M_REPLACEDIR->setEnabled(enabled && cvsControlled);
  M_REPLACEALLDIR->setEnabled(enabled && cvsControlled);
  M_COMMIT->setEnabled(enabled && cvsControlled);
  M_MERGEDIR->setEnabled(enabled && cvsControlled);
  M_LOGTREEDIR->setEnabled(enabled && cvsControlled);
  M_TAG->setEnabled(enabled && cvsControlled);
  M_DIFFTOCONSOLEDIR->setEnabled(enabled && cvsControlled);
  M_ADVDIFFTOCONSOLEDIR->setEnabled(enabled && cvsControlled);
  M_CREATEPATCHDIR->setEnabled(enabled && cvsControlled);
  M_UPDATEOTHER->setEnabled(enabled && cvsControlled);
  M_UPDATEDIRBRANCHDIR->setEnabled(enabled && cvsControlled);
  M_REMOVECVSBACKED->setEnabled(enabled);
  M_REMOVELOCALOPTIONSDIR->setEnabled(enabled && cvsControlled);

  M_LOGIN->setEnabled(enabled && cvsControlled);
  M_LOGOUT->setEnabled(enabled && cvsControlled);

  M_BROWSEDIR->setEnabled(enabled);
  M_OPENSHELLDIR->setEnabled(enabled);
  M_EXPANDDIR->setEnabled(enabled);
  M_COLLAPSDIR->setEnabled(enabled);

  M_EDITDIR->setEnabled(enabled && cvsControlled);
  M_UNEDITDIR->setEnabled(enabled && cvsControlled);

  M_LOCKDIR->setEnabled(enabled && cvsControlled);
  M_UNLOCKDIR->setEnabled(enabled && cvsControlled);

  M_ENABLEDIR->setEnabled(!enabled && dirSelected);
  M_DISABLEDIR->setEnabled(enabled);
  M_EXPORTDIR->setEnabled(enabled);
  M_IMPORTVENDORDIR->setEnabled(enabled && cvsControlled);
  M_REREADDIR->setEnabled(enabled);
  M_REMOVEFROMWORKBENCH->setEnabled(dirSelected && topDir);
  M_RELEASE->setEnabled(enabled && dirSelected && topCvsDir);
  M_REMOVEFROMDISKDIR->setEnabled(enabled && cvsControlled);
  M_REMOVEFROMREPANDDISKDIR->setEnabled(enabled && cvsControlled);
  M_RELEASEANDREMOVE->setEnabled(enabled && cvsControlled);

  M_RENAMEDIR->setEnabled(dirSelected && topDir);

  M_PROPERTIES->setEnabled(dirSelected);

  switch( m_pFileViews->currentPageIndex()) {//cvs-controled files

    case 0: {
      M_OPENFILE->setEnabled( cvsItemSelected);
      M_VIEWFILE->setEnabled( cvsItemSelected);
      M_RESOLVE->setEnabled( !multiFileSelection && cvsItemSelected);

      M_COPYFILE->setEnabled( cvsItemSelected);

      M_STATUSFILE->setEnabled( cvsItemSelected);
      M_QUERYUPDATEFILE->setEnabled( cvsItemSelected);
      M_SHOWEDITORSFILE->setEnabled( cvsItemSelected);
      M_SHOWWATCHERSFILE->setEnabled( cvsItemSelected);
      M_HISTORYFILE->setEnabled( cvsItemSelected);
    
      M_LOGTREEFILE->setEnabled( cvsItemSelected);
      M_DIFFSIDEBYSIDEFILE->setEnabled( !multiFileSelection && cvsItemSelected);
      M_DIFFTOCONSOLEFILE->setEnabled( cvsItemSelected);
      M_ADVDIFFTOCONSOLEFILE->setEnabled( cvsItemSelected);
    
      M_ADDFILE->setEnabled( cvsItemSelected && onlyRemovedFilesSelected);
      M_UPDATEFILE->setEnabled( cvsItemSelected);
      M_REPLACEFILE->setEnabled( cvsItemSelected);
      M_COMMITFILE->setEnabled( cvsItemSelected);
      M_MERGEFILE->setEnabled( cvsItemSelected);
      M_TAGFILE->setEnabled( cvsItemSelected);
      M_UPDATEOTHERFILE->setEnabled( cvsItemSelected);
      M_UPDATEDIRBRANCHFILE->setEnabled( cvsItemSelected);
      M_REMOVELOCALOPTIONSFILE->setEnabled( cvsItemSelected);
    
      M_EDITFILE->setEnabled( cvsItemSelected);
      M_UNEDITFILE->setEnabled( cvsItemSelected);
    
      M_LOCKFILE->setEnabled( !multiFileSelection && cvsItemSelected);
      M_UNLOCKFILE->setEnabled( !multiFileSelection && cvsItemSelected);
    
      M_RENAMEFILE->setEnabled( !multiFileSelection && cvsItemSelected);

      M_REMOVEFROMDISK->setEnabled( cvsItemSelected);
      M_REMOVEFROMREP->setEnabled( cvsItemSelected);
      M_REMOVEFROMREPANDDISK->setEnabled( cvsItemSelected);
      
      break;
    }
    case 1: {//non-cvs files
      M_OPENFILE->setEnabled( !isDir && !isFilesAndDirs);
      M_VIEWFILE->setEnabled( !isDir && !isFilesAndDirs);

      M_COPYFILE->setEnabled( nonCvsItemSelected && !isDir && !isFilesAndDirs);

      M_ADDFOLDER->setEnabled( cvsControlled && isDir && !isFilesAndDirs);
      M_ADDASCIIFILE->setEnabled( cvsControlled && !isDir && !isFilesAndDirs);
      M_ADDBINARYFILE->setEnabled( cvsControlled && !isDir && !isFilesAndDirs);

      M_RENAMENONCVSFILE->setEnabled( !multiFileSelection && nonCvsItemSelected);
      M_DELETENONCVSFROMDISKFILE->setEnabled( true);

      M_CREATENEWFILE->setEnabled( true);
      M_CREATENEWDIR->setEnabled( true);

      break;
    }
    case 2: {//ignored files
      M_OPENFILE->setEnabled( ignoreItemSelected && !isDir && !isFilesAndDirs);
      M_VIEWFILE->setEnabled( ignoreItemSelected && !isDir && !isFilesAndDirs);

      M_COPYFILE->setEnabled( ignoreItemSelected && !isDir && !isFilesAndDirs);
      
      M_ADDFOLDER->setEnabled( cvsControlled && ignoreItemSelected && isDir && !isFilesAndDirs);
      M_ADDASCIIFILE->setEnabled( cvsControlled && ignoreItemSelected && !isDir && !isFilesAndDirs);
      M_ADDBINARYFILE->setEnabled( cvsControlled && ignoreItemSelected && !isDir && !isFilesAndDirs);
      
      M_DELETEIGNOREFROMDISKFILE->setEnabled( ignoreItemSelected);

      break;
    }
    default: {}
  };

}

//----------------------------------------------------------------------------

void ApplicationWindow::fillProjectMenu() {

  m_pProjectMenu->clear();
  MenuItem * item = MenuItem::first();
  do {
    if (item->menu() == Menu::PROJECT ) {
	insertMenuItem(m_pProjectMenu,item);
    }
    if (item == M_EXPORTPROJECT) {
      insertMenuItem(m_pProjectMenu,M_SEPARATOR);
    }
  } while ( (item = item->nextItem()) );
}

//----------------------------------------------------------------------------

//never set a new m_pCurCvsDir here since this gets called when a dir 
//is deleted and the selection changes
void ApplicationWindow::fillDirMenu(bool show) {

  m_pDirMenu->clear();

  if (show) {
    Directory * dir = m_pWorkBenchTree->selectedItem();
    if ( dir && dir->isVirtual()) {
      insertMenuItem( m_pDirMenu, M_UPDATEVIRTUALDIR);
      return;
    } else {

      insertMenuItem( m_pDirMenu, M_PASTE);

      insertMenuItem( m_pDirMenu, M_SEPARATOR);

      QPopupMenu * projectSubMenu = new QPopupMenu(this);//create submenu 'Project'
      insertMenuItem( projectSubMenu, M_REMOVEFROMWORKBENCH);
      insertMenuItem( projectSubMenu, M_RENAMEDIR);
      insertMenuItem( projectSubMenu, M_SEPARATOR);
      insertMenuItem( projectSubMenu, M_LOGIN);
      insertMenuItem( projectSubMenu, M_LOGOUT);
      insertMenuItem( projectSubMenu, M_SEPARATOR);
      insertMenuItem( projectSubMenu, M_PROPERTIES);
      m_pDirMenu->insertItem(tr("Project"),projectSubMenu);

      insertMenuItem( m_pDirMenu, M_SEPARATOR);

      QPopupMenu * stateSubMenu = new QPopupMenu(this);//create submenu 'State'
      insertMenuItem( stateSubMenu, M_STATUS);
      insertMenuItem( stateSubMenu, M_HISTORY);
      insertMenuItem( stateSubMenu, M_SEPARATOR);
      insertMenuItem( stateSubMenu, M_LOGTREEDIR);
      insertMenuItem( stateSubMenu, M_SEPARATOR);
      insertMenuItem( stateSubMenu, M_SHOWEDITORS);
      insertMenuItem( stateSubMenu, M_SHOWWATCHERSDIR);
      m_pDirMenu->insertItem(tr("State"),stateSubMenu);

      insertMenuItem( m_pDirMenu, M_SEPARATOR);

      QPopupMenu * importSubMenu = new QPopupMenu(this);//create submenu 'Import/Export'
      insertMenuItem( importSubMenu, M_IMPORTVENDORDIR);
      insertMenuItem( importSubMenu, M_EXPORTDIR);
      m_pDirMenu->insertItem(tr("Import/Export"),importSubMenu);

      QPopupMenu * subMenu = new QPopupMenu(this);//create submenu 'Update'
      insertMenuItem( subMenu, M_QUERYUPDATE);
      insertMenuItem( subMenu, M_QUERYUPDATEALL);
      insertMenuItem( subMenu, M_SEPARATOR);
      insertMenuItem( subMenu, M_UPDATE);
      insertMenuItem( subMenu, M_UPDATEALL);
      insertMenuItem( subMenu, M_SEPARATOR);
      insertMenuItem( subMenu, M_REPLACEDIR);
      insertMenuItem( subMenu, M_REPLACEALLDIR);
      insertMenuItem( subMenu, M_SEPARATOR);
      insertMenuItem( subMenu, M_UPDATEDIRBRANCHDIR);
      insertMenuItem( subMenu, M_UPDATEOTHER);
      m_pDirMenu->insertItem(tr("Update"),subMenu);

      insertMenuItem( m_pDirMenu, M_SEPARATOR);

      insertMenuItem( m_pDirMenu, M_COMMIT);
      insertMenuItem( m_pDirMenu, M_MERGEDIR);
      insertMenuItem( m_pDirMenu, M_TAG);

      insertMenuItem( m_pDirMenu, M_SEPARATOR);

      QPopupMenu * diffSubMenu = new QPopupMenu(this);//create submenu 'Diff/Patch'
      insertMenuItem( diffSubMenu, M_DIFFTOCONSOLEDIR);
      insertMenuItem( diffSubMenu, M_ADVDIFFTOCONSOLEDIR);
      insertMenuItem( diffSubMenu, M_CREATEPATCHDIR);
      m_pDirMenu->insertItem(tr("Diff/Patch"),diffSubMenu);

      insertMenuItem( m_pDirMenu, M_SEPARATOR);

      insertMenuItem( m_pDirMenu, M_BROWSEDIR);
      insertMenuItem( m_pDirMenu, M_OPENSHELLDIR);

      insertMenuItem( m_pDirMenu, M_SEPARATOR);

      insertMenuItem( m_pDirMenu, M_ENABLEDIR);
      insertMenuItem( m_pDirMenu, M_DISABLEDIR);

      insertMenuItem( m_pDirMenu, M_SEPARATOR);

      insertMenuItem( m_pDirMenu, M_EXPANDDIR);
      insertMenuItem( m_pDirMenu, M_COLLAPSDIR);

      insertMenuItem( m_pDirMenu, M_SEPARATOR);

      QPopupMenu * editSubMenu = new QPopupMenu(this);//create submenu 'Edit/Unedig'
      insertMenuItem( editSubMenu, M_EDITDIR);
      insertMenuItem( editSubMenu, M_UNEDITDIR);
      m_pDirMenu->insertItem(tr("Edit/Unedit"),editSubMenu);

      insertMenuItem( m_pDirMenu, M_SEPARATOR);

      insertMenuItem( m_pDirMenu, M_RELEASE);
      insertMenuItem( m_pDirMenu, M_RELEASEANDREMOVE);
      insertMenuItem( m_pDirMenu, M_REMOVE);

      insertMenuItem( m_pDirMenu, M_SEPARATOR);

      QPopupMenu * lockSubMenu = new QPopupMenu(this);//create submenu 'Lock/Unlock'
      insertMenuItem( lockSubMenu, M_LOCKDIR);
      insertMenuItem( lockSubMenu, M_UNLOCKDIR);
      m_pDirMenu->insertItem(tr("Lock/Unlock"),lockSubMenu);

      insertMenuItem( m_pDirMenu, M_SEPARATOR);

      insertMenuItem( m_pDirMenu, M_REREADDIR);
      insertMenuItem( m_pDirMenu, M_REMOVECVSBACKED);
      insertMenuItem( m_pDirMenu, M_REMOVELOCALOPTIONSDIR);

      insertMenuItem( m_pDirMenu, M_SEPARATOR);

      insertMenuItem( m_pDirMenu, M_CUSTOMIZE);
    }
  }

  if (Debug::g_bDebug) {//testing only, do !not! remove
    insertMenuItem( m_pDirMenu, M_SEPARATOR);
    insertMenuItem( m_pDirMenu, M_TEST);
  }
}

//----------------------------------------------------------------------------

//never set a new m_pCurCvsDir here since this gets called when a dir 
//is deleted and the selection changes
void ApplicationWindow::fillFileMenu(bool show) {

  m_pFileMenu->clear();

  if (show) {
    switch( m_pFileViews->currentPageIndex()) {

      case 0: {// cvsview

	if ( checkOnlyVirtualDirFileItemsSelected() ) {
	  insertMenuItem( m_pFileMenu, M_UPDATEVIRTUALDIR);
	  break;
	} else {

	  insertMenuItem( m_pFileMenu, M_COPYFILE);

	  insertMenuItem( m_pFileMenu, M_SEPARATOR);

	  insertMenuItem( m_pFileMenu, M_OPENFILE);
	  insertMenuItem( m_pFileMenu, M_VIEWFILE);

	  insertMenuItem( m_pFileMenu, M_SEPARATOR);

	  QPopupMenu * stateSubMenu = new QPopupMenu(this);//create submenu 'State'
	  insertMenuItem( stateSubMenu, M_STATUSFILE);
	  insertMenuItem( stateSubMenu, M_HISTORYFILE);
	  insertMenuItem( stateSubMenu, M_SEPARATOR);
	  insertMenuItem( stateSubMenu, M_SHOWEDITORSFILE);
	  insertMenuItem( stateSubMenu, M_SHOWWATCHERSFILE);
	  insertMenuItem( stateSubMenu, M_SEPARATOR);
	  insertMenuItem( stateSubMenu, M_LOGTREEFILE);
	  m_pFileMenu->insertItem(tr("State"),stateSubMenu);

	  insertMenuItem( m_pFileMenu, M_SEPARATOR);

	  QPopupMenu * subMenu = new QPopupMenu(this);//create submenu 'Update'
	  insertMenuItem( subMenu, M_QUERYUPDATEFILE);
	  insertMenuItem( subMenu, M_SEPARATOR);
	  insertMenuItem( subMenu, M_UPDATEFILE);
	  insertMenuItem( subMenu, M_REPLACEFILE);
	  insertMenuItem( subMenu, M_SEPARATOR);
	  insertMenuItem( subMenu, M_UPDATEDIRBRANCHFILE);
	  insertMenuItem( subMenu, M_UPDATEOTHERFILE);
	  m_pFileMenu->insertItem(tr("Update"),subMenu);

	  insertMenuItem( subMenu, M_ADDFILE);

	  insertMenuItem( m_pFileMenu, M_SEPARATOR);

	  insertMenuItem( m_pFileMenu, M_COMMITFILE);
	  insertMenuItem( m_pFileMenu, M_MERGEFILE);
	  insertMenuItem( m_pFileMenu, M_TAGFILE);

	  insertMenuItem( m_pFileMenu, M_SEPARATOR);

	  QPopupMenu * diffSubMenu = new QPopupMenu(this);//create submenu 'Diff/Patch'
	  insertMenuItem( diffSubMenu, M_DIFFSIDEBYSIDEFILE);
	  insertMenuItem( diffSubMenu, M_DIFFTOCONSOLEFILE);
	  insertMenuItem( diffSubMenu, M_ADVDIFFTOCONSOLEFILE);
	  m_pFileMenu->insertItem(tr("Diff/Patch"),diffSubMenu);

	  insertMenuItem( m_pFileMenu, M_SEPARATOR);

	  insertMenuItem( m_pFileMenu, M_EDITFILE);
	  insertMenuItem( m_pFileMenu, M_UNEDITFILE);

	  insertMenuItem( m_pFileMenu, M_SEPARATOR);

	  insertMenuItem( m_pFileMenu, M_RENAMEFILE);
	  insertMenuItem( m_pFileMenu, M_REMOVEFILE);

	  insertMenuItem( m_pFileMenu, M_SEPARATOR);

	  QPopupMenu * lockSubMenu = new QPopupMenu(this);//create submenu 'Lock/Unlock'
	  insertMenuItem( lockSubMenu, M_LOCKFILE);
	  insertMenuItem( lockSubMenu, M_UNLOCKFILE);
	  m_pFileMenu->insertItem(tr("Lock/Unlock"),lockSubMenu);

	  insertMenuItem( m_pFileMenu, M_SEPARATOR);

	  insertMenuItem( m_pFileMenu, M_RESOLVE);
	  insertMenuItem( m_pFileMenu, M_REMOVELOCALOPTIONSFILE);

	  insertMenuItem( m_pFileMenu, M_SEPARATOR);

	  insertMenuItem( m_pFileMenu, M_CUSTOMIZEFILE);

	}
	break;
      }

      case 1: {// non-cvsview

	if ( selectCount(1) > 0) {

	  insertMenuItem( m_pFileMenu, M_COPYFILE);

	  insertMenuItem( m_pFileMenu, M_SEPARATOR);

	  insertMenuItem( m_pFileMenu, M_OPENFILE);
	  insertMenuItem( m_pFileMenu, M_VIEWFILE);

	  insertMenuItem( m_pFileMenu, M_SEPARATOR);

	  insertMenuItem( m_pFileMenu, M_ADDFOLDER);
	  insertMenuItem( m_pFileMenu, M_ADDASCIIFILE);
	  insertMenuItem( m_pFileMenu, M_ADDBINARYFILE);

	  insertMenuItem( m_pFileMenu, M_SEPARATOR);

	  insertMenuItem( m_pFileMenu, M_RENAMENONCVSFILE);
	  insertMenuItem( m_pFileMenu, M_DELETENONCVSFROMDISKFILE);

	  insertMenuItem( m_pFileMenu, M_SEPARATOR);

	} else {

	  insertMenuItem( m_pFileMenu, M_CREATENEWFILE);
	  insertMenuItem( m_pFileMenu, M_CREATENEWDIR);
	}
	break;
      }

      case 2: {// cvs-ignoreview

	insertMenuItem( m_pFileMenu, M_COPYFILE);

	insertMenuItem( m_pFileMenu, M_SEPARATOR);

	insertMenuItem( m_pFileMenu, M_OPENFILE);
	insertMenuItem( m_pFileMenu, M_VIEWFILE);
      
	insertMenuItem( m_pFileMenu, M_SEPARATOR);
      
	insertMenuItem( m_pFileMenu, M_ADDFOLDER);
	insertMenuItem( m_pFileMenu, M_ADDASCIIFILE);
	insertMenuItem( m_pFileMenu, M_ADDBINARYFILE);

	insertMenuItem( m_pFileMenu, M_SEPARATOR);

	insertMenuItem( m_pFileMenu, M_DELETEIGNOREFROMDISKFILE);

	break;
      }

      default: {
	return;
      }
    }
  }
}

//----------------------------------------------------------------------------


void ApplicationWindow::fillOptionsMenu() {

  m_pOptionsMenu->clear();
  MenuItem * item = MenuItem::first();
  do {
    bool inserted = FALSE;
    if (item->menu() == Menu::OPTIONS ) {
      insertMenuItem(m_pOptionsMenu,item);
      inserted = TRUE;
    }
    if (inserted && (item == M_VIEWFILEMAPPINGOPTIONS || item == M_AUTOREFRESHOPTIONS) ) {
      insertMenuItem(m_pOptionsMenu,M_SEPARATOR);
    }
  } while ( (item = item->nextItem()) );
}

//----------------------------------------------------------------------------


void ApplicationWindow::fillHelpMenu() {

  m_pHelpMenu->clear();
  MenuItem * item = MenuItem::first();
  do {
    if (item->menu() == Menu::HELP ) {
      insertMenuItem(m_pHelpMenu,item);
    }
    if (item == M_DEBUGLOGHELP ) {
      insertMenuItem(m_pHelpMenu,M_SEPARATOR);
    }
  } while ( (item = item->nextItem()) );
}

//----------------------------------------------------------------------------

void ApplicationWindow::fillDirPopupMenu() {
  
  dirPopupMenu->clear();

  Directory * dir = m_pWorkBenchTree->selectedItem();
  if (dir) {
    if (dir->isVirtual() ) {
      insertMenuItem(dirPopupMenu,M_UPDATEVIRTUALDIR);
    } else {
      unsigned int i;
      for( i = 0; i < dirPopupMenuItems->size(); i++ ) {
	MenuItem * item = dirPopupMenuItems->at(i);
	insertMenuItem(dirPopupMenu,item);
      }
    }
  }
}

//----------------------------------------------------------------------------

void ApplicationWindow::fillFilePopupMenu() {

  filePopupMenu->clear();
  Directory * dir = m_pWorkBenchTree->selectedItem();

  if (dir) {

    switch( m_pFileViews->currentPageIndex()) {

      case 0: {// cvsview

	if ( selectCount(1)) {       
	  if ( checkOnlyVirtualDirFileItemsSelected() ) {
	    insertMenuItem(filePopupMenu,M_UPDATEVIRTUALDIR);
	  } else {
	    unsigned int i;
	    for( i = 0; i<filePopupMenuItems->size(); i++ ) {
	      insertMenuItem(filePopupMenu,filePopupMenuItems->at(i));
	    }
	  }
	}
	break;
      }
      case 1: {

	if ( selectCount(1) > 0) {
	  insertMenuItem( filePopupMenu, M_OPENFILE);
	  insertMenuItem( filePopupMenu, M_VIEWFILE);
	  
	  insertMenuItem( filePopupMenu, M_SEPARATOR);
	  
	  insertMenuItem( filePopupMenu, M_ADDFOLDER);
	  insertMenuItem( filePopupMenu, M_ADDASCIIFILE);
	  insertMenuItem( filePopupMenu, M_ADDBINARYFILE);
	  
	  insertMenuItem( filePopupMenu, M_SEPARATOR);
	  
	  insertMenuItem( filePopupMenu, M_RENAMENONCVSFILE);
	  insertMenuItem( filePopupMenu, M_DELETENONCVSFROMDISKFILE);
	  
	  insertMenuItem( filePopupMenu, M_SEPARATOR);
	  
	} else {
	  insertMenuItem( filePopupMenu, M_CREATENEWFILE);
	  insertMenuItem( filePopupMenu, M_CREATENEWDIR);
	}
	break;
      }
      case 2: {

	insertMenuItem( filePopupMenu, M_OPENFILE);
	insertMenuItem( filePopupMenu, M_VIEWFILE);
	
	insertMenuItem( filePopupMenu, M_SEPARATOR);
	
	insertMenuItem( filePopupMenu, M_ADDFOLDER);
	insertMenuItem( filePopupMenu, M_ADDASCIIFILE);
	insertMenuItem( filePopupMenu, M_ADDBINARYFILE);
	
	insertMenuItem( filePopupMenu, M_SEPARATOR);
	
	insertMenuItem( filePopupMenu, M_DELETEIGNOREFROMDISKFILE);
	break;
      }
      default: {}
    }
  }
}

//----------------------------------------------------------------------------

void ApplicationWindow::fillOutputPopupMenu(int mode) {

  m_pOutputMenu = new QPopupMenu(this);
  
  bool hasText = !m_pMessages->text().isEmpty();
  M_COPYOUTPUT->setEnabled(hasText);
  M_SELECTALLOUTPUT->setEnabled(hasText);
  M_TOGGLESHOWALLOUTPUT->setEnabled(mode == CCvsOutput::QUIET);

  MenuItem * item = MenuItem::first();
  do {
    if (item->menu() == Menu::OUTPUT ) {
      insertMenuItem(m_pOutputMenu,item);
    }
  } while ( (item = item->nextItem()) );
}

//----------------------------------------------------------------------------

void ApplicationWindow::copyOutput() {
  m_pMessages->copy();
}

//----------------------------------------------------------------------------

void ApplicationWindow::selectAllOutput() {
  m_pMessages->selectAll(TRUE);
}

//----------------------------------------------------------------------------

void ApplicationWindow::toggleShowAllOutput() {
  m_pMessages->toggleShowAll();
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_renameNonCvsFile() {

  if (!(m_pCurCvsDir = getSelectedDir())) {
    return;
  }

  QStringList list = getSelectedFilesList();
  if (list.isEmpty()) return;

  QString fname = list[0];
  bool ok;
  QString newName = QInputDialog::getText(tr("Rename"), tr("New name: "),
					  QLineEdit::Normal,
					  fname, &ok, this ).stripWhiteSpace();
  
  if( !ok || fname.isEmpty() || (fname == newName) ) {
    return;
  }
  QString path = m_pCurCvsDir->fullName()+"/";
  if (QFileInfo(path+newName).exists()) {
    if (!showOkCancelQuestion( tr("Rename"),
			       tr("Cannot rename file") + "\n"
			       + tr("File exists:") + "\n"
			       + path+newName + "\n\n"
			       + tr("Overwrite?") )) {
      return;
    }
  }
  
  if (!rename( path+fname, path+newName)) {
    showWarning(tr("Rename"),tr("Cannot rename:\n"+path+fname+",\ncheck permissions"));
  } else m_pCurCvsDir->activateItem(FALSE);
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_renameLocalDir() {

  if (!(m_pCurCvsDir = getSelectedDir())) {
    return;
  }

  QString fname = m_pCurCvsDir->shortName();
  bool ok;
  QString newName = QInputDialog::getText(tr("Rename"), tr("New name: "),
					  QLineEdit::Normal,
					  fname, &ok, this ).stripWhiteSpace();
  
  if( !ok || fname.isEmpty() || (fname == newName) ) {
    return;
  }
  
  blockGUI(true);
  QString path = m_pCurCvsDir->fullName().left(m_pCurCvsDir->fullName().findRev("/")+1);
  renameCurrentDir( path+newName);
  blockGUI(false);
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_createPatch() {

  if (!(m_pCurCvsDir = getSelectedDir())) {
    return;
  }

  bool ok;
  QString defaultName = m_pCurCvsDir->fullName()
    + "/" + m_pCurCvsDir->topCvsDir()->relativeName()
    + "-diff-"
    + QDateTime::currentDateTime().toString("yyyy-MM-dd-hh-mm-ss");

  QString patchFile = QInputDialog::getText(tr("Enter file name (default:") + defaultName + ")",
					    "Enter a file name for the patch file", QLineEdit::Normal,
					    defaultName, &ok, this, "Patch file dialog");

  if (!ok) return;

  QFile f(patchFile);
  if (f.exists()) {
    if (QMessageBox::warning (this, tr("Warning"), 
			      tr("The filename: ") + patchFile + tr(" allready exists.\nOverwrite it?"), 
			      QMessageBox::Yes , QMessageBox::No) != QMessageBox::Yes) return;
    
    f.remove();
  }
  
  createDirTreePatch(m_pCurCvsDir,patchFile);
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_copyFile() {

  m_pCurCvsDir = m_pWorkBenchTree->selectedItem();
  if (!m_pCurCvsDir) return;

  m_clipboardFileList = m_pFileViews->currentPage()->copyToClipboard();
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_paste() {

  m_pCurCvsDir = m_pWorkBenchTree->selectedItem();
  if (!m_pCurCvsDir) return;

  m_pWorkBenchTree->paste(m_clipboardFileList);
}

//----------------------------------------------------------------------------

void ApplicationWindow::showFileMenu( bool) {//bool param true if there are selected items
  //fill and set states on every selectionChanged(), since this affects the key-shortcuts
  setMenuItemState(TRUE);
  fillFileMenu(TRUE);
}

//----------------------------------------------------------------------------

void ApplicationWindow::setDirMenu( bool) {//bool param true if there are selected items
  //set states on every selectionChanged(), since this affects the key-shortcuts
  setMenuItemState(TRUE);
  fillDirMenu(TRUE);
  fillFileMenu(TRUE);
}

//----------------------------------------------------------------------------

void ApplicationWindow::clipboardDataChanged() {
  setMenuItemState(TRUE);
  fillDirMenu(TRUE);
  fillFileMenu(TRUE);
}

//----------------------------------------------------------------------------

bool ApplicationWindow::checkOnlyRemovedFilesSelected() {
   bool retval = true;
    
   QListViewItem *myChild = m_pCvsFileList->firstChild();
   while(myChild) {
      if(myChild->isSelected()) {
	  if (!myChild->text(4).stripWhiteSpace().startsWith("commit to remove")) {
	      retval = false;
	  }
      }
      myChild = myChild->nextSibling();
   }
   return retval;
}

//----------------------------------------------------------------------------

bool ApplicationWindow::checkOnlyVirtualDirFileItemsSelected() {
    
  bool retval = false;
   Directory * dir = m_pWorkBenchTree->selectedItem();
   if (dir) {
      QListViewItem *myChild = m_pCvsFileList->firstChild();
      while(myChild) {
         if(myChild->isSelected()) {
	    if (dir->getState(myChild->text(0)) != ES_missing_dir) {
	      return false;
	    } else {
	      retval = true;
	    }
	 }
	 myChild = myChild->nextSibling();
      }
   }
   return retval;
}

//----------------------------------------------------------------------------

int ApplicationWindow::selectCount(const int & max) {
   int retval = 0;
    
   FileListViewItem * myChild = m_pFileViews->currentFirstChild();
   while(myChild) {
      if(myChild->isSelected()) {
	++retval;
	if (retval >= max) {
	  return retval;
	}
      }
      myChild = myChild->nextSibling();
   }
   return retval;
}

//----------------------------------------------------------------------------

bool ApplicationWindow::isDirsSelected() {

  FileListViewItem * item = m_pFileViews->currentFirstChild();
  while (item) {
    if (item->isSelected() && item->isDir()) {
      return TRUE;
    }
    item = item->nextSibling();
  }
  return FALSE;
}

//----------------------------------------------------------------------------

bool ApplicationWindow::isFilesAndDirsSelected() {
  bool dirSelected = FALSE;
  bool fileSelected = FALSE;
  FileListViewItem * item = m_pFileViews->currentFirstChild();

  while (item && !( dirSelected && fileSelected)) {
    if (item->isSelected()) {
      if (item->isDir()) {
	dirSelected = TRUE;
      } else {
	fileSelected = TRUE;
      }
    }
    item = item->nextSibling();
  }
  return dirSelected && fileSelected;
}

//----------------------------------------------------------------------------

void ApplicationWindow::initComponents()
{
   resize( 600, 400 );

   
	/** Add workbench pane to the main window */
	CFlatSplitter *m_pHorzSplitter = new CFlatSplitter(
		CFlatSplitter::Horizontal, this);
	m_pHorzSplitter->setMargin(2);
	m_pWorkBenchTree = new CvsDirListView(dirPopupMenu, m_pHorzSplitter);
	m_pWorkBenchTree->setFocusPolicy(QWidget::StrongFocus);
	m_pWorkBenchTree->setRootIsDecorated(true);
	m_pWorkBenchTree->addColumn(tr("Workbench"));
	m_pWorkBenchTree->header()->hide();
	m_pWorkBenchTree->setColumnWidth(0, WORKBENCH_COLUMN_WIDTH);
	m_pTools->addWhatsThisText(m_pWorkBenchTree, m_pTools->wBench);
	setCentralWidget(m_pHorzSplitter);

	/** Restore horizontal widget positions */
	QValueList<int> HorzSplitterPos;
	HorzSplitterPos.append(SPLITTER_POS_H);
	m_pHorzSplitter->setResizeMode(m_pWorkBenchTree, CFlatSplitter::KeepSize);
	m_pHorzSplitter->setSizes(HorzSplitterPos);

	connect(m_pWorkBenchTree, SIGNAL(showDirMenu(bool)),
		SLOT(setDirMenu(bool)));
	connect(m_pWorkBenchTree, SIGNAL(setStatusText( const QString &, int)),
		this, SLOT(setStatusText( const QString &, int)));
	/** drag'n drop */
	connect(m_pWorkBenchTree, SIGNAL(folderDropped(const QString)),
		SLOT(slot_dropProject(const QString)));
	connect(m_pWorkBenchTree, SIGNAL(addCvsFiles(const QStringList,bool)),
		SLOT(addCvsFiles(const QStringList,bool)));
	connect(m_pWorkBenchTree, SIGNAL(moveCvsFiles(const QString,const QStringList)),
		SLOT(moveCvsFiles(const QString,const QStringList)));
	connect(m_pWorkBenchTree, SIGNAL(saveViewportPos()),SLOT(saveViewportPos()));
	connect(m_pWorkBenchTree, SIGNAL(recoverViewportPos()),SLOT(recoverViewportPos()));
 
	/** Create the work file pane and tab widget on the main window */
	CFlatSplitter *m_pVertSplitter = new CFlatSplitter(
		CFlatSplitter::Vertical, m_pHorzSplitter);
	m_pFileViews = new ColorTabWidget(m_pVertSplitter);
	m_pFileViews->setMargin(2);
	m_pTools->addWhatsThisText(m_pFileViews, m_pTools->tabFileList);

	/** Restore vertical widget positions */
	QValueList<int> VertSplitterPos;
	VertSplitterPos.append(SPLITTER_POS_V);
	m_pVertSplitter->setResizeMode(m_pFileViews, CFlatSplitter::KeepSize);
	m_pVertSplitter->setSizes(VertSplitterPos);

	/** Add cvs file view page to the main window */
	m_pCvsFileList = new CvsListView(filePopupMenu, m_pFileViews);
	m_pCvsFileList->setFocusPolicy(QWidget::StrongFocus);
	m_pCvsFileList->setHeaderSetup(SizeProperties::g_fileHeader);
	m_pFileViews->addTab(m_pCvsFileList, new ColorTab(tr("Cvs files")));
	m_pTools->addWhatsThisText(m_pCvsFileList, m_pTools->cvsFile);

	connect(m_pCvsFileList, SIGNAL(showFileMenu(bool)),
		SLOT(showFileMenu(bool)));
	connect(m_pCvsFileList, SIGNAL(doubleClickedFile (QString)),
		SLOT(editFile (QString)));
	connect(m_pCvsFileList, SIGNAL(dragStarted()),
		SLOT(slot_stopStatusTimer()));
	connect(m_pCvsFileList, SIGNAL(dragDone()),
		SLOT(slot_checkStatus()));

	/** Add non-cvs file view page to the main window */
	m_pNonCvsFileList = new NonCvsListView(filePopupMenu, m_pFileViews);
	m_pFileViews->addTab(m_pNonCvsFileList, new ColorTab(tr("Non-Cvs files")));
	m_pTools->addWhatsThisText(m_pNonCvsFileList, m_pTools->nonCvsFile);

	connect(m_pNonCvsFileList, SIGNAL(showFileMenu(bool)),
		SLOT(showFileMenu(bool)));
	connect(m_pNonCvsFileList, SIGNAL(itemCount(int)),
		SLOT(updateColor(int)));
	connect(m_pNonCvsFileList, SIGNAL(doubleClickedFile(QString)),
		SLOT(editFile(QString)));
	connect(m_pNonCvsFileList, SIGNAL(dragStarted()),
		SLOT(slot_stopStatusTimer()));
	connect(m_pNonCvsFileList, SIGNAL(dragDone()),
		SLOT(slot_checkStatus()));

	/** Add cvsignore file view page to the main window */
	m_pCvsIgnoreFileList = new CvsIgnoreListView(filePopupMenu, m_pFileViews);
	m_pCvsIgnoreFileList->setFocusPolicy(QWidget::StrongFocus);
	m_pFileViews->addTab(m_pCvsIgnoreFileList,
		new ColorTab(tr("Ignored files")));
	m_pTools->addWhatsThisText(m_pCvsIgnoreFileList, m_pTools->cvsIgnoreFile);

	connect(m_pCvsIgnoreFileList, SIGNAL(showFileMenu(bool)),
		SLOT(showFileMenu(bool)));
	connect(m_pCvsIgnoreFileList, SIGNAL(doubleClickedFile(QString)),
		SLOT(editFile(QString)));
	connect(m_pCvsIgnoreFileList, SIGNAL(dragStarted()),
		SLOT(slot_stopStatusTimer()));
	connect(m_pCvsIgnoreFileList, SIGNAL(dragDone()),
		SLOT(slot_checkStatus()));

	/**
	 * Connect change of selected view to state setting of menuBar() after
	 * all views are created, or pointers might be NULL
	 */
	connect(m_pFileViews, SIGNAL(currentChanged(QWidget *)),
		m_pFileViews->currentPage(), SLOT(selectionChanged()));


	/** Create the message pane widget on the main window */
	m_pMessages = new CCvsOutput(&m_pOutputMenu, m_pVertSplitter, "message log");
	m_pMessages->setFocusPolicy(QWidget::StrongFocus);
	m_pMessages->setReadOnly(true);
	m_pMessages->setWordWrap(QTextEdit::NoWrap);
	m_pTools->addWhatsThisText(m_pMessages, m_pTools->status);
	connect(m_pMessages, SIGNAL(fillOutputMenu(int)), SLOT(fillOutputPopupMenu(int)));

	if (!Font::g_message.isEmpty()) {
	  QFont f;
	  if (f.fromString(Font::g_message)) m_pMessages->setFont(f);
	  else Font::g_message = QString::null;
	}

	/** Create modal instance commitDlg */
	m_pCommitDlg = new CommitDialogImpl(m_pTools->whatsThisIconSet(),
                                                              this, "CommitDlg", true,
                                                              Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
                                                              Qt::WStyle_DialogBorder | Qt::WType_Dialog |
                                                              Qt::WStyle_ContextHelp);

	connect(&m_timer, SIGNAL(timeout()), SLOT(slot_checkStatus()));
	connect(&m_updateTimer, SIGNAL(timeout()), SLOT(slot_checkAutoUpdate()));

	/** preset initial menu state on startup */
	m_pTools->setEnabled(false);
	m_pTools->m_pStopAction->setEnabled(true);

	//set state
	setMenuItemState(FALSE);

	//fill static menues
	fillProjectMenu();
	fillDirMenu(TRUE);
	fillFileMenu(TRUE);
	fillOptionsMenu();
	fillHelpMenu();
}

//----------------------------------------------------------------------------

void ApplicationWindow::customizeDirPopupMenu() {

    CustomizeDialogImpl *dlg = new CustomizeDialogImpl(allDirPopupMenuItems, dirPopupMenuItems, 
	m_pTools->whatsThisIconSet(),
        this, "Customize Menu", true,
        Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
        Qt::WStyle_DialogBorder | Qt::WType_Dialog |
	Qt::WStyle_ContextHelp);   

    if (dlg->exec()) {
	dirPopupMenu->clear();
	DIRPOPUPMENU="";
 
        unsigned int i;
	for( i = 0; i<dirPopupMenuItems->size(); i++ ) {
	    insertMenuItem(dirPopupMenu,dirPopupMenuItems->at(i));
	    QString hlp;
	    hlp.setNum(dirPopupMenuItems->at(i)->getInstanceNum());
	    DIRPOPUPMENU += hlp+":";
	}
    }
    delete dlg;
}

//----------------------------------------------------------------------------

void ApplicationWindow::customizeFilePopupMenu() {
    CustomizeDialogImpl *dlg = new CustomizeDialogImpl(allFilePopupMenuItems, 
        filePopupMenuItems, 
	m_pTools->whatsThisIconSet(),	
	this, "Customize Menu", true,
        Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
        Qt::WStyle_DialogBorder | Qt::WType_Dialog |
        Qt::WStyle_ContextHelp);

    if (dlg->exec()) {
      filePopupMenu->clear();
      FILEPOPUPMENU="";
        
      unsigned int i;
      for( i = 0; i<filePopupMenuItems->size(); i++ ) {
	insertMenuItem(filePopupMenu,filePopupMenuItems->at(i));
	QString hlp;
	hlp.setNum(filePopupMenuItems->at(i)->getInstanceNum());
	FILEPOPUPMENU += hlp+":";
      }
    }
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_customizeKeyShortcuts() {

  CustomizeShortcutsDialogImpl * dlg = new CustomizeShortcutsDialogImpl(
						m_pTools->whatsThisIconSet(),
						this);
  if (dlg->exec() ) {
    
  }
  if (m_pWorkBenchTree->currentItem()) setDirMenu(TRUE);
  fillProjectMenu();
  fillOptionsMenu();
  fillHelpMenu();
  delete dlg;
}

//----------------------------------------------------------------------------

int ApplicationWindow::insertMenuItem(QPopupMenu *menu, MenuItem *item) {
  MenuItem * child = item->getFirstChild();
  if (child) {
    QPopupMenu * subMenu = new QPopupMenu(this);
    while (child) {
      insertMenuItem(subMenu, child);
      child = item->getNextChild();
    }
    return menu->insertItem(item->caption(), subMenu);
  } else {
    return insertMenuItem( menu, item, item->getEnabled() );
  }
}

//----------------------------------------------------------------------------

int ApplicationWindow::insertMenuItem(QPopupMenu *menu, const MenuItem *item, bool enabled) {
    //printf("\ninsert: %s, slot: %s, accel: %i, id: %i, index: %i\n",item->caption().ascii(), item->slot(), item->accel(), item->id(), item->index());
 
    if (!item) {
	//it should never happen, but the release version under w98
	//put zero item into this function
	qDebug("item == 0 should never happen, check it!!!");    
	return -1;
    }

    if (item == M_SEPARATOR) {
      int id = menu->insertSeparator();
      if (!enabled) menu->setItemEnabled(id,false);
      return id;
    }
    else {
      int id = item->insertInto(menu, this);
      if (!enabled) menu->setItemEnabled(id,false);
      return id;
    }
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_customizeOpenFileMapping() {
  customizeFileMapping(openFileAppList,tr("Open file mapping"));
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_customizeViewFileMapping() {
  customizeFileMapping(viewFileAppList,tr("View file mapping"));
}

//----------------------------------------------------------------------------

void ApplicationWindow::customizeFileMapping(FileAppList &list, QString caption) {

  FileMapperDialogImpl::FileAppList dlgList;
  FileAppList::Iterator it;
  for ( it = list.begin(); it != list.end(); ++it ) {
    FileMapperDialogImpl::FileAppItem item;
    item.wildcard = (*it).wildcard;
    item.app = (*it).app;
    item.params = (*it).params;
    item.isRegExp = (*it).isRegExp;
    dlgList.append(item);
  }

  FileMapperDialogImpl * dlg = new FileMapperDialogImpl(dlgList, caption, 
							m_pTools->whatsThisIconSet(),
							this, "FileMapperDlg", true,
                                                        Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
                                                        Qt::WStyle_DialogBorder | Qt::WType_Dialog |
                                                        Qt::WStyle_ContextHelp | Qt::WDestructiveClose);

  if (dlg->exec()) {
    list.clear();
    FileMapperDialogImpl::FileAppList::Iterator it;
    for ( it = dlgList.begin(); it != dlgList.end(); ++it ) {
      FileAppItem item;
      item.wildcard = (*it).wildcard;
      item.app = (*it).app;
      item.params = (*it).params;
      item.isRegExp = (*it).isRegExp;
      list.append(item);
    }

  }
}

//----------------------------------------------------------------------------

void ApplicationWindow::updateColor( int ct ) {
   if( ct == 0 ) {
      m_pFileViews->getColorTabBar()->colorTab( 1 )->resetColor( );
   } else {
      QColor C( 255, 0, 0 );
      m_pFileViews->getColorTabBar()->colorTab( 1 )->setColor( C );
   }
   m_pFileViews->getColorTabBar()->repaint( TRUE );
}

//----------------------------------------------------------------------------

/**
 * Add a new project to the workbench
 */
void ApplicationWindow::slot_addProject()
{
  blockGUI(true);
  addProject();
  blockGUI(false);
}

//----------------------------------------------------------------------------

/**
 * Add a new project to the workbench via drag'n drop
 */
void ApplicationWindow::slot_dropProject(const QString file) {
  bool res = showYesNoQuestion( tr("Checkout Info"),
				tr("Add this project to workbench:")+"\n"+
				file.mid(file.findRev("/")+1)+"?" );
  if (res) {
    blockGUI(true);
    addNewProject(file,TRUE);
    blockGUI(false);
  }
}

//----------------------------------------------------------------------------

QString ApplicationWindow::getNamesOfSelectedFiles()
{
   QString tmp = "";
    
   QListViewItem *myChild = m_pCvsFileList->firstChild();
   while(myChild) {
       if(myChild->isSelected()) tmp += " " + masqWs(myChild->text(0));
       myChild = myChild->nextSibling();
   }
   if( tmp.isEmpty()) {
       QMessageBox::warning(this, tr("Warning"), tr("There is no file selected"), 0);
   }
   return tmp;
}

//----------------------------------------------------------------------------

QString ApplicationWindow::getNamesOfSelectedFilesWithoutSelCheck()
{
   QString tmp = "";
    
   QListViewItem *myChild = m_pCvsFileList->firstChild();
   while(myChild) {
       if(myChild->isSelected()) tmp += " " + masqWs(myChild->text(0));
       myChild = myChild->nextSibling();
   }
   return tmp;
}

//----------------------------------------------------------------------------

QString ApplicationWindow::getNameOfFirstSelectedFile()
{
    
   FileListViewItem *myChild = m_pFileViews->currentFirstChild();
   while(myChild) {
      if(myChild->isSelected()) {
	return myChild->text(0);
        break;
      }
      myChild = myChild->nextSibling();
   }

   return QString::null;
}

//----------------------------------------------------------------------------

void ApplicationWindow::getNameAndRevOfFirstSelectedFile(QString *name, QString *rev)
{

   QListViewItem *myChild = m_pCvsFileList->firstChild();
   while(myChild) {
      if(myChild->isSelected()) {
        *name = myChild->text(0).stripWhiteSpace();
        *rev = myChild->text(1).stripWhiteSpace();
        break;
      }
      myChild = myChild->nextSibling();
   }
}

//----------------------------------------------------------------------------

QString ApplicationWindow::getRev(QString *fileToFind) {
   QListViewItem *myChild = m_pCvsFileList->firstChild();
   while(myChild) {
      if (myChild->text(0).stripWhiteSpace() == (*fileToFind)) {
	  return myChild->text(1).stripWhiteSpace();
      }
      myChild = myChild->nextSibling();
   }
   return QString::null;
}

//----------------------------------------------------------------------------

QStringList ApplicationWindow::getSelectedFilesList() {

  QStringList names;

   if (!(m_pCurCvsDir = getSelectedDir())) {
       return names;
   }

   FileListViewItem * item = m_pFileViews->currentFirstChild();
   while (item) {
     if ( item->isSelected() ) {
       names.append( item->text(0).stripWhiteSpace());
     }
     item = item->nextSibling();
   }
   return names;
}

//----------------------------------------------------------------------------

Directory* ApplicationWindow::getSelectedDir()
{
  if ( (m_pCurCvsDir = m_pWorkBenchTree->selectedItem()) ) {
    return m_pCurCvsDir;
  } else {
    QMessageBox::warning(this, tr("Warning"), tr("There is no directory selected"), 0);
    return NULL;
  }
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_removeCvsBackedFiles() {
  QString filter = ".#*";
  if (!getSelectedDir()->recRemoveUnregisteredFiles(filter)) {
    showWarning( tr("Remove .#xxx files"), tr("File:")+"\n"+filter+"\n"+tr("can not be removed, check permissions")+"\n"+tr("exiting"));
  }
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_about()
{
    QString versionString(tr("LinCVS ") + LC_VERSION);
    AboutDialogImpl AboutDlg(this, versionString);   
    AboutDlg.exec();
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_help()
{
   QDialog*dlg = new QDialog(this, 0, true,   //modal
       Qt::WStyle_SysMenu | Qt::WStyle_MinMax | 
       Qt::WStyle_DialogBorder | Qt::WType_Dialog |
       Qt::WStyle_ContextHelp);   

   dlg->setCaption(tr("Help"));
   
   QBoxLayout *layer = new QVBoxLayout(dlg, 5);
   QTextEdit *e = new QTextEdit(dlg);
   e->setReadOnly(true);
   layer->addWidget(e);

   QWidget *backGround = new QWidget(dlg);
   layer->addWidget(backGround);

   QBoxLayout *buttonLayer = new QHBoxLayout(backGround, 3);
   buttonLayer->addStretch();
   
   QPushButton *ok = new QPushButton(backGround);
   ok->setText(tr("Close"));
   buttonLayer->addWidget(ok);
   buttonLayer->addStretch();
   ok->setFocus();
   
   connect(ok, SIGNAL(clicked()), dlg, SLOT(accept()));
   dlg->resize(600, 300);

   QFile f;
   QString line, filename, helpDir, helpDirDef;
   
   QString lang = QString(QTextCodec::locale()).left(2);  //maybe it's useful without left(2)

   helpDir    = APPDIR + "/" + LC_HELP_DIR + "/" + LC_TRANSLATIONS_SUBDIR + "/" + lang;
   helpDirDef = APPDIR + "/" + LC_HELP_DIR;

   filename = helpDir + tr("/README.html");
   f.setName(filename);
   e->setTextFormat(RichText);
   
   //try to open the translated html file
   if(!f.open(IO_ReadOnly)) {//file is NOT readable
      filename = helpDir + tr("/README");
      f.setName(filename);
      e->setTextFormat(PlainText);
      
      //try to open the translated plain text file
      if(!f.open(IO_ReadOnly)) {//file is NOT readable
         filename = helpDirDef + "/README.html";
         f.setName(filename);
         e->setTextFormat(RichText);

         //try to open the default html file
         if(!f.open(IO_ReadOnly)) {//file is NOT readable
            filename = helpDirDef + "/README";
            f.setName(filename);
            e->setTextFormat(PlainText);

            //try to open the default plain text file
            if(!f.open(IO_ReadOnly)) {//file is NOT readable
               QString error = tr("File not found: %1");
               QMessageBox::warning(this, tr("LinCVS error"), error.arg(filename) );
               return;
            }
         }
      }
   }
       
       
   QTextStream stream( &f );
   e->setText( stream.read() );
   f.close();

   dlg->exec();
   delete dlg;
}

//----------------------------------------------------------------------------

void ApplicationWindow::slot_aboutQt()
{
   QMessageBox::aboutQt( this, "Qt..." );
}

//----------------------------------------------------------------------------

void ApplicationWindow::showInfo( const QString &caption, const QString &txt) {
  bool block = GuiEventBlocker::isBlocked();
  if (block) GuiEventBlocker::setBlocking(false);
  QMessageBox::information (this, caption,
			txt,
			QMessageBox::Ok,
			QMessageBox::NoButton);
  if (block) GuiEventBlocker::setBlocking(true);
}

//----------------------------------------------------------------------------

void ApplicationWindow::showWarning( const QString &caption, const QString &txt) {
  bool block = GuiEventBlocker::isBlocked();
  if (block) GuiEventBlocker::setBlocking(false);
  QMessageBox::warning (this, caption,
			txt,
			QMessageBox::Ok,
			QMessageBox::NoButton);
  if (block) GuiEventBlocker::setBlocking(true);
}

//----------------------------------------------------------------------------

bool ApplicationWindow::showYesNoQuestion( const QString &caption, const QString &txt) {
  bool block = GuiEventBlocker::isBlocked();
  if (block) GuiEventBlocker::setBlocking(false);

  bool retval = (QMessageBox::warning (this, caption, txt,
				QMessageBox::Yes,
				QMessageBox::No)
	  == QMessageBox::Yes);
  if (block) GuiEventBlocker::setBlocking(true);
  return retval;
}

//----------------------------------------------------------------------------

bool ApplicationWindow::showOkCancelQuestion( const QString &caption, const QString &txt) {
  bool block = GuiEventBlocker::isBlocked();
  if (block) GuiEventBlocker::setBlocking(false);
  bool retval = (QMessageBox::warning (this, caption, txt,
				QMessageBox::Ok,
				QMessageBox::Cancel)
	  == QMessageBox::Ok);
  if (block) GuiEventBlocker::setBlocking(true);
  return retval;
}

//----------------------------------------------------------------------------

void ApplicationWindow::saveViewportPos(bool override/*=FALSE*/) {

  if ( !(override || m_selectedDir.isEmpty()) ) {
//     qDebug("can't save, not recovered jet");
    return;
  }

  CFileListView *lv = m_pFileViews->currentPage();
  
  m_lastHScrollBarValue = lv->horizontalScrollBar()->value();
  m_lastVScrollBarValue = lv->verticalScrollBar()->value();
  
  m_selectedList.clear();
  Directory * dir = m_pWorkBenchTree->selectedItem();
  if (dir) {
    m_selectedDir = dir->fullName();
  } else {
    m_selectedDir = "";
  }
  QListViewItem *myChild = lv->firstChild();
  while(myChild) {
    if(myChild->isSelected()) m_selectedList.append(myChild->text(0));
    myChild = myChild->nextSibling();
  }
//   qDebug("save: "+m_selectedList.join(";"));

}

//----------------------------------------------------------------------------

void ApplicationWindow::recoverViewportPos() {

  Directory * dir = m_pWorkBenchTree->selectedItem();
  if (dir && ( dir->fullName() == m_selectedDir) ) {
//     qDebug("recover: "+m_selectedList.join(";"));

    CFileListView *lv = m_pFileViews->currentPage();

    QListViewItem *item = NULL;
    for ( QStringList::Iterator it = m_selectedList.begin(); it != m_selectedList.end(); ++it ) {
      item = lv->findItem(*it,0);
      if (item) item->setSelected( TRUE);
    }
    if (item) lv->setCurrentItem(item);
    
    Timer::singleShot(0,this,SLOT(updateFileViews()));

    m_selectedDir = "";
  } 
//   else qDebug("can't recover: "
// 	      +QString( (dir && dir->isSelected()) ? "dirSelected" : "wrong dir")
// 	      +", dir: "+QString( dir ? dir->fullName() : "")
// 	      +", original: "+m_selectedDir);
}

//----------------------------------------------------------------------------

void ApplicationWindow::updateFileViews() {

  qApp->processEvents();//needed to be able to set scrollbar values later on -- dunno why:-(

  CFileListView *lv = m_pFileViews->currentPage();
  lv->horizontalScrollBar()->setValue(m_lastHScrollBarValue);
  lv->verticalScrollBar()->setValue(m_lastVScrollBarValue);
  lv->triggerUpdate();
  setDirMenu(true);
}

