/**
 * Cvs command visitor classes.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * @file	ccvscommand.h
 * @author	Copyright (C) 2002-2004 Jose Hernandez <joseh@tesco.net>
 */


#ifndef CCVSCOMMAND_H
#define CCVSCOMMAND_H


#include <qstring.h>


class Directory;


class CCvsCommand
{
public:
	CCvsCommand(bool, bool = false);
	virtual ~CCvsCommand();

	virtual bool execute(Directory &) = 0;
	virtual bool unexecute(Directory &) = 0;

	bool isRecursive();
	bool isUndoable();

private:
	bool m_Undoable;
	bool m_Recursive;
};


class CCvsCommandChRoot : public CCvsCommand
{
public:
        //	CCvsCommandChRoot(const std::string &, bool);
	CCvsCommandChRoot(const QString &, bool);
	virtual ~CCvsCommandChRoot();

	virtual bool execute(Directory &);
	virtual bool unexecute(Directory &);

private:
	CCvsCommandChRoot(CCvsCommandChRoot &);
	QString m_CvsRoot;
};


#endif // CCVSCOMMAND_H
