/**
 * Cvs command visitor classes.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * @file	ccvscommand.cpp
 * @author	Copyright (C) 2002-2004 Jose Hernandez <joseh@tesco.net>
 */


#include <qfile.h>
#include <qstringlist.h>
#include <qtextstream.h>

#include "ccvscommand.h"
#include "directory.h"


CCvsCommand::CCvsCommand(bool Undoable, bool Recursive) :
	m_Undoable(Undoable), m_Recursive(Recursive)
{
}


CCvsCommand::~CCvsCommand()
{
}


bool CCvsCommand::isRecursive()
{
	return m_Recursive;
}


bool CCvsCommand::isUndoable()
{
	return m_Undoable;
}


/**
 * Construct a "change cvs root" command. 
 *
 * @param	CvsRoot
 *	CvsRoot variable
 * @param	Recursive
 *	apply command recursively.
 */

CCvsCommandChRoot::CCvsCommandChRoot(const QString &CvsRoot, bool Recursive) :
	CCvsCommand(true, Recursive), m_CvsRoot(CvsRoot)
{
}


CCvsCommandChRoot::CCvsCommandChRoot(CCvsCommandChRoot &Other) :
	CCvsCommand(Other)
{
}


CCvsCommandChRoot::~CCvsCommandChRoot()
{
}


/**
 * Changes the cvs root of a sandbox module (directory)
 *
 * @param	Module
 *	Target directory.
 * @return
 *	<i>true</i> on success, <i>false</i> otherwise.
 */

bool CCvsCommandChRoot::execute(Directory &Module)
{
	/* TODO: store unexecution data so that the command can be undone
	 * at a later stage if required.
	 */  
	QFile file(Module.fullName() + "/CVS/Root");

	if (file.open(IO_WriteOnly))
	{
		QTextStream stream(&file);
		stream << m_CvsRoot << endl;
		file.close();

		return Module.checkCvsDir();
	}
	
	return false;
}


bool CCvsCommandChRoot::unexecute(Directory &)
{
	/* TODO: Add support for undoing this command. */
	return false;
}
