package com.limegroup.gnutella.xml.gui;

import java.util.Locale;
import java.util.StringTokenizer;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.ArrayList;

import java.awt.event.*;
import javax.swing.*;

import com.limegroup.gnutella.xml.*;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.gui.AutoCompleteTextField;

//imports necessary to make unit test work.
import java.io.File;

/**
 * A panel that is used to gather information from the user about
 * what the search criterion based on a particular schema.
 * <p>
 * This Panel is popped up everytime the user want to enter a query and has
 * specified the schema that she would like to base her search on
 *
 * @author Sumeet Thadani
 */
public class InputPanel extends IndentingPanel {
   
    private LimeXMLSchema _schema; // the schema that this Panel pertains to

    //constructor
    public InputPanel(LimeXMLSchema schema) {
        this(schema, null, false,false);
    }

    public InputPanel(LimeXMLSchema schema, ActionListener listener) {
        this(schema, listener, false, false);
    }

    public InputPanel(LimeXMLSchema schema, ActionListener listener,
                      boolean expand, boolean indent) {
        super(schema, listener, expand, indent);
        _schema = schema;
    }

    /**
     * @return The Schema URI associated with this InputPanel
     */
    public String getSchemaURI() {
        return _schema.getSchemaURI();
    }

    /**
     * Looks at the textFields and creates a string that can be converted 
     * into LimeXMLDocument, so that the client that receives the search 
     * sting is can compare it with documents in its repository.
     */
    public String getInput() {
        ArrayList namValList = new ArrayList();
        List list = _schema.getCanonicalizedFields();
        int t = list.size();
        String fields[] = new String[t];
        for (int i = 0; i < t; i++) {
            SchemaFieldInfo info = (SchemaFieldInfo)list.get(i);
            fields[i] = info.getCanonicalizedFieldName();
        }
        int size = fields.length;
        for (int i = 0; i < size; i++) {
            String currField = fields[i];
            JComponent comp = (JComponent)
                nameToField.get(currField.toLowerCase(Locale.US));
            String value = "";
            if (comp instanceof JTextField) {
                JTextField theField = (JTextField)comp;
                value = theField.getText();
            } else if (comp instanceof JComboBox) {
                JComboBox theBox = (JComboBox)comp;
                value = (String)theBox.getSelectedItem();
            }
            if (value != null && !value.equals("")) {
                NameValue namValue = new NameValue(currField, value);
                namValList.add(namValue);
            }
        }
        String schemaURI = _schema.getSchemaURI();
        String str = constructXML(namValList, schemaURI);
        return str;
    }

    /**
     * Scan through all the AutoTextField components
     * and store the input into their dictionaries.
     */
    public void storeInput() {
        List list = _schema.getCanonicalizedFields();
        int listLength = list.size();
        String fields[] = new String[listLength];
        for (int i = 0; i < listLength; i++) {
            SchemaFieldInfo info = (SchemaFieldInfo)list.get(i);
            fields[i] = info.getCanonicalizedFieldName();
        }
        int size = fields.length;
        for (int i = 0; i < size; i++) {
            JComponent comp = (JComponent)
                nameToField.get(fields[i].toLowerCase(Locale.US));
            if (comp instanceof AutoCompleteTextField) {
                AutoCompleteTextField theField = (AutoCompleteTextField)comp;
                if (!theField.getText().equals(""))
                    theField.addToDictionary();
            }
        }
    }
    
    /**
     * @return A string the represents a standard query (as opposed to a rich
     * query).
     * <p>
     * The order in which it checks for fields is schema specific.
     */
    public String getStandardQuery() {
        List list = _schema.getCanonicalizedFields();
        final int size = list.size();
        String fields[] = new String[size];
        for (int i = 0; i < size; i++) {
            SchemaFieldInfo info = (SchemaFieldInfo)list.get(i);
            fields[i] = info.getCanonicalizedFieldName();
        }

        StringBuffer retString = new StringBuffer();
        int numWords = 0;
        for (int i = 0; i < size && numWords < 3; i++) {
            String currField = fields[i];
            JComponent comp = (JComponent)
                nameToField.get(currField.toLowerCase(Locale.US));
            String value = "";
            if (comp instanceof JTextField) {
                JTextField theField = (JTextField)comp;
                value = theField.getText();
            } else if (comp instanceof JComboBox) {
                JComboBox theBox = (JComboBox)comp;
                value = (String)theBox.getSelectedItem();
            }
            if (value != null && value.trim().length() > 1) {
                StringTokenizer st = new StringTokenizer(value);
                numWords += st.countTokens();
                retString.append(value + " ");
            }
        }
        return retString.toString();
    }

    /**
     * Deligates to the the static method in LimeXMLDocument
     */
    public static String constructXML(ArrayList namValList, String uri) {
       return LimeXMLDocument.constructXML(namValList, uri);
    }

    //Unit Test
    public static void main(String args[]) {
        LimeXMLSchema schema = null;
        try {
            File f = new File("c:\\home\\etc\\schemas", "personal.xsd");
            schema = new LimeXMLSchema(f);
        } catch (Exception e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame();
        //window closing.
        frame.addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
        frame.setSize(600, 600);
        //!expand, indent
        InputPanel panel = new InputPanel(schema, null, false, true);
        //Note try all 4 posible combinations to make sure it all works
        frame.getContentPane().add(panel);
        frame.show();
    }

}
