package com.limegroup.gnutella.update;

/**
 * This class handles the case where there is no update to perform.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class NoUpdateUpdator extends AbstractUpdator {

	/**
	 * Sets the string identifier for this type of update.
	 */
	public NoUpdateUpdator() {
		_updateType = "NoUpdateUpdator";
	}
	
	/** 
	 * Implements the Updator interface.
	 * Does nothing since there is no update.
	 */
	public void doUpdate() {}	

	/** 
	 * Implements the Updator interface.
	 * Does nothing since there is not update and since this can never be
	 * called in the no update case.
	 */
	public void cancelUpdate() {}
}
