package com.limegroup.gnutella.update;


/**
 * Abstract class that provides a basic implementation of the 
 * <tt>Updator</tt> interface for all update types.
 */
abstract class AbstractUpdator implements Updator {

	/** 
	 * The string for the message to display to the user.
	 */
	protected String _message;

	/** 
	 * The url for the update.
	 */
	protected String _url;
	
	/**
	 * The new classpath.
	 */
	protected String _classpath;

	/**
	 * The new main class.
	 */
	protected String _mainClass;

	/**
	 * The type of update for the <tt>Updator</tt>.
	 */
	protected String _updateType;
	
	public void setMessageToDisplay(String message) {
		_message = message;
	}

	public void setUpdateURL(String url) {
		_url = url;
	}

	public void setClassPath(String classpath) {
		_classpath = classpath;
	}

	public void setMainClass(String mainClass) {
		_mainClass = mainClass;
	}

	public void doUpdate() {}
	
	public void cancelUpdate() {}

	/**
	 * Prints out all of the data for this <tt>Updator</tt>.
	 */
	public String toString() {
		return "UPDATE_TYPE: "+_updateType+"\n"+
		       "MESSAGE: "+_message+"\n"+
		       "URL: "+_url+"\n"+
		       "CLASSPATH: "+_classpath+"\n"+
		       "MAIN_CLASS: "+_mainClass;
	}
}








