package com.limegroup.gnutella.gui.search;

import com.sun.java.util.collections.*;
import com.limegroup.gnutella.xml.*;

/**
 * @author Sumeet Thadani
 * At the bottom of the inheritance hierarchy, this class extends 
 * TableLineProjector (which is abstract) - therefore, this class implements 
 * the methods it needs to for correct selection behaviour.
 * <p>
 * The ResultPanel has a handle to this class. This class will be responsible
 * for selecting lines based on some filters that can be set.
 * <p>
 * Other decisions like which rows to project are not implemented, and so are
 * automatically handled by the classes higher in the inheritance chain
 * TreeTableModel called the TableLineProjector
 */
class TableRowFilter extends TableColumnFilter {

    /**
     * Note: If the filter is null, we simply select everything.
     */
    private TableLineFilter filter;//TODO: We can imagine an array of filters
    /*
     * each index keeps the value of the index in the real datamodel
     * <p>
     * So to find the real index, ask projector, which simply asks the backing
     * datamodel
     */
    private ArrayList /** of Integer */ map;
    
    private int numRows=0;
    
    //constructor
    public TableRowFilter(TableLine root, boolean grouped, ResultPanel rp) {
        super(root,grouped,rp);
        map = new ArrayList();
        LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
        String[] schemas = rep.getAvailableSchemaURIs();
        for(int i=0; i< schemas.length; i++)
            addSchema(rep.getSchema(schemas[i]));
    }

    public TableRowFilter(TableLine root, boolean g, TableLineFilter f,
                             ResultPanel rp){
        this(root,g,rp);
        this.filter = f;
    }

    ///////////////////////////TreeModel interface////////////////////    
    /**
     * Handles the call in some cases, otherwise, super will take care of it
     */
    public int getChildCount(Object node) {
        if (node == getRoot())
            return map.size();
        return super.getChildCount(node);
    }

    /**
     * Does some translation and lets super handle it
     */
    public Object getChild(Object node, int i){
        debug("getting child initial i= "+i);
        if (node == getRoot()){
            debug("Given node is root");
            i = ((Integer)map.get(i)).intValue();
        }
        debug("getting child final i= "+i);
        return super.getChild(node,i);
    }
    
    ////////////////other methods//////////////////////////
    public void setFilter(TableLineFilter filter){
        this.filter = filter;
        rebuildMap();
    }

    /**
     * Tells the underlying model about the new line. If the line
     * being added is a new Child of the root, we remember it's
     * position as a child of the root as its index. This means 
     * when its grouped, when the group is null, 
     */
    void addLine(TableLine line, TableLine group, boolean grouped) {
        super.addLine(line, group, grouped);
        if(allow(line)){//now we want to do some book keeping
            numRows++;
            debug("line added");
            if (grouped){
                if (group == null) {//its a new Line. We should remember it
                    int index = getRowCount()-1;
                    map.add(new Integer(index));
                    TableLine root = (TableLine)getRoot();
                    fireTreeNodesInserted(this, 
                                          new Object[] {root},
                                          new int[] { map.size()-1 },
                                          new Object[] {line}
                                          );
                } else{ //line to be added to a group
                    fireTreeNodesInserted(this,
                                          new Object[] {root,group},
                                          new int[] {group.children.size()-1},
                                          new Object[] {line}
                                          );
                                             
                }
            } else {//not grouped...each line is a new Line
                int index = getRowCount()-1;
                map.add(new Integer(index));
                TableLine root = (TableLine)getRoot();
                fireTreeNodesInserted(this,
                                      new Object[] {root},
                                      new int[] {map.size()-1},
                                      new Object[] {line}
                                      );
            }
        } else
            debug("line not added");
    }

    void group() {
        super.group();
        rebuildMap();
        fireTreeStructureChanged(this,
                                 new Object[] { root },
                                 null, null);
    }
    
    void ungroup() {
        super.ungroup();//ask the projector to do the grouping
        rebuildMap();
        fireTreeStructureChanged(this,
                                 new Object[] { root },
                                 null, null);
    }
    
    void sort(int column, boolean ascending) {
        super.sort(column,ascending);
        //after underlying model is sorted on appropriate column, rebuild map
        rebuildMap();
        fireTreeStructureChanged(this,
                                 new Object[] { root },
                                 null,
                                 null);        
    }
    
    int numLeaves(){
        return numRows;
        //TODO2: When the filtering kicks in, we may need to change this method
        //return map.size();
    }
    
    //////////////////////////private helper methods///////////////////

    private boolean allow(TableLine line) {
        return true;
        //if (filter == null)//if no filters just add the line
        //    return true;
        // TODO1: The rest of the code after this point is a todo in this ()
        ///**Just a test*/           
        //String name = line.getFilename().toLowerCase(Locale.US);
        //if (name.indexOf(" the ") > 0)
        //    return true;
        //return false;
        // TODO1: lookup the filters and see if this line should be allowed
    }

    private void rebuildMap(){
        map.clear();//reset the whole thing
        for (int i = 0; i < getRowCount(); i++) {
            if (allow((TableLine)getRow(i)))
                map.add(new Integer(i));//remember the index of the real row
        }
    }

    private void debug(String message){
        boolean on = false;
        if (on)
            System.out.println(message);
    }

}//end of class

