package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.*; 
import com.limegroup.gnutella.xml.gui.*; 
import javax.swing.*;
import java.awt.event.*;

/**
 * This class responds to search events, notifying the backend to 
 * trigger a search with the given criteria.
 */
final class SearchListener extends AbstractAction {

	public void actionPerformed(ActionEvent ae) {
		try {
			// don't search if we're not connected, as there's really
			// no point
			if(!GUIMediator.instance().isConnected()) return;
			InputPanel ip = SearchMediator.getCurrentInputPanel();
			if (ip != null) {
				SearchMediator.triggerSearchXML(ip);
				ip.clear();
			}
			else {
				SearchMediator.triggerSearch();
			}
		} catch(Throwable e) {
			GUIMediator.showInternalError(e, "SearchListener");
		}
	}
}
