package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

/**
 * This class contains the buttons in the download window, allowing
 * classes in this package to enable or disable buttons at specific
 * indeces in the row.
 */
final class SearchButtons {
		
	/**
	 * The row of buttons for the donwload window.
	 */
	private final ButtonRow BUTTONS;

	/**
	 * The index of the WishList / Download Button.
	 */
	static final int DOWNLOAD_BUTTON_INDEX = 0;

	/**
	 * The index of the chat button in the button row.
	 */
	static final int CHAT_BUTTON_INDEX = 1;

	/**
	 * The index of the browse host button in the button row.
	 */
	static final int BROWSE_BUTTON_INDEX  = 2;

    /**
     * The string for the download button label...
     */
    private static final String DOWNLOAD_BUTTON_LABEL =
        GUIMediator.getStringResource("SEARCH_DOWNLOAD_BUTTON_LABEL");

    /**
     * The string for the download button tip...
     */
    private static final String DOWNLOAD_BUTTON_TIP =
        GUIMediator.getStringResource("SEARCH_DOWNLOAD_BUTTON_TIP");
	

    /**
     * The string for the wishlist button label...
     */
    private static final String WISHLIST_BUTTON_LABEL =
        GUIMediator.getStringResource("SEARCH_WISHLIST_BUTTON_LABEL");

    /**
     * The string for the wishlist button tip...
     */
    private static final String WISHLIST_BUTTON_TIP =
        GUIMediator.getStringResource("SEARCH_WISHLIST_BUTTON_TIP");

	/**
	 * The constructor creates the row of buttons with their associated
	 * listeners.
	 */
    SearchButtons() {
        String[] buttonLabelKeys = {
			"SEARCH_WISHLIST_BUTTON_LABEL",
			"SEARCH_CHAT_BUTTON_LABEL",
            "SEARCH_BROWSE_HOST_BUTTON_LABEL"
		};
        String[] buttonTipKeys = {
			"SEARCH_WISHLIST_BUTTON_TIP",
			"SEARCH_CHAT_BUTTON_TIP",
            "SEARCH_BROWSE_HOST_BUTTON_TIP"
		};

		ActionListener[] buttonListeners = {
            new DownloadAllAction(),
            new ChatListener(),
            new BrowseHostAction()
		};

		BUTTONS = new ButtonRow(buttonLabelKeys,buttonTipKeys,buttonListeners);
	}

	/**
	 * Sets the enabled/disabled state of the button at the given button index.
	 *
	 * @param BUTTON_INDEX the index of the button to change
	 * @param ENABLED the state to change the button to
	 */
	void setButtonEnabled(final int BUTTON_INDEX, final boolean ENABLED) {
		BUTTONS.setButtonEnabled(BUTTON_INDEX, ENABLED);
	}

	/**
	 * Sets the enabled/disabled state of all of the buttons.
	 *
	 * @param ENABLED the state to change the button to
	 */
	void setButtonsEnabled(final boolean ENABLED) {
		BUTTONS.setButtonsEnabled(ENABLED);
	}

	/**
	 * Returns the <tt>Component</tt> instance containing all of the buttons.
	 *
	 * @return the <tt>Component</tt> instance containing all of the buttons
	 */
	Component getComponent() {
		return BUTTONS;
	}

    /**
     * Sets the mutable 'download' button to the Download button.
     */
    void transformWishlistButton() {
        transformButton(DOWNLOAD_BUTTON_INDEX, DOWNLOAD_BUTTON_LABEL,
                        DOWNLOAD_BUTTON_TIP);
		this.setButtonEnabled(DOWNLOAD_BUTTON_INDEX, false);
    }

    /**
     * Sets the mutable 'download' button to the Download button.
     */
    void transformDowloadButton() {
        transformButton(DOWNLOAD_BUTTON_INDEX, WISHLIST_BUTTON_LABEL,
                        WISHLIST_BUTTON_TIP);
		this.setButtonEnabled(DOWNLOAD_BUTTON_INDEX, true);
    }

    private void transformButton(int index, final String label, 
                                 final String tip) {
        final JButton button = BUTTONS.getButtonAtIndex(index);
        if (button != null) {
			button.setText(label);
			button.setToolTipText(tip);
        }
    }
}
