package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.*;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;

/** Draws ResultSpeed's appropriately colorized */
class ResultSpeedRenderer extends DefaultTableCellRenderer 
	implements ThemeObserver {
    /** The color to show measured speeds in.  This is dark green,
     *  similar to the color on the connected status icon. */
    public static Color _measuredColor;
    public static Color _unmeasuredColor;

	/**
	 * Creates a new <tt>ResultSpeedRenderer</tt> instance, making it a
	 * theme listener.
	 */
    ResultSpeedRenderer() {
		updateTheme();
		GUIMediator.addThemeObserver(this);
	}

	// inherit doc comment
	public void updateTheme() {
		_measuredColor = ThemeFileHandler.SEARCH_RESULT_SPEED_COLOR.getValue();
		_unmeasuredColor = ThemeFileHandler.WINDOW8_COLOR.getValue();			
	}

    public Component getTableCellRendererComponent(JTable table,
                                                   Object value, 
                                                   boolean isSel, 
                                                   boolean hasFocus,
                                                   int row,
                                                   int column) {        
        //Note that we don't display all the information in the column.
        ResultSpeed speed=(ResultSpeed)value;
        String tag=speed.stringValue();
        Component ret=super.getTableCellRendererComponent(
            table, tag, isSel, hasFocus, row, column);                           
        //Render measured speeds in green, others in black.  The second call is
        //necessary to prevent everything from turning green, since one renderer
        //is shared among all cells.
        if (speed.isMeasured())
            ret.setForeground(_measuredColor);
        else
            ret.setForeground(_unmeasuredColor);
        return ret;
    }
}
