package com.limegroup.gnutella.gui.options.panes;

import java.io.IOException;
import java.awt.Container;

/**
 * An object that defines the basic functions of one <i>option item</i>, or
 * one individual panel that displays a set of configurable options to the 
 * user.<p>
 *
 * The <tt>PaneItem</tt> interface provides the important ability to apply 
 * the changes to options provided in the panel.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
public interface PaneItem {
	
	/**
	 * Returns the <tt>Container</tt> for this set of options.
	 *
	 * @return the <tt>Container</tt> for this set of options
	 */
	Container getContainer();

	/**
	 * Sets the options for the fields in this <tt>PaneItem</tt> when the 
	 * window is shown.
	 */
	void initOptions();

	/**
	 * Applies the options currently set in this <tt>PaneItem</tt>.
	 *
	 * @throws IOException if the options could not be fully applied
	 */
	void applyOptions() throws IOException;
}
