package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.settings.*;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.*;
import java.awt.*;
import javax.swing.*;
import java.io.*;

/**
 * This class gives the user the option of whether or not to disable compression
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
public final class CompressionPaneItem extends AbstractPaneItem {

	/**
	 * Constant for the key of the locale-specific <tt>String</tt> for the 
	 * check box that allows the user to disable outgoing compression.
	 */
	private final String OUTGOING_LABEL = 
		"OPTIONS_COMPRESSION_DISABLE_OUTGOING_LABEL";

	/**
	 * Constant for the key of the locale-specific <tt>String</tt> for the 
	 * check box that allows the user to disable incoming compression.
	 */
	private final String INCOMING_LABEL = 
		"OPTIONS_COMPRESSION_DISABLE_INCOMING_LABEL";


	/**
	 * Constant for the check box that determines whether or not 
	 * to disable outgoing compression
	 */
	private final JCheckBox OUTGOING = new JCheckBox();
	
	/**
	 * Constant for the check box that determines whether or not 
	 * to disable incoming compression
	 */
	private final JCheckBox INCOMING = new JCheckBox();	

	public CompressionPaneItem(final String key) {
		super(key);
		LabeledComponent out = new LabeledComponent(OUTGOING_LABEL,
												    OUTGOING);
		LabeledComponent in = new LabeledComponent(INCOMING_LABEL,
							                       INCOMING);
        //JPanel nicePanel = new JPanel();
        add(out.getComponent());
        add(in.getComponent());
	}

	public void initOptions() {
	    // remember that the checkboxes are for DISABLING
        OUTGOING.setSelected(!ConnectionSettings.ENCODE_DEFLATE.getValue());
        INCOMING.setSelected(!ConnectionSettings.ACCEPT_DEFLATE.getValue());
	}

	public void applyOptions() throws IOException {
	    // remember that the checkboxes are for DISABLING
		ConnectionSettings.ENCODE_DEFLATE.setValue(!OUTGOING.isSelected());
        ConnectionSettings.ACCEPT_DEFLATE.setValue(!INCOMING.isSelected());
	}
}
