package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.gui.*;
import javax.swing.*;

/**
 * This class contains the popup menu that is visible on right-click events in
 * the library table window.
 */
final class LibraryTablePopupMenu {
	
	/**
	 * Constant for the <tt>JPopupMenu</tt> that contains all of the menu items.
	 */
	private final JPopupMenu MENU = new JPopupMenu();

	/**
	 * The index of the launch menu item.
	 */
	static final int LAUNCH_INDEX = 0;

	/**
	 * The index of the delete menu item.
	 */
	static final int DELETE_INDEX = 1;

	/**
	 * The index of the annotate menu item.
	 */
	static final int ANNOTATE_INDEX = 2;
	
	/**
	 * The index of the resume item.
	 */
	static final int RESUME_INDEX = 3;

	/**
	 * The index of the playlist menu item.
	 */
	static final int PLAYLIST_INDEX = 4;

	/**
	 * The index of the bitzi menu item.
	 */
	static final int BITZI_INDEX = 5;
	
	LibraryTablePopupMenu(final LibraryTableMediator ltm) {
		
       	/**
    	 * Constant for the launch menu item.
    	 */
    	final JMenuItem LAUNCH_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("LIBRARY_LAUNCH_BUTTON_LABEL")
    	);
    
    	/**
    	 * Constant for the delete menu item.
    	 */
    	final JMenuItem DELETE_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("LIBRARY_DELETE_BUTTON_LABEL")
    	);
    
    	/**
    	 * Constant for the annotate file menu item.
    	 */
    	final JMenuItem ANNOTATE_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("LIBRARY_ANNOTATE_BUTTON_LABEL")
    	);
    	
    	/**
    	 * Constant for resume file menu item.
    	 */    	
        final JMenuItem RESUME_ITEM = new JMenuItem(
            GUIMediator.getStringResource("LIBRARY_RESUME_BUTTON_LABEL")
        );
    	
    
    	/**
    	 * Constant for the playlist menu item.
    	 */
    	final JMenuItem PLAYLIST_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("LIBRARY_PLAYLIST_BUTTON_LABEL")
    	);    	
    
    	/**
    	 * Constant for the bitzi menu item.
    	 */
    	final JMenuItem BITZI_ITEM = new JMenuItem(
    	    GUIMediator.getStringResource("SEARCH_PUBLIC_BITZI_LOOKUP_STRING")
    	);
    
   		LAUNCH_ITEM.addActionListener( LibraryTableMediator.LAUNCH_LISTENER );
		DELETE_ITEM.addActionListener( ltm.REMOVE_LISTENER );
		ANNOTATE_ITEM.addActionListener( LibraryTableMediator.ANNOTATE_LISTENER );
		RESUME_ITEM.addActionListener( LibraryTableMediator.RESUME_LISTENER );
		PLAYLIST_ITEM.addActionListener( LibraryTableMediator.ADD_PLAY_LIST_LISTENER );
        BITZI_ITEM.addActionListener( LibraryTableMediator.BITZI_LOOKUP_LISTENER );
		MENU.add(LAUNCH_ITEM);
		MENU.add(DELETE_ITEM);
		MENU.add(ANNOTATE_ITEM);
		MENU.add(RESUME_ITEM);
		// if it's not a mac, add the playlist item.
        // otherwise, add a separator so that the indexes are still right. :)
        if ( !CommonUtils.isMacClassic() ) MENU.add(PLAYLIST_ITEM);
        else MENU.addSeparator();
        MENU.add(BITZI_ITEM);
    }
    
    JPopupMenu getComponent() { return MENU; }
    
}
