

package com.limegroup.gnutella.gui.connection;

import com.limegroup.gnutella.gui.tables.*;

public final class ConnectionModel extends BasicDataLineModel {
        
    ConnectionModel() {
        super( ConnectionDataLine.class );
    }
    
    /**
     * Override default update since we don't cache anything.
     * Specifically, we do NOT want to call update on the DataLine,
     * since that will make it think it's no longer connecting.
     * @return null
     */
    public Object refresh() {
        fireTableRowsUpdated(0, getRowCount());
        return null;
    }
    
    /**
     * Creates a new ConnectionDataLine
     */
    public DataLine createDataLine() {
        return new ConnectionDataLine();
    }
    
}