package com.limegroup.gnutella.gui;

/**
 *
 */

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.File;
import java.net.URL;
import com.limegroup.gnutella.*;
import com.limegroup.gnutella.util.CommonUtils;

/**
 *  ShoppingView displays a browser page for limewire marketplace
 *
 */
public class ShoppingView extends NativePanel {

    private BrowserPage shopPage = null;

	/**
	 *  Do a lightweight instantiation of this window
	 */
	public ShoppingView() {
		// Prepare for future additions
		setLayout(new BorderLayout());
	}

	/**
	 *  Callback to wake this component up on first visit to the tab 
     *  that contains this.
	 */
    public void prepareComponent() {
		if ( shopPage == null ) {
			createAndAddComponent();

			delayedWakeup();
		}
	}

	/**
	 *  Ensure that the native component is alive and well
	 */
	public void wakeupComponent() {
		if ( shopPage == null ) {
			createAndAddComponent();
		}
		delayedWakeup();
	}

	/**
	 *  Create the browser subcomponent needed to display the Shopping Page
	 */
	private void createAndAddComponent() {
        File primary = 
		  new File("c:/program files/topMoxie/html/limeshop_lwm.htm");
        String source;
		if ( primary.exists() )
			source = primary.toString();
		else {
			String curDir    = CommonUtils.getCurrentDirectory().toString();
			String sep       = System.getProperty("file.separator");
			String name      = "limeshop.html";
			File   secondary = new File(curDir + sep + "bin" + sep + name);
			if ( !secondary.exists() ) {
			    secondary = new File(curDir + sep + name);
			}
			source = secondary.toString();
		}

        shopPage = new BrowserPage(source);
	    add(shopPage, BorderLayout.CENTER);
	}

	/**
	 *  This native component needs to become aware of its size and 
     *  in order to properly display
	 */
	private void delayedWakeup() {
		// Nasty kludge to wake this baby up after 
		// the native component has been added to its parent
		try {
			Thread.sleep(100);
		} catch(Exception e) {};
        Rectangle r = shopPage.getBounds();
		shopPage.setSize(r.width,r.height);	
	}
}

/**
 *  This panel allows the non-swing contained component to shrink on resizing
 */
class NativePanel extends JPanel {
    public void setSize( int width, int height ) {
        super.setSize(width,height);
    }
    public void setSize( Dimension d ) {
        super.setSize(d);
    }
    public void setPreferredSize( Dimension d ) {
        super.setPreferredSize(d);
    }
    public void setMinimumSize( Dimension d ) {
        super.setMinimumSize(d);
    }
    public void setMaximumSize( Dimension d ) {
        super.setMaximumSize(d);
    }

    public void setBounds( int x, int y, int width, int height ) {
        super.setBounds(x,y,width,height);

		// Nasty Kludge to allow this non-swing window to shrink.
		// For some reason, the min size gets reset here so I 
		// reset the min to a small size to allow shrinkage.
		Dimension d = getMinimumSize();
		//System.out.println("Min:"+"W="+d.width+" H="+d.height);
		d.setSize(10,10);
		super.setMinimumSize(d);
    }
    public void setBounds( Rectangle r ) {
        super.setBounds(r);
    }
}
