package com.limegroup.gnutella.gui;

import java.io.File;
import java.io.IOException;

import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.FileUtils;

/**
 * This class handles prompting the user to enter a valid save directory.
 */
final class SaveDirectoryWindow {   

	/**
	 * Ensure that this class cannot be constructed from outside this class.
	 */
	private SaveDirectoryWindow() {}

	/**
	 * Constructs a new window that prompts the user to enter a valid save
	 * directory.
	 */
	static void showSaveDirectoryWindow() {
		File dir = null;
		while(dir == null || !dir.isDirectory() || !dir.canWrite()) {
			GUIMediator.showError("ERROR_INVALID_SAVE_DIRECTORY_WINDOW");
			dir = showChooser();
			FileUtils.setWriteable(dir);
		}
	}

	/**
	 * Very persistently shows the directory chooser until the user has
	 * a valid directory selected.
	 *
	 * @return the selected <tt>File</tt>, or <tt>null</tt> if there were
	 *  any problems
	 */
	private static File showChooser() {
		File dir = FileChooserHandler.getInputDirectory(null);
		if(dir == null) return null;
		try {
            SharingSettings.setSaveDirectory(dir); // updates Incomplete directory etc... 
			SharingSettings.addDirectory(dir);
            
			return dir;
		} catch(IOException e) {
			return null;
		}		
		
	}
}
