package com.limegroup.gnutella.gui;

/*
 * %W% %E%
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.net.URL;

import java.awt.Dimension;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.*;

/**
 * A JTable that can show trees in its cells.  Expanding/collapsing tree nodes
 * adds/removes rows from the table.<p>
 *
 * This class is not quite complete.
 */
public class JTreeTable extends JTable implements ThemeObserver {
	protected TreeTableCellRenderer tree;
	protected TreeTableModel        model;
	DefaultTreeCellRenderer         defaultRenderer;
	private TableColumn treeTableColumn;
	
	public JTreeTable(TreeTableModel treeTableModel) {
		super();
		model = treeTableModel;
		
		updateTheme();
		
		this.setIntercellSpacing(new Dimension(0, 0));	
		
	}
	
	
	/**
	 * Recreates all structures, necessary to stop wierd behaviour
	 * such as the first result being reprinted on every line.
	 */
	public void updateTheme() {
	    
		// Create the tree. It will be used as a renderer and editor. 
		tree = new TreeTableCellRenderer(model);
		// Install the tree editor renderer and editor. 
		setDefaultRenderer(TreeTableModel.class, tree);
		// Make the tree and table row heights the same. 
		tree.setRowHeight(getRowHeight());
		// Force the JTable and JTree to share their row selection models. 
		tree.setSelectionModel(new DefaultTreeSelectionModel() { 
			// Extend the implementation of the constructor, as if: 
			/* public this() */ {
				setSelectionModel(listSelectionModel); 
			} 
		});		    
	    
		// Install a tableModel representing the visible rows in the tree. 
		if( super.getModel() instanceof TreeTableModelAdapter) {
		    // redirect the tree.
		    ((TreeTableModelAdapter)super.getModel()).tree = tree;
		} else {
		    // create the correct model.
		    super.setModel(new TreeTableModelAdapter(model, tree));
        }
			    
		//find the column that is the treetable
		refreshTreeTableColumn();	

		defaultRenderer = new DefaultTreeCellRenderer() {
		    /**
		     * This is a hack to get the treeTable display
		     * '...' [clipped text] if the column is too small.
		     * It subtracts 'x' from the actual width, because 'x'
		     * is really the offset from the start of the tree.
		     * Example:
		     *  |      COLUMN       |
		     *  + TreeStartWithAReallyLongName
		     *  |-- ChildTreeWithSameName
		     *
		     * The distance between the '+' and the 'T' for the first
		     * TreeCell is 'x' when that cell is painted.
		     * The distaince between the | and the 'C' for the second
		     * TreeCell is 'x' when that cell is painted.
		     * But, getWidth() of the treeTableColumn is always the full
		     * width of the column.
		     */
		    public void setBounds(int x, int y, int w, int h) {
	            super.setBounds(x, y, treeTableColumn.getWidth() - x, h);
		    }
		};
		defaultRenderer.setOpaque(false);
		defaultRenderer.setBackground(null);
		defaultRenderer.setBackgroundNonSelectionColor(null); // ** jay
		tree.setCellRenderer(defaultRenderer);
		setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());  
		
		//These could be factored out.
		tree.setRootVisible(false); 
		tree.setShowsRootHandles(true);		
		this.setShowGrid(false);
		this.setColumnSelectionAllowed(false);
    }
    
    /**
     * Called from ResultPanel columnsChanged() and in constructor
     *
     * Necessary to reassign the treeTableColumn variable used 
     * by the DefaultTreeCellRenderer created in constructor
     */
    public void refreshTreeTableColumn() {
        //find the column that is the treetable
		for( int i = 0; i < getColumnCount(); i++ ) {
		    if ( getColumnClass(i) == TreeTableModel.class ) {
		        treeTableColumn = getColumnModel().getColumn(i);
		        break;
		    }
	    }
    }        

	
	/** Sets the icon to use for leaf nodes.  If icon==null, no icon
	 *  is used. 
	 *      @modifies this */   
	public void setLeafIcon(Icon icon) {
		defaultRenderer.setLeafIcon(icon);
	}
	
	/** Sets the icon to use for open non-leaf nodes.  If icon==null, no icon
	 *  is used. 
	 *      @modifies this */   
	public void setOpenIcon(Icon icon) {
		defaultRenderer.setOpenIcon(icon);
	}
	
	/** Sets the icon to use for closed non-leaf nodes.  If icon==null, no icon
	 *  is used. 
	 *      @modifies this */   
	public void setClosedIcon(Icon icon) {
		defaultRenderer.setClosedIcon(icon);
	}
	
	/** Sets this to use an "angled" line style to connect sibling nodes.
	 *     @modifies this */
	public void setAngledLines() {
		tree.putClientProperty("JTree.lineStyle", "Angled");	
	}
	
	
	/** Returns the user object associated with row i of this, or
	 *  null if now object found. */
	public Object nodeForRow(int row) {
		TreePath treePath = tree.getPathForRow(row);
		if ( treePath == null )
			return null;
		return treePath.getLastPathComponent();         
	}
	
	/** Returns true iff the given display row is expanded. */
	public boolean isExpanded(int row) {
		return tree.isExpanded(row);
	}
	
	/** Returns true iff the given display row is collapsed. */
	public boolean isCollapsed(int row) {
		return tree.isCollapsed(row);
	}
	
	public void expandPath(Object [] path) {
		tree.expandPath(new TreePath(path));
	}
	
	/** Adds a TreeExpansionListener to the uderlying tree. */
	public void addTreeExpansionListener(TreeExpansionListener l) {
		tree.addTreeExpansionListener(l);
	}
	
	/**
	 * Accessor the the <tt>JTree</tt> component.
	 */
	public JTree getTree() {
		return tree;
	}	
	
	/* Workaround for BasicTableUI anomaly. Make sure the UI never tries to 
	 * paint the editor. The UI currently uses different techniques to 
	 * paint the renderers and editors and overriding setBounds() below 
	 * is not the right thing to do for an editor. Returning -1 for the 
	 * editing row in this case, ensures the editor is never painted. 
	 */
	public int getEditingRow() {
		return (getColumnClass(editingColumn) == TreeTableModel.class) ? 
			-1 : editingRow;  
	}
	
	/** Returns the TreeTableModel passed to this. Using this, you can tell if
	 *  node is a leaf, etc. */
	public TreeTableModel getTreeTableModel() {
		return model;
	}
	
	// 
	// The renderer used to display the tree nodes, a JTree.  
	//
	public class TreeTableCellRenderer extends JTree 
		implements TableCellRenderer {
		
		protected int visibleRow;
		
		public TreeTableCellRenderer(TreeModel model) { 
			super(model); 
		}
		
		public void setBounds(int x, int y, int w, int h) {
			super.setBounds(x, 0, w, JTreeTable.this.getHeight());
		}
		
		public void paint(Graphics g) {
			g.translate(0, -visibleRow * getRowHeight());
			super.paint(g);
		}
		
		public Component getTableCellRendererComponent(JTable table,
			Object value,
			boolean isSelected,
			boolean hasFocus,
			int row, int column) {
			if(isSelected)
				setBackground(table.getSelectionBackground());
			else
				setBackground(table.getBackground());
			
			visibleRow = row;
			return this;
		}
	}
	
	// 
	// The editor used to interact with tree nodes, a JTree.  
	//
	public class TreeTableCellEditor extends AbstractCellEditor implements 
		TableCellEditor {
		public Component getTableCellEditorComponent(JTable table, Object value,
			boolean isSelected, int r, int c) {
			return tree;
		}
	}
	
}
