/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class CompoundBorder
extends AbstractBorder {
    protected Border outsideBorder;
    protected Border insideBorder;

    public CompoundBorder() {
        this.outsideBorder = null;
        this.insideBorder = null;
    }

    public CompoundBorder(Border border, Border border2) {
        this.outsideBorder = border;
        this.insideBorder = border2;
    }

    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        Insets insets2;
        insets.bottom = 0;
        insets.right = 0;
        insets.left = 0;
        insets.top = 0;
        if (this.outsideBorder != null) {
            insets2 = this.outsideBorder.getBorderInsets(component);
            insets.top += insets2.top;
            insets.left += insets2.left;
            insets.right += insets2.right;
            insets.bottom += insets2.bottom;
        }
        if (this.insideBorder != null) {
            insets2 = this.insideBorder.getBorderInsets(component);
            insets.top += insets2.top;
            insets.left += insets2.left;
            insets.right += insets2.right;
            insets.bottom += insets2.bottom;
        }
        return insets;
    }

    public Border getInsideBorder() {
        return this.insideBorder;
    }

    public Border getOutsideBorder() {
        return this.outsideBorder;
    }

    public boolean isBorderOpaque() {
        return this.outsideBorder != null && this.outsideBorder.isBorderOpaque() && this.insideBorder != null && this.insideBorder.isBorderOpaque();
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        if (this.outsideBorder != null) {
            this.outsideBorder.paintBorder(component, graphics, n5, n6, n7, n8);
            Insets insets = this.outsideBorder.getBorderInsets(component);
            n5 += insets.left;
            n6 += insets.top;
            n7 = n7 - insets.right - insets.left;
            n8 = n8 - insets.bottom - insets.top;
        }
        if (this.insideBorder != null) {
            this.insideBorder.paintBorder(component, graphics, n5, n6, n7, n8);
        }
    }
}

