/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DefaultButtonModel
implements ButtonModel,
Serializable {
    protected int stateMask = 0;
    protected String actionCommand = null;
    protected ButtonGroup group = null;
    protected int mnemonic = 0;
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    public static final int ARMED = 1;
    public static final int SELECTED = 2;
    public static final int PRESSED = 4;
    public static final int ENABLED = 8;
    public static final int ROLLOVER = 16;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public DefaultButtonModel() {
        this.setEnabled(true);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = DefaultButtonModel.class$("java.awt.event.ActionListener")), actionListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener != null ? class$javax$swing$event$ChangeListener : (class$javax$swing$event$ChangeListener = DefaultButtonModel.class$("javax.swing.event.ChangeListener")), changeListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : (class$java$awt$event$ItemListener = DefaultButtonModel.class$("java.awt.event.ItemListener")), itemListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : DefaultButtonModel.class$("java.awt.event.ActionListener"))) {
                ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent);
            }
            n -= 2;
        }
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : DefaultButtonModel.class$("java.awt.event.ItemListener"))) {
                ((ItemListener)objectArray[n + 1]).itemStateChanged(itemEvent);
            }
            n -= 2;
        }
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener != null ? class$javax$swing$event$ChangeListener : DefaultButtonModel.class$("javax.swing.event.ChangeListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public boolean isArmed() {
        return (this.stateMask & 1) != 0;
    }

    public boolean isEnabled() {
        return (this.stateMask & 8) != 0;
    }

    public boolean isPressed() {
        return (this.stateMask & 4) != 0;
    }

    public boolean isRollover() {
        return (this.stateMask & 0x10) != 0;
    }

    public boolean isSelected() {
        return (this.stateMask & 2) != 0;
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = DefaultButtonModel.class$("java.awt.event.ActionListener")), actionListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener != null ? class$javax$swing$event$ChangeListener : (class$javax$swing$event$ChangeListener = DefaultButtonModel.class$("javax.swing.event.ChangeListener")), changeListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : (class$java$awt$event$ItemListener = DefaultButtonModel.class$("java.awt.event.ItemListener")), itemListener);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public void setArmed(boolean bl) {
        if (this.isArmed() == bl || !this.isEnabled()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 1) : (this.stateMask &= 0xFFFFFFFE);
        this.fireStateChanged();
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 8) : (this.stateMask &= 0xFFFFFFF7);
        this.fireStateChanged();
    }

    public void setGroup(ButtonGroup buttonGroup) {
        this.group = buttonGroup;
    }

    public void setMnemonic(int n) {
        this.mnemonic = n;
        this.fireStateChanged();
    }

    public void setPressed(boolean bl) {
        if (this.isPressed() == bl || !this.isEnabled()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        if (!this.isPressed() && this.isArmed()) {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }
        this.fireStateChanged();
    }

    public void setRollover(boolean bl) {
        if (this.isRollover() == bl || !this.isEnabled()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 0x10) : (this.stateMask &= 0xFFFFFFEF);
        this.fireStateChanged();
    }

    public void setSelected(boolean bl) {
        if (this.isSelected() == bl) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
        this.fireItemStateChanged(new ItemEvent(this, 701, this, bl ? 1 : 2));
        this.fireStateChanged();
    }
}

