/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.keys;

import java.math.BigInteger;
import org.logi.crypto.keys.KeyException;
import org.logi.crypto.keys.RSAKey;

class RSAKeyChin
extends RSAKey {
    private BigInteger p;
    private BigInteger q;
    private BigInteger u;

    public String toString() {
        return "RSAKey(" + this.r.toString(16) + "," + this.n.toString(16) + "," + this.p.toString(16) + ")";
    }

    public void encrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.plainBlockSize();
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n, byArray3, 0, n3);
        BigInteger bigInteger = new BigInteger(1, byArray3);
        BigInteger bigInteger2 = bigInteger.modPow(this.r, this.p);
        BigInteger bigInteger3 = bigInteger.modPow(this.r, this.q);
        BigInteger bigInteger4 = bigInteger2.subtract(bigInteger3).multiply(this.u).mod(this.p).multiply(this.q).add(bigInteger3);
        byte[] byArray4 = bigInteger4.toByteArray();
        if (byArray4.length >= n3 + 1) {
            System.arraycopy(byArray4, byArray4.length - (n3 + 1), byArray2, n2, n3 + 1);
        } else {
            System.arraycopy(byArray4, 0, byArray2, n2 + (n3 + 1) - byArray4.length, byArray4.length);
            int n4 = n3 - byArray4.length;
            while (n4 >= 0) {
                byArray2[n2 + n4] = 0;
                --n4;
            }
        }
    }

    public void decrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.plainBlockSize();
        byte[] byArray3 = new byte[n3 + 1];
        System.arraycopy(byArray, n, byArray3, 0, n3 + 1);
        BigInteger bigInteger = new BigInteger(1, byArray3);
        BigInteger bigInteger2 = bigInteger.modPow(this.r, this.p);
        BigInteger bigInteger3 = bigInteger.modPow(this.r, this.q);
        BigInteger bigInteger4 = bigInteger2.subtract(bigInteger3).multiply(this.u).mod(this.p).multiply(this.q).add(bigInteger3);
        byte[] byArray4 = bigInteger4.toByteArray();
        if (byArray4.length >= n3) {
            System.arraycopy(byArray4, byArray4.length - n3, byArray2, n2, n3);
        } else {
            System.arraycopy(byArray4, 0, byArray2, n2 + n3 - byArray4.length, byArray4.length);
            int n4 = n3 - byArray4.length - 1;
            while (n4 >= 0) {
                byArray2[n2 + n4] = 0;
                --n4;
            }
        }
    }

    public RSAKeyChin(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, boolean bl) throws KeyException {
        super(bigInteger, bigInteger2, bl);
        if (!bl) {
            throw new KeyException("RSAKeyChin objects must not contain public keys");
        }
        if (bigInteger3.equals(ZERO)) {
            throw new KeyException("The given modulus factor is not correct");
        }
        BigInteger[] bigIntegerArray = bigInteger2.divideAndRemainder(bigInteger3);
        if (!bigIntegerArray[1].equals(ZERO)) {
            throw new KeyException("The given modulus factor is not correct");
        }
        this.p = bigInteger3;
        this.q = bigIntegerArray[0];
        this.u = this.q.modInverse(bigInteger3);
    }
}

