/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.HeadspaceInstrument;
import com.sun.media.sound.HeadspaceMixer;
import com.sun.media.sound.HeadspaceSoundbank;
import com.sun.media.sound.MidiOutDeviceProvider;
import com.sun.media.sound.MixerMidiChannel;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Printer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.VoiceStatus;

abstract class AbstractPlayer
extends AbstractMidiDevice
implements Synthesizer {
    private static final String[] defaultSoundbankNames = new String[]{"soundbank-deluxe.gm", "soundbank-mid.gm", "soundbank.gm", "soundbank-min.gm"};
    private static final String soundJarName = "sound.jar";
    private static final String jmfJarName = "jmf.jar";
    private static final Class[] supportedMidiOutClasses = new Class[]{class$com$sun$media$sound$SimpleOutputDevice != null ? class$com$sun$media$sound$SimpleOutputDevice : (class$com$sun$media$sound$SimpleOutputDevice = AbstractPlayer.class$("com.sun.media.sound.SimpleOutputDevice")), class$com$sun$media$sound$MidiOutDevice != null ? class$com$sun$media$sound$MidiOutDevice : (class$com$sun$media$sound$MidiOutDevice = AbstractPlayer.class$("com.sun.media.sound.MidiOutDevice"))};
    static HeadspaceMixer mixer = HeadspaceMixer.getMixerInstance();
    private static Soundbank defaultSoundbank = null;
    private Class[] orderedMidiOutClasses = new Class[]{class$com$sun$media$sound$SimpleOutputDevice != null ? class$com$sun$media$sound$SimpleOutputDevice : (class$com$sun$media$sound$SimpleOutputDevice = AbstractPlayer.class$("com.sun.media.sound.SimpleOutputDevice")), class$com$sun$media$sound$MidiOutDevice != null ? class$com$sun$media$sound$MidiOutDevice : (class$com$sun$media$sound$MidiOutDevice = AbstractPlayer.class$("com.sun.media.sound.MidiOutDevice"))};
    AbstractMidiDevice internalSynth = null;
    protected MixerMidiChannel[] channels;
    private Vector instruments = new Vector();
    private Vector transmitters = new Vector();
    private Vector receivers = new Vector();
    static /* synthetic */ Class class$com$sun$media$sound$SimpleOutputDevice;
    static /* synthetic */ Class class$com$sun$media$sound$MidiOutDevice;

    protected AbstractPlayer(MidiDevice.Info info) {
        super(info);
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer CONSTRUCTOR: " + this);
        }
        this.channels = new MixerMidiChannel[16];
        int i = 0;
        while (i < this.channels.length) {
            this.channels[i] = new MixerMidiChannel(this, i);
            ++i;
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer CONSTRUCTOR completed: " + this);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public synchronized void close() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer close(): " + this);
        }
        if (this.isOpen()) {
            int i = 0;
            while (i < this.transmitters.size()) {
                ((Transmitter)this.transmitters.elementAt(i)).close();
                ++i;
            }
            this.transmitters.removeAllElements();
            int i2 = 0;
            while (i2 < this.receivers.size()) {
                ((Receiver)this.receivers.elementAt(i2)).close();
                ++i2;
            }
            this.receivers.removeAllElements();
            this.open = false;
            this.implClose();
            mixer.close(this);
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer close() completed: " + this);
        }
    }

    protected void closeInternalSynth() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: closeInternalSynth");
        }
        if (this.internalSynth != this) {
            this.nRemoveReceiver(this.id, this.internalSynth.getId());
            this.internalSynth.close(this);
        } else {
            this.nRemoveReceiver(this.id, 0);
        }
        this.internalSynth = null;
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: closeInternalSynth completed");
        }
    }

    protected void connectToInternalSynth() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: connectToInternalSynth");
        }
        if (this.internalSynth == null) {
            if (Printer.err) {
                Printer.err("AbstractPlayer.connectToInternalSynth: internalSynth is null!");
            }
            return;
        }
        if (this.internalSynth == this) {
            AbstractPlayer abstractPlayer = this;
            synchronized (abstractPlayer) {
                this.nAddReceiver(this.id, 0);
            }
        }
        AbstractPlayer abstractPlayer = this;
        synchronized (abstractPlayer) {
            this.nAddReceiver(this.id, this.internalSynth.getId());
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: connectToInternalSynth completed");
        }
    }

    public Instrument[] getAvailableInstruments() {
        if (defaultSoundbank != null) {
            return defaultSoundbank.getInstruments();
        }
        return new Instrument[0];
    }

    public MidiChannel[] getChannels() {
        MidiChannel[] returnedChannels = new MidiChannel[this.channels.length];
        System.arraycopy(this.channels, 0, returnedChannels, 0, this.channels.length);
        return returnedChannels;
    }

    public Soundbank getDefaultSoundbank() {
        return defaultSoundbank;
    }

    public long getLatency() {
        return 0L;
    }

    public Instrument[] getLoadedInstruments() {
        Instrument[] returnedArray;
        Vector vector = this.instruments;
        synchronized (vector) {
            returnedArray = new Instrument[this.instruments.size()];
            int i = 0;
            while (i < returnedArray.length) {
                returnedArray[i] = (Instrument)this.instruments.elementAt(i);
                ++i;
            }
        }
        return returnedArray;
    }

    public int getMaxPolyphony() {
        return HeadspaceMixer.getMixerInstance().getMidiVoices();
    }

    public int getMaxReceivers() {
        return -1;
    }

    public int getMaxTransmitters() {
        return -1;
    }

    public Class[] getMidiOutClasses() {
        return this.orderedMidiOutClasses;
    }

    public synchronized Receiver getReceiver() throws MidiUnavailableException {
        PlayerReceiver receiver = new PlayerReceiver();
        this.receivers.addElement(receiver);
        return receiver;
    }

    abstract long getTimeStamp();

    public synchronized Transmitter getTransmitter() throws MidiUnavailableException {
        PlayerOutTransmitter transmitter = new PlayerOutTransmitter();
        this.transmitters.addElement(transmitter);
        return transmitter;
    }

    public VoiceStatus[] getVoiceStatus() {
        return new VoiceStatus[0];
    }

    synchronized void implClose() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: implClose");
        }
        this.closeInternalSynth();
        int oldId = this.id;
        this.id = 0;
        int i = 0;
        while (i < this.channels.length) {
            this.channels[i].setId(this.id);
            ++i;
        }
        this.nClose(oldId);
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: implClose completed");
        }
    }

    public boolean isSoundbankSupported(Soundbank soundbank) {
        return soundbank instanceof HeadspaceSoundbank;
    }

    boolean isUsingSoftwareSynth() {
        return this.internalSynth == this;
    }

    public boolean loadAllInstruments(Soundbank soundbank) {
        boolean allOk = true;
        Instrument[] instrumentArray = soundbank.getInstruments();
        int i = 0;
        while (i < instrumentArray.length) {
            if (!this.loadInstrument(instrumentArray[i])) {
                allOk = false;
            }
            ++i;
        }
        return allOk;
    }

    private Soundbank loadDefaultSoundbank() {
        HeadspaceSoundbank bank = null;
        int i = 0;
        while (i < defaultSoundbankNames.length) {
            String path;
            String soundbankName = defaultSoundbankNames[i];
            try {
                path = "file:" + soundbankName;
                URL url = new URL(path);
                if (Printer.debug) {
                    Printer.debug("Looking for soundbank: " + url);
                }
                if ((bank = new HeadspaceSoundbank(url)) != null) {
                    break;
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            String classpath = Platform.getClasspath();
            StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
            while (st.hasMoreTokens() && bank == null) {
                String classpathElement = st.nextToken();
                String issoundjar = classpathElement.substring(classpathElement.lastIndexOf(File.separatorChar) + 1, classpathElement.length());
                if (!issoundjar.equals(soundJarName) && !issoundjar.equals(jmfJarName)) continue;
                path = classpathElement.substring(0, classpathElement.lastIndexOf(File.separatorChar));
                path = String.valueOf(path) + File.separatorChar + soundbankName;
                if (Printer.debug) {
                    Printer.debug("Looking for soundbank: " + path);
                }
                try {
                    bank = new HeadspaceSoundbank(path);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (bank != null) break;
            path = Platform.getJavahome();
            path = String.valueOf(path) + File.separatorChar + "lib" + File.separatorChar + "audio" + File.separatorChar + soundbankName;
            try {
                if (Printer.debug) {
                    Printer.debug("Looking for soundbank: " + path);
                }
                if ((bank = new HeadspaceSoundbank(path)) != null) {
                    break;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ++i;
        }
        if (Printer.debug) {
            Printer.debug("Default soundbank: " + bank);
        }
        return bank;
    }

    public boolean loadInstrument(Instrument instrument) {
        if (this.instruments.contains(instrument)) {
            return true;
        }
        try {
            if (this.nLoadInstrument(this.id, ((HeadspaceInstrument)instrument).getId())) {
                this.instruments.addElement(instrument);
                return true;
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unsupported soundbank: " + instrument.getSoundbank());
        }
    }

    public boolean loadInstruments(Soundbank soundbank, Patch[] patchList) {
        boolean allOk = true;
        int i = 0;
        while (i < patchList.length) {
            Instrument instrument = soundbank.getInstrument(patchList[i]);
            if (instrument != null) {
                if (!this.loadInstrument(instrument)) {
                    allOk = false;
                }
            } else {
                allOk = false;
            }
            ++i;
        }
        return allOk;
    }

    protected native void nAddReceiver(int var1, int var2);

    protected native void nClose(int var1);

    private native boolean nLoadInstrument(int var1, int var2);

    private native boolean nRemapInstrument(int var1, int var2, int var3);

    protected native void nRemoveReceiver(int var1, int var2);

    private native boolean nUnloadInstrument(int var1, int var2);

    public synchronized void open() throws MidiUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer open(): " + this);
        }
        if (this.isOpen()) {
            if (Printer.trace) {
                Printer.trace("<< AbstractPlayer open(): already open: " + this);
            }
            return;
        }
        mixer.open(this);
        this.implOpen();
        this.open = true;
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer open(): open completed: " + this);
        }
    }

    protected void openInternalSynth() throws MidiUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: openInternalSynth: " + this);
        }
        if (this.internalSynth != null) {
            if (Printer.trace) {
                Printer.trace("<< AbstractPlayer: openInternalSynth: internalSynth already set: " + this.internalSynth);
            }
            return;
        }
        int i = 0;
        while (i < this.orderedMidiOutClasses.length) {
            if (Printer.debug) {
                Printer.debug("AbstractPlayer: openInternalSynth: checking orderedMidiOutClasses[" + i + "] : " + this.orderedMidiOutClasses[i]);
            }
            if ((class$com$sun$media$sound$MidiOutDevice != null ? class$com$sun$media$sound$MidiOutDevice : AbstractPlayer.class$("com.sun.media.sound.MidiOutDevice")).isAssignableFrom(this.orderedMidiOutClasses[i])) {
                if (Printer.debug) {
                    Printer.debug("AbstractPlayer: openInternalSynth: trying midi out");
                }
                this.internalSynth = this.openMidiOut();
                if (this.internalSynth != null) {
                    if (Printer.debug) {
                        Printer.debug("AbstractPlayer: openInternalSynth: got it! internalSynth: " + this.internalSynth);
                    }
                    return;
                }
            } else if ((class$com$sun$media$sound$SimpleOutputDevice != null ? class$com$sun$media$sound$SimpleOutputDevice : AbstractPlayer.class$("com.sun.media.sound.SimpleOutputDevice")).isAssignableFrom(this.orderedMidiOutClasses[i])) {
                if (Printer.debug) {
                    Printer.debug("AbstractPlayer: openInternalSynth: trying software midi");
                }
                if (defaultSoundbank == null) {
                    defaultSoundbank = this.loadDefaultSoundbank();
                }
                if (defaultSoundbank != null) {
                    this.internalSynth = this.openSoftwareSynth();
                    if (Printer.debug) {
                        Printer.debug("AbstractPlayer: openInternalSynth: got it! internalSynth: " + this.internalSynth);
                    }
                    return;
                }
            }
            ++i;
        }
        this.internalSynth = this.openSoftwareSynth();
        if (defaultSoundbank == null && (defaultSoundbank = this.loadDefaultSoundbank()) == null && Printer.err) {
            Printer.err("\nWARNING: The default soundbank is not loaded.\nAudio synthesis may be unavailable until instruments are loaded.\n");
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: openInternalSynth: internalSynth" + this.internalSynth);
        }
    }

    protected AbstractMidiDevice openMidiOut() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: openMidiOut");
        }
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        int j = 0;
        while (j < infoArray.length) {
            block7: {
                if (infoArray[j] instanceof MidiOutDeviceProvider.MidiOutDeviceInfo) {
                    try {
                        AbstractMidiDevice midiDevice = (AbstractMidiDevice)MidiSystem.getMidiDevice(infoArray[j]);
                        midiDevice.open();
                        if (Printer.trace) {
                            Printer.trace("<< AbstractPlayer: openMidiOut returning: " + midiDevice);
                        }
                        return midiDevice;
                    }
                    catch (MidiUnavailableException e) {
                        if (!Printer.debug) break block7;
                        Printer.debug("<< AbstractPlayer: openMidiOut: failed to open midi out device: " + e);
                    }
                }
            }
            ++j;
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: openMidiOut returning null");
        }
        return null;
    }

    protected AbstractMidiDevice openSoftwareSynth() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: openSoftwareSynth");
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: openSoftwareSynth returning: " + this);
        }
        return this;
    }

    protected boolean parse(int command, int channel, int data1, int data2, long timeStamp) {
        if (command == 128) {
            this.setTimeStamp(timeStamp);
            this.channels[channel].noteOff(data1, data2);
            return true;
        }
        if (command == 144) {
            this.setTimeStamp(timeStamp);
            this.channels[channel].noteOn(data1, data2);
            return true;
        }
        if (command == 160) {
            this.setTimeStamp(timeStamp);
            this.channels[channel].setPolyPressure(data1, data2);
            return true;
        }
        if (command == 176) {
            this.setTimeStamp(timeStamp);
            this.channels[channel].controlChange(data1, data2);
            return true;
        }
        if (command == 192) {
            this.setTimeStamp(timeStamp);
            this.channels[channel].programChange(data1, data2);
            return true;
        }
        if (command == 208) {
            this.setTimeStamp(timeStamp);
            this.channels[channel].setChannelPressure(data1);
            return true;
        }
        if (command == 224) {
            this.setTimeStamp(timeStamp);
            this.channels[channel].setPitchBend(data1 & 0xF0 | data2 & 0xF);
            return true;
        }
        return false;
    }

    public boolean remapInstrument(Instrument from, Instrument to) {
        try {
            return this.nRemapInstrument(this.id, ((HeadspaceInstrument)from).getId(), ((HeadspaceInstrument)to).getId());
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unsupported soundbank: " + from.getSoundbank() + " or " + to.getSoundbank());
        }
    }

    public void setMidiOutClasses(Class[] classes) {
        boolean ok = false;
        int i = 0;
        while (i < classes.length) {
            ok = false;
            int j = 0;
            while (j < supportedMidiOutClasses.length) {
                if (supportedMidiOutClasses[j].isAssignableFrom(classes[i])) {
                    ok = true;
                    break;
                }
                ++j;
            }
            if (!ok) {
                throw new IllegalArgumentException("Unsupported class for midi out services: " + classes[i]);
            }
            ++i;
        }
        this.orderedMidiOutClasses = classes;
    }

    abstract void setTimeStamp(long var1);

    public void unloadAllInstruments(Soundbank soundbank) {
        Instrument[] instrumentArray = soundbank.getInstruments();
        int i = 0;
        while (i < instrumentArray.length) {
            this.unloadInstrument(instrumentArray[i]);
            ++i;
        }
    }

    public void unloadInstrument(Instrument instrument) {
        try {
            if (this.nUnloadInstrument(this.id, ((HeadspaceInstrument)instrument).getId())) {
                this.instruments.removeElement(instrument);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unsupported soundbank: " + instrument.getSoundbank());
        }
    }

    public void unloadInstruments(Soundbank soundbank, Patch[] patchList) {
        int i = 0;
        while (i < patchList.length) {
            Instrument instrument = soundbank.getInstrument(patchList[i]);
            if (instrument != null) {
                this.unloadInstrument(instrument);
            }
            ++i;
        }
    }

    class PlayerOutTransmitter
    implements Transmitter {
        private boolean open = true;
        private Receiver receiver = null;

        PlayerOutTransmitter() {
        }

        public void close() {
            AbstractPlayer.this.transmitters.removeElement(this);
            this.open = false;
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public void setReceiver(Receiver receiver) {
            this.receiver = receiver;
        }
    }

    class PlayerReceiver
    implements Receiver {
        private boolean open = true;

        PlayerReceiver() {
        }

        public void close() {
            AbstractPlayer.this.receivers.removeElement(this);
            this.open = false;
        }

        public void send(MidiMessage message, long timeStamp) {
            if (!this.open) {
                return;
            }
            if (AbstractPlayer.this.id == 0) {
                throw new IllegalStateException("Synthesizer is not open.");
            }
            Vector vector = AbstractPlayer.this.transmitters;
            synchronized (vector) {
                int i = 0;
                while (i < AbstractPlayer.this.transmitters.size()) {
                    Receiver receiver = ((Transmitter)AbstractPlayer.this.transmitters.elementAt(i)).getReceiver();
                    if (receiver != null) {
                        receiver.send(message, timeStamp);
                    }
                    ++i;
                }
            }
            if (!(message instanceof ShortMessage)) {
                if (Printer.err) {
                    Printer.err("Unsupported message type: " + message);
                }
                return;
            }
            ShortMessage shortMessage = (ShortMessage)message;
            AbstractPlayer.this.parse(shortMessage.getCommand(), shortMessage.getChannel(), shortMessage.getData1(), shortMessage.getData2(), timeStamp);
        }
    }
}

