/*
 * GXMame
 *
 * Copyright 2002-2004 Stephane Pontier <shadow_walker@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __COMMON_H__
#define __COMMON_H__

/* #define _POSIX_C_SOURCE 199506L */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <kdebug.h>

#define DOT_GXMAME	".kxmame"
#define ENABLE_NLS

extern "C" {
#include <glib.h>
}

#ifdef ENABLE_DEBUG

#ifdef __GNUC__
#define GXMAME_DEBUG(format, args...) g_log (NULL, G_LOG_LEVEL_DEBUG, format, ##args)
#else
# include <stdarg.h>
static void GXMAME_DEBUG (const gchar *format, ...)
{
	va_list args;
	va_start (args, format);
	g_logv (NULL, G_LOG_LEVEL_DEBUG, format, args);
	va_end (args);
}
#endif /* __GNUC__ */

#else
#  ifdef __GNUC___
#    define GXMAME_DEBUG(msg...) do { } while(0)
#  else
#    define GXMAME_DEBUG(...) do { } while(0)
#  endif
#endif /* ENABLE_DEBUG */


#define ERROR 		1
#define	WARNING 	2
#define	MESSAGE		3

bool confirmMessage(const QString &str);

void gxmame_message (int type, void *parent, const QString &);
//	__attribute__((format (printf, 3, 4)));

__attribute__ ((unused)) static void k_message (const QString &str) {
	kdDebug() << str << endl;
}

#define kxmame_replace(a,b) {if(a) g_free(a); (a) = (b);}

#endif
