/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <kdialog.h>
#include <klocale.h>
#include <kdebug.h>

#include "screentab.h"
#include "gxmame.h"
//#include "kxinewidget.h"

#include <klibloader.h>
#include <kparts/factory.h>
#include <kparts/part.h>

class QTime;

#include <qvariant.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qtimer.h>


/*
 *  Constructs a MySnapTab as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 */
MySnapTab::MySnapTab( QWidget* parent, const char* name, WFlags fl )
	: QWidget( parent, name, fl )
{
	if ( !name )
		setName( "MySnapTab" );
	setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)7, 0, 0, sizePolicy().hasHeightForWidth() ) );
	MySnapTabLayout = new QHBoxLayout( this, 0, 6, "MySnapTabLayout"); 

	screenshotTab = new QTabWidget( this, "screenshotTab" );
	screenshotTab->setTabShape( QTabWidget::Triangular );
	screenshotTab->setMargin( 0 );

	snapTab = new QWidget( screenshotTab, "tab" );
	tabLayout = new QHBoxLayout( snapTab, 0, 6, "tabLayout"); 

	snapPixmap = new kxmameSnapLabel( snapTab, "snapPixmap" );
	snapPixmap->setMinimumSize( QSize( 320, 240 ) );
	tabLayout->addWidget( snapPixmap );
	screenshotTab->insertTab( snapTab, QString::fromLatin1("") );

	flyerTab = new QWidget( screenshotTab, "tab_2" );
	tabLayout_2 = new QHBoxLayout( flyerTab, 0, 6, "tabLayout_2"); 

	flyerPixmap = new kxmameSnapLabel( flyerTab, "flyerPixmap" );
	flyerPixmap->setMinimumSize( QSize( 320, 240 ) );
	tabLayout_2->addWidget( flyerPixmap );
	screenshotTab->insertTab( flyerTab, QString::fromLatin1("") );

	cabTab = new QWidget( screenshotTab, "TabPage" );
	TabPageLayout = new QHBoxLayout( cabTab, 0, 6, "TabPageLayout"); 

	cabPixmap = new kxmameSnapLabel( cabTab, "cabPixmap" );
	cabPixmap->setMinimumSize( QSize( 320, 240 ) );
	TabPageLayout->addWidget( cabPixmap );
	screenshotTab->insertTab( cabTab, QString::fromLatin1("") );

	marqueeTab = new QWidget( screenshotTab, "TabPage_2" );
	TabPageLayout_2 = new QHBoxLayout( marqueeTab, 0, 6, "TabPageLayout_2"); 

	marqueePixmap = new kxmameSnapLabel( marqueeTab, "marqueePixmap" );
	marqueePixmap->setMinimumSize( QSize( 320, 240 ) );
	TabPageLayout_2->addWidget( marqueePixmap );
	
	screenshotTab->insertTab( marqueeTab, QString::fromLatin1("") );

	titleTab = new QWidget( screenshotTab, "TabPage_3" );
	TabPageLayout_3 = new QHBoxLayout( titleTab, 0, 6, "TabPageLayout_3"); 

	titlePixmap = new kxmameSnapLabel( titleTab, "titlePixmap" );
	titlePixmap->setMinimumSize( QSize( 320, 240 ) );
	TabPageLayout_3->addWidget( titlePixmap );
	screenshotTab->insertTab( titleTab, QString::fromLatin1("") );
	
	mVideoPreview = NULL;
	noVideoLabel = NULL;
	videoTab = NULL;
	
	if(gui_prefs.showVideoPreview) {
		videoTab = new QWidget( screenshotTab, "TabPage_4" );
		TabPageLayout_4 = new QVBoxLayout( videoTab, 0, 6, "TabPageLayout_4"); 
	
		noVideoLabel = new kxmameSnapLabel( videoTab );
		noVideoLabel->setMinimumSize( QSize( 320, 240 ) );
		TabPageLayout_4->addWidget( noVideoLabel );
	
		initVideo();
		
		screenshotTab->insertTab( videoTab, QString::fromLatin1("") );
	}
	MySnapTabLayout->addWidget( screenshotTab );
	languageChange();
	resize( QSize(644, 407).expandedTo(minimumSizeHint()) );
	clearWState( WState_Polished );
}

/*
 *  Destroys the object and frees any allocated resources
 */
MySnapTab::~MySnapTab()
{
	if (mVideoPreview) delete mVideoPreview;
}

void MySnapTab::initVideo()
{
	if(!gui_prefs.showVideoPreview) return;
	if(!videoTab) return;
	
	if(mVideoPreview)
		delete mVideoPreview;
		
	// Try to find libkaffeinepart
	KLibFactory *factory = KLibLoader::self()->factory( "libkaffeinepart" );
	if (factory) {
		// Create the part
		mVideoPreview = (KParts::ReadOnlyPart *)factory->create( videoTab, "KaffeinePart",
		"KParts::ReadOnlyPart" );
		mVideoPreview->widget()->setMinimumSize( QSize( 320, 240 ) );
		TabPageLayout_4->addWidget( mVideoPreview->widget() );
		mVideoPreview->widget()->show();
	} else {
		mVideoPreview = NULL;
		kdDebug() << i18n("No libkaffeinepart found! Please install kaffeine if you want video preview.")
				<< endl;
	}

	if(!mVideoPreview) {
		noVideoLabel->setOnOff(TRUE);
	} else {
		noVideoLabel->setOnOff(FALSE);
	}
}

void MySnapTab::stopVideo()
{
	if(!gui_prefs.showVideoPreview) return;
	if(mVideoPreview) mVideoPreview->closeURL();
}

void MySnapTab::removeVideo()
{
	if(!gui_prefs.showVideoPreview) return;
	if(!videoTab) return;
	
	if (mVideoPreview) {
		delete mVideoPreview;
		mVideoPreview = NULL;
	}
	noVideoLabel->setOnOff(TRUE);
}


/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void MySnapTab::languageChange()
{
	screenshotTab->changeTab( snapTab, tr2i18n( "S&nap" ) );
	screenshotTab->changeTab( flyerTab, tr2i18n( "Fl&yer" ) );
	screenshotTab->changeTab( cabTab, tr2i18n( "C&ab" ) );
	screenshotTab->changeTab( marqueeTab, tr2i18n( "Mar&quee" ) );
	screenshotTab->changeTab( titleTab, tr2i18n( "Title" ) );
	screenshotTab->changeTab( videoTab, tr2i18n( "Video" ) );
}

#include "screentab.moc"
