/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * GXMame
 *
 * Copyright 2002-2004 Stephane Pontier <shadow_walker@users.sourceforge.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <klocale.h>

#include "common.h"
#include "properties.h"

#include "gxmame.h"
#include "gui.h"
#include "io.h"
#include "options_string.h"

extern "C" {
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
}

#define BUFFER_SIZE 1000

// char * get_rom_clone_name (RomEntry *);
// char * get_rom_cpu_value (RomEntry *);
// char * get_rom_sound_value (RomEntry *);

char *
get_rom_clone_name (RomEntry *rom)
{
	GList   *l;
	char    *value = NULL;
	gboolean game_found = FALSE;

	/* find the clone name if there is a clone */
	if (strcmp (rom->cloneof, "-")) {
		RomEntry *tmprom;

		for (l = g_list_first (game_list.roms), game_found = FALSE; l; l = g_list_next (l)) {

			tmprom = (RomEntry *)l->data;
			if (!strcmp (tmprom->romname, rom->cloneof)) {
				if (tmprom->the_trailer && gui_prefs.ModifyThe)
					value = g_strdup_printf ("%s, The %s - \"%s\"",
								 tmprom->gamename, tmprom->gamenameext, rom->cloneof);
				else if (tmprom->the_trailer && !gui_prefs.ModifyThe)
					value = g_strdup_printf ("The %s %s - \"%s\"",
								 tmprom->gamename, tmprom->gamenameext, rom->cloneof);
				else
					value = g_strdup_printf ("%s %s - \"%s\"",
								 tmprom->gamename, tmprom->gamenameext, rom->cloneof);
				break;
			}
		}

		if (!value)
			value = g_strdup_printf (" - \"%s\"", rom->cloneof);
	}

	return value;
}

char *
get_rom_cpu_value (RomEntry *rom)
{
	char *value = NULL;
	char *values [NB_CPU];
	gint  i, j;

	j = 0;
	values[j] = NULL;
	for (i = 0; i < NB_CPU; i++) {
		if (strcmp (rom->cpu_info[i].name, "-")
		    && rom->cpu_info[i].name[0] != '\0') {
			values[j++] = g_strdup_printf ("%s %f MHz%s",
					rom->cpu_info[i].name,
					rom->cpu_info[i].clock / 1000000.0,
					rom->cpu_info[i].sound_flag ? " (sound)" : " ");
					//rom->cpu_info[i].sound_flag ? i18n(" (sound)") : " ");
		}
	}
	values[j++] = NULL;

	value = g_strjoinv ("\n", values);

	for (i = 0; i < j; i++)
		g_free (values[i]);

	return value;
}

char *
get_rom_sound_value (RomEntry *rom)
{
	char *value = NULL;
	char *values [NB_CPU];
	gint  i, j;

	j = 0;
	values[j] = NULL;
	for (i = 0; i < NB_CPU; i++) {
		if (strcmp (rom->sound_info[i].name, "-")
		    && rom->sound_info[i].name[0]) {
			if (rom->sound_info[i].clock == 0)
				values[j++] = g_strdup_printf ("%s", rom->sound_info[i].name);
			else
				values[j++] = g_strdup_printf ("%s %f MHz",
							      rom->sound_info[i].name,
							      rom->sound_info[i].clock / 1000000.0);
		}
	}
	values[j++] = NULL;

	value = g_strjoinv ("\n", values);

	for (i = 0; i < j; i++)
		g_free (values[i]);

	return value;
}

