/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KXMAMEPREF_H_
#define _KXMAMEPREF_H_

#include <kdialogbase.h>
#include <qhbox.h>
#include <qframe.h>
#include <qvariant.h>
#include <qwidget.h>

#include "gameinfo.h"
#include "DisplayPref.h"
#include "x11render.h"
#include "GLrender.h"
#include "sdlrender.h"
#include "soundpref.h"
#include "vectorpref.h"
#include "ctrlpref.h"
#include "miscpref.h"
#include "startuppref.h"

#include "game_options.h"
#include "game_list.h"

extern "C" {
#include <stdlib.h>
#include <unistd.h>
#include <glib.h>
}

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QGroupBox;
class QLabel;
class KComboBox;
class QCheckBox;
class QComboBox;
class KDoubleNumInput;
class QLineEdit;
class KIntNumInput;
class KLineEdit;

class kxmameDisplayPref;
class kxmameRenderPref;
class kxmameSoundPref;
class kxmameVectorPref;
class kxmameCtrlPref;
class kxmameMiscPref;
class kxmameStartupPref;
class kxmameGamePref;

class kxmamePreferences : public KDialogBase
{
    Q_OBJECT
public:
	kxmamePreferences(RomEntry *);
	~kxmamePreferences();
	
	void combo_init (QComboBox   *combo, const gchar *option,
		const gchar *key, gint value);
	
	GameOptions *localGameOpts;
	
	//Some gui startup options is copied locally
	bool gui_joy, GameCheck, VersionCheck;
	bool use_xmame_options, scaledScreenshot, showVideoPreview;
	gint iconSize;
	gchar Joystick_in_GUI[256];
	
	bool isModified, isDefault;

protected :
	void setupGamePrefFrame(void);
	void setupDisplayPrefFrame(void);
	void setupRenderPrefFrame(void);
	void setupSoundPrefFrame(void);	
	void setupVectorPrefFrame(void);
	void setupCtrlPrefFrame(void);
	void setupMiscPrefFrame(void);
	void setupKxmamePrefFrame(void);
	
	void OptModified();
	
public slots:

	void slotDefault();
	void auditRom();
	void auditSample();
	void setDirty(bool state) { localGameOpts->dirty = state; OptModified();}
	void setThrottle(bool state) { localGameOpts->throttle = state; OptModified();}
	void setSleepIdle(bool state) { localGameOpts->sleepidle = state; OptModified();}
	void setScanlines(bool state){ localGameOpts->scanlines = state;OptModified();}
	void setHeightScale(int val){ localGameOpts->heightscale = val; OptModified();}
	void setWidthScale(int val){ localGameOpts->widthscale = val; OptModified();}
	void setBpp(int);
	void setArbHeight(int val){ localGameOpts->arbheight = val; OptModified();}
	void setArbHeightToggle(bool val);
	void setAutoDouble(bool state){ localGameOpts->autodouble = state;OptModified();}
	void setRotate(int);
	void setNoRotate(bool state){ localGameOpts->norotate = state;OptModified();}
	void setFlipx(bool state){ localGameOpts->flipx = state;OptModified();}
	void setFlipy(bool state){ localGameOpts->flipy = state;OptModified();}
	void setAutoFrameSkip(bool state);
	void setEffect(int ef){ localGameOpts->effect = ef; OptModified();}
	void setFrameToSkip(int val){ localGameOpts->frameskip = val; OptModified();}
	void setFrameMethod(int val){ localGameOpts->frameskipper = val; OptModified();}
	void setMaxFrame(int val){ localGameOpts->maxautoframeskip = val; OptModified();}
	
	void setVideoMode(int mode){ localGameOpts->x11_mode = mode; OptModified();}
	void setYuvMode(int mode){ localGameOpts->force_yuv = mode; OptModified();}
	void setFullScreen(bool state){ localGameOpts->fullscreen = state;OptModified();}
	void setCursor(bool state){ localGameOpts->cursor = state;OptModified();}
	void setMit(bool state){ localGameOpts->mitshm = state;OptModified();}
	void setGamma(int);
	void setBrightness(int);
	void setXVgeometry(bool);
	void setColorMap(bool state){ localGameOpts->privatecmap = state;OptModified();}
	void setXSync(bool state){ localGameOpts->xsync = state;OptModified();}
	void setXil(bool state){ localGameOpts->xil = state;OptModified();}
	void setXilMt(bool state){ localGameOpts->mtxil = state;OptModified();}
	void setGlTextureSize(int val){ localGameOpts->gltexture_size = val; OptModified();}
	void setAliasing(bool state){ localGameOpts->glantialias = state;OptModified();}
	void setColorMod(bool state){ localGameOpts->glcolormod = state;OptModified();}
	void setBilinear(bool state){ localGameOpts->glbilinear = state;OptModified();}
	void setGlDoubleBuf(bool state){ localGameOpts->gldblbuffer = state;OptModified();}
	void setBlending(bool state){ localGameOpts->glalphablending = state;OptModified();}
	void setExt78(bool state){ localGameOpts->glext78 = state;OptModified();}
	void setGlBlitter(bool state){ localGameOpts->glforceblitmode = state;OptModified();}
	void setGlBitmap(bool state){ localGameOpts->gldrawbitmap = state;OptModified();}
	void setCabinet(bool);
	void setCabinetFile(const QString &file){ strncpy( localGameOpts->cabinet, file, 20);OptModified();}
	void setGlLib(const QString &file) { strncpy( localGameOpts->gllibname, file, 20);OptModified();}
	void setGluLib(const QString &file) { strncpy( localGameOpts->glulibname, file, 20);OptModified();}
	void setGlResFlag(bool);
	void setGlRes(int);
	void setSdlDoubleBuffer(bool state){ localGameOpts->sdl_doublebuf = state;OptModified();}
	void setSdlAutoMode(bool);
	void setSdlMode(int val){ localGameOpts->modenumber = val; OptModified();}
	void setAspectToggle(bool);
	void setAspect(double val){ localGameOpts->displayaspectratio = gfloat(val);OptModified();}
	void setDisableMode(const QString &mode) { strncpy( localGameOpts->disablemode, mode, 14);OptModified();}
	
	void setSound(bool);
	void setSoundSample(bool state){localGameOpts->samples = state; OptModified();}
	void setSoundFake(bool state){ localGameOpts->fakesound = state; OptModified();}
	void setSampleFreq(const QString &val) { localGameOpts->samplefre = atoi(val); OptModified();}
	void setVolume(int);
	void setSoundBuffer(int);
	void setDspPlugin(const QString &);
	void setMixerPlugin(const QString &);
	void setSoundFile(const QString &file) { strncpy( localGameOpts->soundfile, file, 20);OptModified();}
	void setTimer(bool state){ localGameOpts->timer = state; OptModified();}
	void setQnxDev(bool state){ localGameOpts->audio_preferred = state; OptModified();}
	void setArtsBuffer(int val){ localGameOpts->artsBufferTime = val; OptModified();}
	void setAlsaBuffer(int val){ localGameOpts->alsa_buffer = val; OptModified();}
	void setAlsaCard(int val){ localGameOpts->alsacard = val; OptModified();}
	void setAlsaDevice(int val){ localGameOpts->alsadevice = val; OptModified();}
	void setAlsaPcm(const QString &str) { strncpy( localGameOpts->alsa_pcm, str, 20);OptModified();}
	
	void setVectorAA(bool state){ localGameOpts->antialias = state; OptModified();}
	void setVectorTran(bool state){ localGameOpts->translucency = state; OptModified();}
	void setBeam(int val);
	void setFlicker(int val);
	void setIntensity(int val);
	void setVectorResCheck(bool state);
	void setVectorRes(const QString &str) { strncpy( localGameOpts->vectorres, str, 9);OptModified();}
	void setVectorGlBitmap(bool state){ localGameOpts->gldrawbitmapvec = state; OptModified();}
	void setVectorGlAA(bool state){ localGameOpts->glantialiasvec = state; OptModified();}
	
	void setJoyType(int);
	void setJoyType(const QString &str);
	void setJoyDev(const QString &str) { strncpy( localGameOpts->joydevname, str, 20);OptModified();}
	void setPadDev(const QString &str) { strncpy( localGameOpts->paddevname, str, 20);OptModified();}
	void setX11Joy(const QString &str) { strncpy( localGameOpts->x11joyname, str, 20);OptModified();}
	void setTrackBall1(const QString &str) { strncpy(localGameOpts->XInput_trackball1, str, 20);OptModified();}
	void setTrackBall2(const QString &str) { strncpy(localGameOpts->XInput_trackball2, str, 20);OptModified();}
	void setTrackBall3(const QString &str) { strncpy(localGameOpts->XInput_trackball3, str, 20);OptModified();}
	void setTrackBall4(const QString &str) { strncpy(localGameOpts->XInput_trackball4, str, 20);OptModified();}
	void setAnalog(bool state){ localGameOpts->analogstick = state; OptModified();}
	void setHotrod(bool state){ localGameOpts->hotrod = state; OptModified();}
	void setHotrodSE(bool state){ localGameOpts->hotrodse = state; OptModified();}
	void setUsbPs(bool state){ localGameOpts->usbpspad = state; OptModified();}
	void setUGCI(bool state){ localGameOpts->ugcicoin = state; OptModified();}
	void setRapid(bool state){ localGameOpts->rapidfire = state; OptModified();}
	void setMouse(bool state);
	void setGrabMouse(bool state){ localGameOpts->grabmouse = state; OptModified();}
	void setWinKeyb(bool state){ localGameOpts->winkeys = state; OptModified();}
	void setUseKeybCfg(bool);
	void setKeybCfg(const QString &str) { strncpy (localGameOpts->cfgname, str, 20);OptModified();}
	void setGrabKeyb(bool state){ localGameOpts->grabkeyboard = state; OptModified();}
	void setKeymap(const QString &str);
	void setCtrl(const QString &str) { strncpy (localGameOpts->ctrlr, str, 20);OptModified();}
	
	void setArtwork(bool state);
	void setCheat(bool state){ localGameOpts->cheat = state; OptModified();}
	void setArtBackdrop(bool state){ localGameOpts->use_backdrops = state; OptModified();}
	void setArtBezel(bool state){ localGameOpts->use_bezels = state; OptModified();}
	void setArtOverlay(bool state){ localGameOpts->use_overlays = state; OptModified();}
	void setArtCrop(bool state){ localGameOpts->artwork_crop = state; OptModified();}
	void setKeybLed(bool state){ localGameOpts->keyboard_leds = state; OptModified();}
	void setArtRes(int val) { localGameOpts->artwork_resolution = val; OptModified();}
	void setBios(int val) { localGameOpts->bios = val; OptModified();}
	void setAddOptsCheck(bool);
	void setAddOpts(const QString &);
	void setDisclaimer(bool state) { localGameOpts->skip_disclaimer = state; OptModified();}
	void setGameInfo(bool state) { localGameOpts->skip_gameinfo = state; OptModified();}
	void setLog(bool);
	void setDebug(bool);
	void setLogFile(const QString &str) { strncpy (localGameOpts->log, str, 20); OptModified();}
	void setDebugSize(const QString &str) { strncpy (localGameOpts->debug_size, str, 20); OptModified();}
	
	void setXmameOpts(bool state){ use_xmame_options = state;OptModified();}
	void setGameCheck(bool state){ GameCheck = state;OptModified();}
	void setVersionCheck(bool state){ VersionCheck = state;OptModified();}
	void setJoyGui(bool state);
	void setJoyGuiDev(const QString &str){ strncpy(Joystick_in_GUI, str, 256);OptModified();}
	void setIconSize(int val){ iconSize = val*8;OptModified();}
	void setScaledScreenshot(bool state){ scaledScreenshot = state; OptModified();}
	void setVideoPreview(bool state){ showVideoPreview = state; OptModified();}
	
private:
	kxmameGamePref *m_gamePage;
	kxmameDisplayPref *m_displayPage;
	kxmameRenderPref *m_renderPage;
	kxmameSoundPref *m_soundPage;
	kxmameVectorPref *m_vectorPage;
	kxmameCtrlPref *m_ctrlPage;
	kxmameMiscPref *m_miscPage;
	kxmameStartupPref *m_kxmamePage;
	
	RomEntry *mRom;
};

class kxmameGamePref : public QWidget
{
	Q_OBJECT
	public:
		kxmameGamePref(QWidget *parent = 0);
		gamePrefWidget *mGameFrame;
};

class kxmameDisplayPref : public QWidget
{
	Q_OBJECT
	public:
		kxmameDisplayPref(QWidget *parent = 0);
		displayPrefFrame *mDisplayFrame;

};
class kxmameSoundPref : public QWidget
{
	Q_OBJECT
	public:
		kxmameSoundPref(QWidget *parent = 0);
		void file_or_device (bool);
		soundPrefFrame *mSoundFrame;
};

class kxmameVectorPref : public QWidget
{
	Q_OBJECT
	public:
		kxmameVectorPref(QWidget *parent = 0);
		vectorPrefFrame *mVectorFrame;
};

class kxmameCtrlPref : public QWidget
{
	Q_OBJECT
	public:
		kxmameCtrlPref(QWidget *parent = 0);
		ctrlPrefFrame *mCtrlFrame;
};

class kxmameMiscPref : public QWidget
{
	Q_OBJECT
	public:
		kxmameMiscPref(QWidget *parent = 0);
		miscPrefFrame *mMiscFrame;
};

class kxmameStartupPref : public QWidget
{
	Q_OBJECT
	public:
		kxmameStartupPref(QWidget *parent = 0);
		startupPrefWidget *mKxmameFrame;
};

class kxmameRenderPref : public QWidget
{
	Q_OBJECT
	public:
		kxmameRenderPref(QWidget *parent = 0);
		
		x11Render *mX11Render;
		glRender *mGlRender;
		sdlRender *mSdlRender;
		
		QGroupBox* groupBox5;
		QCheckBox* aspectCheck;
		KDoubleNumInput* arDoubleNumInput;
		QLabel* textLabel4;
		QLineEdit* disableModeEdit;
	
	protected:
		QHBoxLayout *layout;
		QHBoxLayout* groupBox5Layout;
		QVBoxLayout* layout23;
		QHBoxLayout* layout22;
		QSpacerItem* spacer15;
		QHBoxLayout* layout21;
		QSpacerItem* spacer16;
		QVBoxLayout* layout31;
		QSpacerItem* spacer21;
};

#endif // _KXMAMEPREF_H_
