/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KXMAMESNAPLABEL_H_
#define _KXMAMESNAPLABEL_H_

#include <qpainter.h>
#include <qlabel.h>
#include <qevent.h>
#include <qscrollview.h>

//subclassing qScrollView to allow for scaledContent with 
//	proper aspect ratio and automatic scrollbars.
class kxmameSnapLabel : public QScrollView
{
	Q_OBJECT
	public:
		kxmameSnapLabel( QWidget *parent, const char* name=0, WFlags f=0 );
		~kxmameSnapLabel();
		void setScaledContents(bool state);
		void setPixmap(const QPixmap &pixmap );
		void setOnOff(bool);	//whether or not the labe should if disable
		 			// used to show videoPreview or other widgets
	protected:
		QLabel *mLabel;
		QPixmap *mPixmap;
		bool scaledContents, isOn;
		virtual void drawContents(QPainter *p, int, int, int, int);
};

#endif
