/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

// This is essentially C++ -ized gtkjoy.c from gxmame.

#include <qsocketnotifier.h>
#include <klistview.h>
#include "kxmame.h"
#include "kxmame_joy.h"
#include "common.h"
#include "gtkjoy.h"
#include "gxmame.h"
#include "gui.h"

extern "C" {
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>

#ifdef ENABLE_JOYSTICK
# ifdef HAVE_LINUX_JOYSTICK_H
#   include <linux/joystick.h>
# else
#   error Joystick is only supported on Linux. Reconfigure with --disable-joystick.
#   undef ENABLE_JOYSTICK
# endif
#endif

}

#define AXIS_MAX	32767
#define AXIS_MIN	-32768

#ifdef ENABLE_JOYSTICK
//static guint repeat_source_id;
static joyNotifier *mNotifier;

static void on_joystick_event (gint eventtype, gint button);
#endif
static void move_up(int);
static void move_down(int);
static void toggle_expand(void);
static gint row_number(void);


const char *
get_joy_dev (void)
{
	static char *joy_dev_name[] = {
		"/dev/js0",
		"/dev/input/js0",
		"/dev/joy0",
		NULL
	};
	int i;

	for (i = 0; joy_dev_name[i]; i++) {
		if (g_file_test (joy_dev_name[i], G_FILE_TEST_EXISTS))
			break;
	}

	if (joy_dev_name[i])
		return joy_dev_name[i];
	else
		return joy_dev_name[0];
}

//#define JOY_TIMEOUT 30

gboolean joystick_focus;
Joystick *joydata;

joyNotifier::~joyNotifier ()
{
	if (mFd != 0)
		close(mFd);
	mFd = 0;
}

joyNotifier::joyNotifier( int socket, Type type, QObject * parent, const char * name )
	:QSocketNotifier (socket,type,parent,name )
{
	mFd = socket;
	connect(this, SIGNAL(activated(int)), this, SLOT(joystick_io_func(int )));
}

void joyNotifier::joystick_io_func (int socket)
{
#ifdef ENABLE_JOYSTICK
	struct js_event js;
	char buf[sizeof (struct js_event)];
	gsize readrc;

	if (!joydata) {
		GXMAME_DEBUG ("joystick_event: improper callback registration, %u", __LINE__);
		return;
	}

	readrc = read(socket, &buf, sizeof (struct js_event) );

	if (readrc != sizeof (struct js_event)) {
		GXMAME_DEBUG ("source, %d bytes read", readrc);
		return;
	}

	memcpy (&js, buf, sizeof (struct js_event));
	switch (js.type & ~JS_EVENT_INIT) {
	case JS_EVENT_BUTTON:
		if (js.number < joydata->num_buttons) 
			joydata->buttons[js.number] = js.value;
		break;
	case JS_EVENT_AXIS:
		if (js.number < joydata->num_axis) 
			joydata->axis[js.number] = js.value;
		break;
	}

	on_joystick_event (js.type, js.number);	
	return;
#endif	
}


Joystick *   
joystick_new (char * joystick)
{
#ifdef ENABLE_JOYSTICK
	//Joystick *joydata;
	int joystickfd;
	const char *devname;
	char name[128] = "Unknown";

	mNotifier = NULL;
	
	/* open joystick device */
	devname = (joystick) ? joystick : get_joy_dev ();
	
	joystickfd = open (devname, O_RDONLY);

	if (joystickfd < 0) {
		if ( errno == ENODEV ) {
			GXMAME_DEBUG ("Device not configured - did you load the module?");
		} else {
			GXMAME_DEBUG ("Couldn't open '%s'", devname);
			perror (devname);
		}
		return NULL;
	}
	
	joydata = (Joystick *) g_malloc (sizeof (Joystick));
	if (!joydata)
		return NULL;

	memset (joydata, 0, sizeof (Joystick));

	fcntl (joystickfd, F_SETFL, fcntl(joystickfd, F_GETFL) | O_ASYNC );
	ioctl (joystickfd, JSIOCGAXES, &joydata->num_axis);
	ioctl (joystickfd, JSIOCGBUTTONS, &joydata->num_buttons);
	ioctl (joystickfd, JSIOCGNAME (128), name);

	joydata->device_name = g_strdup (name);
	if (!joydata->device_name) {
		g_free (joydata);
		return NULL;
	}

	joydata->axis = (int *)g_malloc (joydata->num_axis * sizeof (int));
	if (!joydata->axis) {
		g_free (joydata->device_name);
		g_free (joydata);
		return NULL;
	}
	joydata->buttons = (int *)g_malloc (joydata->num_buttons * sizeof (int));
	if (!joydata->buttons) {
		g_free (joydata->device_name);
		g_free (joydata->axis);
		g_free (joydata);
		return NULL;
	}

	mNotifier = new joyNotifier(joystickfd, QSocketNotifier::Read, 0);
	
	return joydata;
#else
	return NULL;
#endif /* ENABLE_JOYSTICK */
}


void
joystick_close (Joystick * joydata)
{
#ifdef ENABLE_JOYSTICK
	if (!joydata) return;

	if (mNotifier) 
		delete mNotifier;
	mNotifier = NULL;
	
	g_free (joydata->device_name);
	g_free (joydata->axis);
	g_free (joydata->buttons);
	g_free (joydata);
	joydata = NULL;
#endif	
}

void
joy_focus_on (void)
{
	joystick_focus = TRUE;
}

void
joy_focus_off (void)
{
	joystick_focus = FALSE;
}

#ifdef ENABLE_JOYSTICK

#ifdef NOT_DEFINED /* Beautiful commenting */
static gboolean joy_left_repetition (gpointer data)
{
	move_up (row_number ());
	//repeat_source_id = g_timeout_add (JOY_TIMEOUT, (GSourceFunc)joy_left_repetition, NULL);
	return FALSE;
}

static gboolean joy_right_repetition (gpointer data)
{
	move_down (row_number ());
	//repeat_source_id = g_timeout_add (JOY_TIMEOUT, (GSourceFunc)joy_right_repetition, NULL);
	return FALSE;
}

static gboolean joy_up_repetition (gpointer data)
{
	move_up (1);
	//repeat_source_id = g_timeout_add (JOY_TIMEOUT, (GSourceFunc)joy_up_repetition, NULL);
	return FALSE;
}

static gboolean joy_down_repetition (gpointer data)
{
	move_down (1);
	//repeat_source_id = g_timeout_add (JOY_TIMEOUT, (GSourceFunc)joy_down_repetition, NULL);
	return FALSE;
}
#endif /* Beautiful commenting */

static void
on_joystick_event (gint eventtype, gint button)
{
	/*the focus is not set: another windows has been opened
	 or this is an init event */
	if (!joystick_focus || (eventtype & JS_EVENT_INIT))
		return;

	GXMAME_DEBUG ("joy: event=%i, button=%i", eventtype, button);
	
	if ((eventtype & JS_EVENT_BUTTON) && (button < joydata->num_buttons)) {
		GXMAME_DEBUG ("Joystick button %i %s", button, (joydata->buttons[button])?"pressed":"released");
		/* Button released*/
		if (joydata->buttons[button] == 0)
			switch (button) {
			case 0:
			case 2:
				play_game (mainView->currentRom());
				break;
			case 1:
				toggle_expand ();
				break;
		}
	} else if ( (eventtype & JS_EVENT_AXIS) && (button < joydata->num_axis)) {
// 		if (repeat_source_id)
// 			g_source_remove (repeat_source_id);

		/* LEFT and RIGHT directions
		* (even Axis number)
		*/
		if (! (button & 1)) {
			if (joydata->axis[button] > (AXIS_MAX / 2)) {
				GXMAME_DEBUG ("Joystick axis %i pushed right", button);
				move_down (row_number ());
/*				repeat_source_id = g_timeout_add (10 * JOY_TIMEOUT,
								  (GSourceFunc) joy_right_repetition, NULL);*/
			} else if (joydata->axis[button] < (AXIS_MIN / 2)) {
				GXMAME_DEBUG ("Joystick axis %i pushed left", button);
				move_up (row_number ());
/*				repeat_source_id = g_timeout_add (10 * JOY_TIMEOUT,
								  (GSourceFunc) joy_left_repetition, NULL);*/
			}
		} else {
			/* UP and DOWN directions */
			if (joydata->axis[button] > (AXIS_MAX / 2)) {
				GXMAME_DEBUG ("Joystick axis %i pushed down", button);
				move_down (1);
// 				repeat_source_id = g_timeout_add (10 * JOY_TIMEOUT,
// 								  (GSourceFunc) joy_down_repetition, NULL);

			} else if (joydata->axis[button] < (AXIS_MIN / 2)) {
				GXMAME_DEBUG ("Joystick axis %i pushed up", button);
				move_up (1);
/*				repeat_source_id = g_timeout_add (10 * JOY_TIMEOUT,
								  (GSourceFunc) joy_up_repetition, NULL);*/
			}
		}
	}
}

#endif /* ENABLE_JOYSTICK */

static void move_up (int val)
{
	int i;

	QListViewItem *item = mainView->GameListView() ->currentItem();
	
	if (!item) return;
	
	for (i = 0; i < val; i++) {
		if(item->itemAbove())
			item = item->itemAbove();
	}
	mainView->GameListView()->setSelected(item,TRUE);
	mainView->GameListView()->ensureItemVisible(item);
}

static void move_down (int val)
{
	int i;

	QListViewItem *item = mainView->GameListView() ->currentItem();
	
	if (!item) return;
	
	for (i = 0; i < val; i++) {
		if(item->itemBelow())
			item = item->itemBelow();
	}
	mainView->GameListView()->setSelected(item,TRUE);
	mainView->GameListView()->ensureItemVisible(item);
}

static void toggle_expand (void)
{
	QListViewItem *item = mainView->GameListView() ->currentItem();
	
	if(item->childCount()) {
		item->setOpen(!item->isOpen());
	}
}

static gint row_number (void)
{
	return mainView->GameListView()->childrenRect().height()/
			mainView->GameListView() ->currentItem()->height()-2;
}


#include "kxmame_joy.moc"
