/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DIRSELECTIONDIALOG_H
#define DIRSELECTIONDIALOG_H

#include "DirTab.h"


class dirSelectionDialog: public dirSelectionTab {
	Q_OBJECT
    public:
	dirSelectionDialog(QWidget *parent = 0, const char *name = 0);
	
	void create_folderselection (QLineEdit *current_entry,
			bool select_dir);
    public slots:
	    void on_execBrowse() { create_folderselection (execEdit, FALSE); }
	    void on_catverBrowse() { create_folderselection (catverEdit, TRUE); }
	    void on_flyerBrowse() { create_folderselection (flyerEdit, TRUE); }
	    void on_cabinetBrowse() { create_folderselection (cabinetEdit, TRUE); }
	    void on_marqueeBrowse() { create_folderselection (marqueeEdit, TRUE); }
	    void on_snapBrowse() { create_folderselection (snapEdit, TRUE); }
	    void on_iconBrowse() { create_folderselection (iconEdit, TRUE); }
	    void on_romBrowse() { create_folderselection (romEdit, TRUE); }
	    void on_sampleBrowse() { create_folderselection (sampleEdit, TRUE); }
	    void on_artBrowse() { create_folderselection (artEdit, TRUE); }
	    void on_snapShotBrowse() { create_folderselection (snapShotEdit, TRUE); }
	    void on_videoBrowse() { create_folderselection (videoEdit, TRUE); }
	    void on_historyBrowse() { create_folderselection (historyEdit, FALSE); }
	    void on_mameInfoBrowse() { create_folderselection (mameInfoEdit, FALSE); }
	    void on_cheatBrowse() { create_folderselection (cheatEdit, FALSE); }
	    void on_highscoreBrowse() { create_folderselection (highscoreEdit, FALSE); }
	    void on_controllerBrowse() { create_folderselection (controllerEdit, TRUE); }
//	    void on_highscorePathBrowse() { create_folderselection (highscorePathEdit, TRUE); }
//	    void on_recordBrowse() { create_folderselection (recordEdit, TRUE); }
//	    void on_gameConfigBrowse() { create_folderselection (gameConfigEdit, TRUE); }
//	    void on_nvramBrowse() { create_folderselection (nvramEdit, TRUE); }
//	    void on_memoryBrowse() { create_folderselection (memoryEdit, TRUE); }
//	    void on_gameStatusBrowse() { create_folderselection (gameStatusEdit, TRUE); }
//	    void on_iniBrowse() { create_folderselection (iniEdit, TRUE); }
//	    void on_diffBrowse() { create_folderselection (diffEdit, TRUE); }
	    void on_sysinfoBrowse() { create_folderselection (messSysinfoPathEdit, FALSE); }
	    void on_messBiosBrowse() { create_folderselection (messBiosPathEdit, TRUE); }
	    void on_messSnapBrowse() { create_folderselection (messSnapPathEdit, TRUE); }

	    void addSample();
	    void addRom();
	    void addExec();
	    void removeSample();
	    void removeRom();
	    void removeExec();
};

#endif
