/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <klocale.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <qlabel.h>
#include <qdialog.h>
#include <kpushbutton.h>
#include <kprogress.h>
#include <kapplication.h>

#include "common.h"
#include "gxmame.h"
#include "progression_window.h"
#include "kxmessagebox.h"

extern "C" {
#include <math.h>
#include <stdarg.h>
}

#include "progress.h"

static progressDialog *mDialog = NULL;
static bool cancel_pressed = FALSE;

gboolean confirmMessage(const char * str)
{
	if (KMessageBox::warningYesNo(0,i18n(str)) == KMessageBox::Yes )
		return TRUE;
	else
		return FALSE;
}

void
gxmame_message (int type,
		void     *,
		const QString &str)
{
	switch (type) {
		case (ERROR):
			KMessageBox::error(0,str);
			break;
		case (MESSAGE):
			KMessageBox::information(0,str);
			break;
		case (WARNING):
			KxmameMessageBox::warning(0,str);
			break;
	}

}



/******************** Reimplement progression_window.c ************************/
/*
gboolean progress_window_cancelled (ProgressWindow *window)
{
	return cancel_pressed;
}

void cancel_progress_window ()
{
	cancel_pressed = TRUE;
}
*/
// static void progress_response (QWidget *dialog,
// 	gint response_id, gpointer user_data)
// {
// 	switch (response_id) {
// 		case GTK_RESPONSE_CANCEL:
// 			cancel_progress_window ((ProgressWindow *)user_data);
// 		default:
// 			gtk_widget_hide (dialog);
// 			break;
// 	}
// }

ProgressWindow *progress_window_new ()
{

	if (mDialog)
		delete mDialog;
	
	mDialog = new progressDialog(0);
	mDialog->progressBar->setTotalSteps(100);
	mDialog->cancelButton->setEnabled(FALSE);
	
	cancel_pressed = FALSE;
	
	return (ProgressWindow *)mDialog;
}

void progress_window_show ()
{
	if(!mDialog) return;
	mDialog->show();
	kapp->processEvents();
}

void progress_window_destroy (void)
{
	delete mDialog;
	mDialog = NULL;
}

void progress_window_set_title (const gchar    *format, ...)
{
	if(!mDialog) return;
	
	va_list args;
	gchar *buffer;
	gchar *markup;

	va_start (args, format);
	buffer = g_strdup_vprintf (format, args);
	va_end (args);
	mDialog->setCaption(QString(buffer));
	
	markup = g_strdup_printf ("<b>%s</b>", buffer);
	mDialog->label->setText(QString(markup));

	g_free (markup);
	g_free (buffer);

	kapp -> processEvents();
	mDialog->adjustSize();
}

void progress_window_set_text (const gchar    *text)
{
	if(!mDialog) return;
	mDialog->romLabel->setText(QString(text));
	kapp -> processEvents();
}

void progress_window_set_value (gfloat current_value)
{
	if(!mDialog) return;
	mDialog->progressBar->setProgress( int(round(current_value * 100.0)) );
	//mDialog->adjustSize();
	kapp -> processEvents();
}

