/*
    KSocrat
    Version 3.2.1, 17 July 2004
    (C) 2000-2004 Zavolzhsky Alexandr <zavolzhsky@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <kapp.h>
#include <klocale.h>
#include <qtooltip.h>
#include <kstddirs.h>
#include <qpixmap.h>
#include <qframe.h>
#include <qlayout.h>
#include "ksocrat.h"

void  KSocrat::initDialog(){
  KStandardDirs *dataDir = new KStandardDirs();
  QString sClearImg = dataDir->findResource("data","ksocrat/clear.png");

  QFrame *page = new QFrame(this);
  setCentralWidget(page);
  QVBoxLayout *bxDialog = new QVBoxLayout(page, 11, 6);
  QHBoxLayout *bxGroupTrans = new QHBoxLayout(0, 0, 6);
  bxDialog->addLayout(bxGroupTrans);

  bgTranslate = new QButtonGroup(1, QGroupBox::Horizontal, "bgTranslate", page);
  bgTranslate->setTitle(i18n("Translate"));
  bxGroupTrans->addWidget(bgTranslate); 

  rbEnglish= new QRadioButton(bgTranslate,"rbEnglish");
  rbEnglish->setText(i18n("From &English"));
  rbEnglish->setChecked(true);

  rbRussian= new QRadioButton(bgTranslate,"rbRussian");
  rbRussian->setText(i18n("From &Russian"));
  
  QGridLayout *gdTrans = new QGridLayout(0, 1, 1, 0, 6);
  bxGroupTrans->addLayout(gdTrans);

  edWord = new KComboBox(true,page,"edWord");
  edWord->setMaxCount(20);
  edWord->setInsertionPolicy(QComboBox::AtTop);
  edWord->setAutoCompletion(true);
  edWord->setDuplicatesEnabled(false);
  QToolTip::add(edWord,i18n("Enter word to translate here"));
  edWord->setFocus();
  gdTrans->addMultiCellWidget(edWord, 0, 0, 0, 1);

  btClear= new QPushButton(page,"btClear");
  btClear->setPixmap(QPixmap(sClearImg));
  QToolTip::add(btClear,i18n("Clear text and results (Alt + C)"));
  gdTrans->addWidget(btClear, 1, 0);

  btTrClip= new QPushButton(page,"btTrClip");
  btTrClip->setText(i18n("Cl&ipboard"));
  QToolTip::add(btTrClip,i18n("Translate clipboard text"));
  gdTrans->addWidget(btTrClip, 1, 0);

  btTranslate= new QPushButton(page,"btTranslate");
  btTranslate->setDefault(true);
  btTranslate->setText(i18n("&Translate"));
  gdTrans->addWidget(btTranslate, 1, 1);
  gdTrans->setColStretch(1, 1);

  QHBoxLayout *bxCheckButtons = new QHBoxLayout(0, 0, 6);
  bxDialog->addLayout(bxCheckButtons);

  cbAutoLanguage = new QCheckBox(page,"cbAutoLanguage");
  cbAutoLanguage->setChecked(true);
  cbAutoLanguage->setText(i18n("Auto-detect language"));
  bxCheckButtons->addWidget(cbAutoLanguage); 
  
  cbKeepTrans = new QCheckBox(page,"cbKeepTrans");
  cbKeepTrans->setText(i18n("Append translation"));
  bxCheckButtons->addWidget(cbKeepTrans); 

  cbSentTrans =  new QCheckBox(page,"cbSentTrans");
  cbSentTrans->setChecked(false);
  cbSentTrans->setText(i18n("Try to translate phrase as the sentence"));
  bxDialog->addWidget(cbSentTrans);
    
  meResult= new QTextEdit(page,"meResult");
  meResult->setTextFormat(Qt::PlainText);
  bxDialog->addWidget(meResult);

  QHBoxLayout *bxBottomButtons = new QHBoxLayout(0, 0, 6);
  bxDialog->addLayout(bxBottomButtons);

  btSave= new QPushButton(page,"btSave");
  btSave->setText(i18n("&Save"));
  bxBottomButtons->addWidget(btSave);

  btConfigure= new QPushButton(page,"btConfigure");
  btConfigure->setText(i18n("Setu&p"));
  bxBottomButtons->addWidget(btConfigure);

  btAbout= new QPushButton(page,"btAbout");
  btAbout->setText(i18n("&About"));
  bxBottomButtons->addWidget(btAbout);

  btHide= new QPushButton(page,"btHide");
  btHide->setText(i18n("&Hide"));
  bxBottomButtons->addWidget(btHide);
  
  btExit= new QPushButton(page,"btExit");
  btExit->setText(i18n("E&xit"));
  bxBottomButtons->addWidget(btExit);
}
