/***************************************************************************
                          configuration.cpp  -  description
                             -------------------
    begin                : Thu Mar 28 2002
    copyright            : (C) 2002 by Sebastian Schildt
    email                : sebastian@frozenlight.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "configuration.h"

configuration::configuration(){
}
configuration::~configuration(){
}

void configuration::readConfig() {
 	KSimpleConfig conf("ksetisaverrc",true);
	sahdirs.clear();
	conf.setGroup("General");
	setipath       = conf.readEntry("setipath","/opt/seti/");
	datapath			 = conf.readEntry("datapath","/opt/seti/");
	startclient    = conf.readBoolEntry("StartClient",false);
	manualtransfer = conf.readBoolEntry("ManualTransfer",false);
	playaudio      = conf.readBoolEntry("PlayAudio",false);
	parsekswconfig = conf.readBoolEntry("ParseKsetiwatchConfig",false);
	if (!parsekswconfig) {
  	    sahdirs << datapath;
	}
	else {
     sahdirs = kswI.readKswConfig();
	}

	conf.setGroup("Fontsettings");
	overrideSmall = conf.readBoolEntry("Override_small",false);
	overrideBig = conf.readBoolEntry("Override_big",false);
	overrideHead = conf.readBoolEntry("Override_head",false);
	bigF         = conf.readFontEntry("Font_big",new QFont("Helvetica", 18));
	smallF         = conf.readFontEntry("Font_small",new QFont("Helvetica", 14));
  headF         = conf.readFontEntry("Font_head",new QFont("Helvetica", 32, QFont::Bold));

	conf.setGroup("Misc");
	manualPositioning = conf.readBoolEntry("ManualPositioning",false);
	manX =conf.readNumEntry("Pos_X",0);
	manY =conf.readNumEntry("Pos_Y",0);	
}

void configuration::saveConfig() {
 	  KSimpleConfig conf("ksetisaverrc");
		conf.setGroup("General");
		conf.writeEntry("setipath",setipath);
		conf.writeEntry("datapath",datapath);
		conf.writeEntry("StartClient",startclient);
		conf.writeEntry("ManualTransfer",manualtransfer);
		conf.writeEntry("PlayAudio",playaudio);
    conf.writeEntry("ParseKsetiwatchConfig",parsekswconfig);

		conf.setGroup("Fontsettings");
		conf.writeEntry("Override_small",overrideSmall);
		conf.writeEntry("Override_big"  ,overrideBig);
		conf.writeEntry("Override_head" ,overrideHead);
		conf.writeEntry("Font_head" ,headF);
		conf.writeEntry("Font_big"  ,bigF);
		conf.writeEntry("Font_small",smallF);

		conf.setGroup("Misc");
		conf.writeEntry("ManualPositioning",manualPositioning);
		conf.writeEntry("Pos_X",manX);
		conf.writeEntry("Pos_Y",manY);
		conf.sync();
}

/* Getter methods */
bool configuration::isParsekswconfig() const {
 	return parsekswconfig;
}

bool configuration::isPlayaudio() const {
 	return playaudio;
}

bool configuration::isStartclient() const {
   return startclient;
}

bool configuration::isManualTransfer() const {
 	return manualtransfer;
}

bool configuration::isOverrideSmall() const {
 	return overrideSmall;
}

bool configuration::isOverrideBig() const {
 	return overrideBig;
}

bool configuration::isOverrideHead() const {
 	return overrideHead;
}

QFont configuration::getSmallF() const {
	return smallF;
}

QFont configuration::getBigF() const {
	return bigF;
}

QFont configuration::getHeadF() const {
	return headF;
}

QString configuration::getSetipath() const {
	return setipath;
}

QString configuration::getDatapath() const {
	return datapath;
}

QStringList configuration::getSahdirs() const {
 	return sahdirs;
}

int configuration::getManX() const {
 	return manX;
}

int configuration::getManY() const {
 	return manY;
}

bool configuration::isManualPositioning() const {
	return manualPositioning;
}


/* Setter methods */
void configuration::setParsekswconfig(bool val) {
 parsekswconfig=val;
}

void configuration::setPlayaudio(bool val) {
 	playaudio=val;
}

void configuration::setStartclient(bool val) {
 	startclient=val;
}

void configuration::setManualTransfer(bool val) {
 	manualtransfer=val;
}

void configuration::setOverrideSmall(bool val) {
 	overrideSmall=val;
}

void configuration::setOverrideBig(bool val) {
 	overrideBig=val;
}

void configuration::setOverrideHead(bool val) {
 	overrideHead=val;
}

void configuration::setSmallF(QFont tf) {
	smallF=tf;
}

void configuration::setBigF(QFont tf) {
	bigF=tf;
}

void configuration::setHeadF(QFont tf) {
	headF=tf;
}

void configuration::setSetipath(QString nsp) {
 	setipath=nsp;
}

void configuration::setDatapath(QString dsp) {
 	datapath=dsp;
}

void configuration::setManualCoors(int x, int y) {
 	manX=x;
	manY=y;
}

void configuration::setManualPositioning(bool val) {
 	manualPositioning=val;
}
