#ifndef WIN_H
#define WIN_H

#include <qmainwindow.h>

#include "translator.h"
#include "registry.h"
#include "history.h"


//========================================================================
// $Id: win.h,v 1.7 2001/03/11 05:21:32 radnev Exp $
//========================================================================


class QFont;
class QLineEdit;
class QPushButton;
class QLabel;
class QListBox;
class QTextEdit;
class QClipboard;
class QCheckBox;
class QSpinBox;
class QComboBox;


class Win:public QMainWindow {

Q_OBJECT

public:
	Win(QWidget *parent = 0, const char *name = 0);
	~Win();
	static char *getLocalePath();
	bool getDataOk();

protected:
	void resizeEvent(QResizeEvent *resizeEvent);
	void setView(int style);
	void addWordToHistory(const char *word);

protected slots:
	void word_TextChanged(const QString &newText);
	void word_EnterPressed();
	void list_Highlighted(const QString &newText);
	void list_Selected(const QString &newText);
	void menu_Copy();
	void menu_Paste();
	void menu_Clear();
	void menu_SelectAll();
	void menu_Font();
	void menu_Options();
	void menu_AdvancedSearch();
	void menu_Test();
	void menu_Help();
	void menu_About();
	void button_Prev();
	void button_Next();
	void button_Search();

private:
	QFont font;
	QLineEdit *word;
	QPushButton *bsearch;
	QPushButton *bprev;
	QPushButton *bnext;
	QLabel *found;
	QLabel *pic;
	QListBox *list;
	QTextEdit *result;
	QClipboard *systemClipboard;

	bool dataOk;

	Registry *reg;

	Translator *dictionary;

	History *history;

	int inputFieldWidth;
	int leftPaneWidth;
	int wordsInList;
	int borderWidth;
	int systemStyle;
	int wordsInHistory;

	bool translateOnEveryKey;

	bool fromSystemHighlighted;
	bool fromListHighlighted;
	bool fromHistoryBuffer;
	bool fromListSelected;
	bool fromClipboard;
	bool fromSystem;
	bool fromTextChanged;
	bool fromAdvancedSearch;

	bool advSrchIgnoreKey;
	bool advSrchIgnoreHistory;
	bool advSrchEnterSearch;
	bool advSrchDoNotReplacePhrase;

}; // End of class Win

#endif
