/**
 * @file   calcmix.c
 * 
 * <EN>
 * @brief  A sample plugin for calculating Gaussians
 *
 * This sample uses Julius libraries.
 * </EN>
 * 
 * <JA>
 * @brief  ʬ۷׻ץ饰Υץ
 *
 * Υץ julius Υ饤֥Ѥޤ
 * </JA>
 * 
 * @author Akinobu Lee
 * @date   Mon Aug 11 15:29:45 2008
 * 
 * $Revision: 1.1 $
 * 
 */
/**
 * Required for a file
 *   - get_plugin_info()
 *
 * Optional for a file
 *   - initialize()
 * 
 */
/**
 * Gaussian mixture calculation plugin:
 * 
 * Required:
 *   - calcmix_get_optname()
 *   - calcmix()
 *   - calcmix_init()
 *   - calcmix_free()
 * 
 */

/***************************************************************************/

/* we refer to Julius libsent header */
#include <sent/stddefs.h>
#include <sent/hmm_calc.h>

//#include "plugin_defs.h"

#define PLUGIN_TITLE "Gaussian calculation plugin for Julius"
#define GPRUNE_OPT "mycalc"

/** 
 * <EN>
 * @brief  Initialization at loading time (optional)
 * 
 * If defined, this will be called just before this plugin is loaded to Julius.
 * if this returns -1, the whole functions in this file will not be loaded.
 *
 * This function is OPTIONAL.
 * </EN>
 * <JA>
 * @brief  ɤ߹߻νǤա
 *
 * ưJulius Υץ饰ɤ߹ݤ˺ǽ˸ƤФ롥
 * -1 ֤ȡΥץ饰Τɤ߹ޤʤʤ롥
 * ¹ԲǽΥå˻Ȥ롥
 *
 * </JA>
 * 
 * 
 * @return 0 on success, -1 on failure.
 * 
 */
int
initialize()
{
  return 0;
}

/** 
 * <EN>
 * @brief  Get information of this plugin (required)
 *
 * This function should return informations of this plugin file.
 * The required info will be specified by opcode:
 *  - 0: return description string of this file into buf
 *
 * This will be called just after Julius find this file and after
 * initialize().
 *
 * @param opcode [in] requested operation code
 * @param buf [out] buffer to store the return string
 * @param buflen [in] maximum length of buf
 *
 * @return 0 on success, -1 on failure.  On failure, Julius will ignore this
 * plugin.
 * 
 * </EN>
 * <JA>
 * @brief  ץ饰ɬܡ
 *
 * Υץ饰˴ؤ֤Ϳ줿 opcode ˤäư롥
 *  - 0 ξ硤Υץ饰ե̾ΤͿ줿Хåե˳Ǽ
 *
 * δؿϡJulius Υץ饰ɤ߹ľ˸ƤФ롥
 * 
 * @param opcode [in] ׵ư ( 0 Τ߼)
 * @param buf [out] ͤǼХåե
 * @param buflen [in] buf κĹ
 * 
 * @return 顼 -1,  0 ֤顼Ȥ -1 ֤硤
 * Υץ饰Τɤ߹ޤʤ
 * </JA>
 * 
 */
int
get_plugin_info(int opcode, char *buf, int buflen)
{
  switch(opcode) {
  case 0:
    /* plugin description string */
    strncpy(buf, PLUGIN_TITLE, buflen);
    break;
  }

  return 0;
}

/************************************************************************/
/************************************************************************/

/** 
 * <EN>
 * @brief  Return option string to select at option. (required)
 *
 * This function should return option string which should be specified
 * as an argument "-gprune" option, to be used on Julius.  The returning
 * string should not be the same with any existing value.
 *
 * This function will be called several times at option parsing at startup.
 *
 * @param buf [out] buffer to store the return string
 * @param buflen [in] maximum length of buf
 * </EN>
 * <JA>
 * @brief  ׻ˡѥץΤʸ֤ɬܡ
 *
 * Julius ǵư "-gprune ֤" ȻꤹȤΥץ饰
 * Ѥ롥δؿǤϡ嵭 "-gprune" Ϳ٤ʸ
 * Ǽ֤֤ʸϡƥ "-gprune" ץˤǤˤ
 * Τ䡤¾Υץ饰󤬻ѤƤΤƱǤʤȡʤ⤷Ʊ
 * ä祷ƥ¦ͥ褵
 *
 * δؿϡưΥץϻ˲٤ƤФ롥
 *
 * @param buf [out] ͤǼ֤Хåե
 * @param buflen [in] buf κĹ
 * </JA>
 * 
 */
void
calcmix_get_optname(char *buf, int buflen)
{
  strncpy(buf, GPRUNE_OPT, buflen);
}

/**
 * <EN>
 * @brief  A basic implementaion of computing Gaussians
 *
 * This function should compute output probabilities for each
 * Gaussians.  after this function returns, Julius will do addlog to
 * get the final output log probability.
 *
 * The input vector to be computed is located at wrk->OP_vec[], at a
 * length of wrk->OP_veclen.  Gaussians are given by g[], at a number
 * of num.  last_id and lnum is for internal use for pruning, just ignore
 * them.
 *
 * The scores for each Gaussians computed in this function should be
 * stored in OP_calced_score[], with their corresponding Gaussian ids
 * to OP_calced_id.  The total number of calculated mixtures shuold
 * also stored in OP_calced_num.
 * 
 * @param wrk [i/o] HMM computation work area to store data
 * @param g [in] set of Gaussian densities to compute the output probability.
 * @param num [in] length of above
 * @param last_id [in] ID list of N-best mixture in previous input frame,
 * or NULL if not exist
 * @param lnum [in] length of last_id
 * </EN>
 * <JA>
 * @brief  ʬ۷׻ؿ
 *
 * δؿǤϡͿ줿ʣΥʬۤФϥ٥ȥ
 * ϳΨ롥δؿԤΤϡʣΥʬۤ줾
 * ϳΨλФȳǼΤߤǤꡤʬۤȤƤνŤ߷׻ addlog
 * Ϥδؿ֤äȤ Julius ¦ǹԤ롥
 *
 * ϥ٥ȥ wrk->OP_vec[] ˳ǼƤꡤĹ wrk->OP_veclen
 * Ǥ롥ʬ g[] ȤʣϤ졤ο num Ǥ롥
 * 
 * ʤlast_id  lnum ϤΥʬ۽ g[] ˤľϥ
 * 졼Ƿ׻줿Τ id äƤ롥Julius ѤʤΤǡ
 * ȤʤƤ⺹٤ʤ
 *
 * ƥʬۤФϥ٥ȥпϳΨϡΥʬۤ
 * ID (0 Ϥޤź)  wrk->OP_calced_id ˡͤ
 * wrk->OP_calced_score ˳Ǽ뤳ȡޤºݤ˷׻줿
 * ʬۤο wrk->OP_calced_num ˳Ǽ뤳ȡ
 * ʤ Gaussian pruning ꤷǤ
 *
 * ʲϡpruning ԤʤñʽϳΨ׻ΤǤ롥
 * ʬۤгѶʬꤷƤ롥ʤ Julius Ǥɤ߹߻
 * HTK ǤȤ gconst ͤϤ餫׻롥Τᡤ׻
 *  dens->gconst Τ褦ѤǤ롥
 * 
 * @param wrk [i/o] HMM׻ѥꥢ
 * @param g [in] ϳΨ׻륬ʬۤ
 * @param num [in] @a g Υʬۤο
 * @param last_id [in] ľϥե졼Ǿ̤äʬۤIDꥹȡ
 * ޤ NULL
 * @param lnum [in] @a last_id Ĺ
 * </JA>
 */
void
calcmix(HMMWork *wrk, HTK_HMM_Dens **g, int num, int *last_id, int lnum)
{
  int i;
  HTK_HMM_Dens *dens;
  LOGPROB *prob = wrk->OP_calced_score;
  int *id = wrk->OP_calced_id;
  VECT tmp, x;
  VECT *mean;
  VECT *var;
  VECT *vec;
  short veclen;

  for(i=0; i<num; i++) {
    /* store ID */
    *(id++) = i;
    /* get Gaussian to compute */
    dens = *(g++);
    if (dens == NULL) {
      /* no Gaussian, set LOG_ZERO as result */
      *(prob++) = LOG_ZERO;
      continue;
    }
    /* compute log outprob probability */
    mean = dens->mean;
    var = dens->var->vec;
    tmp = dens->gconst;
    vec = wrk->OP_vec;
    veclen = wrk->OP_veclen;
    for (; veclen > 0; veclen--) {
      x = *(vec++) - *(mean++);
      tmp += x * x * *(var++);
    }
    tmp *= -0.5;
    /* store it */
    *(prob++) = tmp;
  }
  wrk->OP_calced_num = num;
}

/**
 * <EN>
 * Free work area.
 * You should free all allocated at clacmix_init().
 * 
 * @param wrk [i/o] HMM computation work area
 * </EN>
 * <JA>
 * calcmix_init() ǳݤ줿ꥢ롥
 * 
 * @param wrk [i/o] HMM ׻ѥꥢ
 * </JA>
 * 
 */
void
calcmix_free(HMMWork *wrk)
{
  free(wrk->OP_calced_score);
  free(wrk->OP_calced_id);
}
  
/**
 * <EN>
 * @brief  Initialize and setup work area for Gaussian computation.
 *
 * You should set value for OP_calced_maxnum, and allocate OP_calced_score
 * and OP_calced_id.  Remaining the content below is safe.
 *
 * This will be called once on instance initialization at startup.
 * 
 * @param wrk [i/o] HMM computation work area
 * 
 * @return TRUE on success, FALSE on failure.
 * </EN>
 * <JA>
 * @brief  ׻ѤΥꥢݤ롥
 *
 * ʬ۷׻ѤΥꥢݤ롥ˤǤ˽񤤤Ƥʬϡ
 * Τޤ Julius ǤѤƤΤǡʤȡ
 *
 * δؿϺǽ˲ٷ׻󥹥󥹤Ȥ˸ƤӽФ롥
 * 
 * @param wrk [i/o] HMM ׻ѥꥢ
 * 
 * @return  TRUEԻ FALSE ֤
 * </JA>
 */
boolean
calcmix_init(HMMWork *wrk)
{
  /* maximum Gaussian set size = maximum mixture size * nstream */
  wrk->OP_calced_maxnum = wrk->OP_hmminfo->maxmixturenum * wrk->OP_nstream;
  wrk->OP_calced_score = (LOGPROB *)malloc(sizeof(LOGPROB) * wrk->OP_calced_maxnum);
  wrk->OP_calced_id = (int *)malloc(sizeof(int) * wrk->OP_calced_maxnum);
  /* force gprune_num to the max number */
  wrk->OP_gprune_num = wrk->OP_calced_maxnum;
  return TRUE;
}

/* end of file */
