/*
 * Decompiled with CFR 0.152.
 */
package de.mud.bsx;

import de.mud.bsx.BSXObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;

public class BSXScene
extends BSXObject {
    protected final Vector[] layers = new Vector[8];
    protected final Vector[] positions = new Vector[8];

    public boolean containsObject(String id) {
        return -1 != this.layerOfObject(id);
    }

    public void addObject(String id, int x, int y) {
        int layer = this.layerOfObject(id);
        if (-1 != layer) {
            this.removeObject(id, layer);
        }
        this.layers[y].addElement(id);
        this.positions[y].addElement(new Point(x, y));
    }

    public int layerOfObject(String id) {
        int layer = 0;
        while (layer < this.layers.length) {
            if (this.layers[layer].contains(id)) {
                return layer;
            }
            ++layer;
        }
        return -1;
    }

    public void removeObject(String id, int layer) {
        int idx = this.layers[layer].indexOf(id);
        this.layers[layer].removeElementAt(idx);
        this.positions[layer].removeElementAt(idx);
    }

    public void removeObject(String id) {
        int layer = this.layerOfObject(id);
        if (-1 != layer) {
            this.removeObject(id, layer);
        }
    }

    public Point locateObject(String id) {
        int layer = this.layerOfObject(id);
        if (layer != -1) {
            return (Point)this.positions[layer].elementAt(this.layers[layer].indexOf(id));
        }
        return null;
    }

    public void clean() {
        int layer = 0;
        while (layer <= 7) {
            this.layers[layer].removeAllElements();
            this.positions[layer].removeAllElements();
            ++layer;
        }
    }

    public BSXScene(String id, int[][] data) {
        super(id, data);
        int layer = 0;
        while (layer < this.layers.length) {
            this.layers[layer] = new Vector();
            this.positions[layer] = new Vector();
            ++layer;
        }
    }

    public Enumeration objects(int layer) {
        return this.layers[layer].elements();
    }

    public void fill(Graphics g) {
        int polys = 0;
        while (polys < this.data.length) {
            Color col = BSXObject.bsxColors[this.data[polys][0]];
            g.setColor(col);
            int points = 0;
            while (points < this.poly[2 * polys].length) {
                int px = this.data[polys][2 * points + 1] * 2;
                int py = this.data[polys][2 * points + 2];
                this.poly[2 * polys + 0][points] = px;
                this.poly[2 * polys + 1][points] = 256 - py;
                ++points;
            }
            g.fillPolygon(this.poly[2 * polys], this.poly[2 * polys + 1], this.poly[2 * polys].length);
            ++polys;
        }
    }
}

