/*
 * Decompiled with CFR 0.152.
 */
package de.mud.bsx;

import java.awt.Color;
import java.awt.Graphics;

public class BSXObject {
    protected int[][] data;
    protected int[][] poly;
    final String id;
    public static final Color[] bsxColors = new Color[]{new Color(0, 0, 0), new Color(0, 0, 255), new Color(34, 139, 34), new Color(135, 206, 235), new Color(205, 92, 92), new Color(255, 105, 180), new Color(165, 42, 42), new Color(211, 211, 211), new Color(105, 105, 105), new Color(0, 191, 255), new Color(0, 255, 0), new Color(0, 255, 255), new Color(255, 99, 71), new Color(255, 0, 255), new Color(255, 255, 0), new Color(255, 255, 255)};

    public BSXObject(String id, int[][] data) {
        this.id = id;
        this.setData(data);
    }

    public void draw(Graphics g, int x, int y) {
        int polys = 0;
        while (polys < this.data.length) {
            Color col = bsxColors[this.data[polys][0]];
            g.setColor(col);
            int points = 0;
            while (points < this.poly[2 * polys].length) {
                int px = this.data[polys][2 * points + 1];
                int py = this.data[polys][2 * points + 2];
                px -= 127;
                py -= 127;
                this.poly[2 * polys + 0][points] = (px += x * 16) * 2;
                this.poly[2 * polys + 1][points] = 255 - (py += 4 * y);
                ++points;
            }
            g.fillPolygon(this.poly[2 * polys], this.poly[2 * polys + 1], this.poly[2 * polys].length);
            ++polys;
        }
    }

    public void setData(int[][] data) {
        this.data = data;
        this.poly = new int[data.length * 2][];
        int num = 0;
        while (num < data.length) {
            this.poly[2 * num + 0] = new int[(data[num].length - 1) / 2];
            this.poly[2 * num + 1] = new int[(data[num].length - 1) / 2];
            ++num;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof BSXObject && ((BSXObject)obj).id.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void flush() {
    }
}

