/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures;

import org.gjt.jclasslib.structures.CPInfo;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.constants.ConstantClassInfo;
import org.gjt.jclasslib.structures.constants.ConstantFieldrefInfo;
import org.gjt.jclasslib.structures.constants.ConstantMethodrefInfo;
import org.gjt.jclasslib.structures.constants.ConstantNameAndTypeInfo;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;

public class ConstantPoolUtil {
    private ConstantPoolUtil() {
    }

    public static int addConstantMethodrefInfo(ClassFile classFile, String string, String string2, String string3, int n) {
        n = Math.max(n, 6);
        int n2 = ConstantPoolUtil.addConstantClassInfo(classFile, string, n);
        int n3 = ConstantPoolUtil.addConstantNameAndTypeInfo(classFile, string2, string3, n);
        ConstantMethodrefInfo constantMethodrefInfo = new ConstantMethodrefInfo();
        constantMethodrefInfo.setClassFile(classFile);
        constantMethodrefInfo.setClassIndex(n2);
        constantMethodrefInfo.setNameAndTypeIndex(n3);
        return ConstantPoolUtil.addConstantPoolEntry(classFile, constantMethodrefInfo, n);
    }

    public static int addConstantFieldrefInfo(ClassFile classFile, String string, String string2, String string3, int n) {
        n = Math.max(n, 6);
        int n2 = ConstantPoolUtil.addConstantClassInfo(classFile, string, n);
        int n3 = ConstantPoolUtil.addConstantNameAndTypeInfo(classFile, string2, string3, n);
        ConstantFieldrefInfo constantFieldrefInfo = new ConstantFieldrefInfo();
        constantFieldrefInfo.setClassFile(classFile);
        constantFieldrefInfo.setClassIndex(n2);
        constantFieldrefInfo.setNameAndTypeIndex(n3);
        return ConstantPoolUtil.addConstantPoolEntry(classFile, constantFieldrefInfo, n);
    }

    public static int addConstantNameAndTypeInfo(ClassFile classFile, String string, String string2, int n) {
        n = Math.max(n, 3);
        int n2 = ConstantPoolUtil.addConstantUTF8Info(classFile, string, n);
        int n3 = ConstantPoolUtil.addConstantUTF8Info(classFile, string2, n);
        ConstantNameAndTypeInfo constantNameAndTypeInfo = new ConstantNameAndTypeInfo();
        constantNameAndTypeInfo.setClassFile(classFile);
        constantNameAndTypeInfo.setNameIndex(n2);
        constantNameAndTypeInfo.setDescriptorIndex(n3);
        return ConstantPoolUtil.addConstantPoolEntry(classFile, constantNameAndTypeInfo, n);
    }

    public static int addConstantClassInfo(ClassFile classFile, String string, int n) {
        n = Math.max(n, 2);
        int n2 = ConstantPoolUtil.addConstantUTF8Info(classFile, string, n);
        ConstantClassInfo constantClassInfo = new ConstantClassInfo();
        constantClassInfo.setClassFile(classFile);
        constantClassInfo.setNameIndex(n2);
        return ConstantPoolUtil.addConstantPoolEntry(classFile, constantClassInfo, n);
    }

    public static int addConstantUTF8Info(ClassFile classFile, String string, int n) {
        ConstantUtf8Info constantUtf8Info = new ConstantUtf8Info();
        constantUtf8Info.setClassFile(classFile);
        constantUtf8Info.setString(string);
        return ConstantPoolUtil.addConstantPoolEntry(classFile, constantUtf8Info, n);
    }

    public static int addConstantPoolEntry(ClassFile classFile, CPInfo cPInfo, int n) {
        CPInfo[] cPInfoArray = classFile.getConstantPool();
        int n2 = classFile.getConstantPoolIndex(cPInfo);
        if (n2 > -1) {
            return n2;
        }
        int n3 = cPInfoArray.length - 1;
        while (n3 >= 0 && cPInfoArray[n3] == null) {
            --n3;
        }
        if (n3 == cPInfoArray.length - 1) {
            CPInfo[] cPInfoArray2 = new CPInfo[cPInfoArray.length + Math.max(1, n)];
            System.arraycopy(cPInfoArray, 0, cPInfoArray2, 0, cPInfoArray.length);
            classFile.enlargeConstantPool(cPInfoArray2);
            cPInfoArray = cPInfoArray2;
        }
        int n4 = n3 + 1;
        cPInfoArray[n4] = cPInfo;
        classFile.registerConstantPoolEntry(n4);
        return n4;
    }
}

