/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.gjt.jclasslib.browser.BrowserAboutDialog;
import org.gjt.jclasslib.browser.BrowserDesktopManager;
import org.gjt.jclasslib.browser.BrowserInternalFrame;
import org.gjt.jclasslib.browser.RecentMenu;
import org.gjt.jclasslib.browser.config.BrowserConfig;
import org.gjt.jclasslib.browser.config.classpath.ClasspathArchiveEntry;
import org.gjt.jclasslib.browser.config.classpath.ClasspathBrowser;
import org.gjt.jclasslib.browser.config.classpath.ClasspathSetupDialog;
import org.gjt.jclasslib.browser.config.classpath.FindResult;
import org.gjt.jclasslib.browser.config.window.WindowState;
import org.gjt.jclasslib.mdi.BasicDesktopManager;
import org.gjt.jclasslib.mdi.BasicFileFilter;
import org.gjt.jclasslib.mdi.BasicMDIFrame;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.util.GUIHelper;

public class BrowserMDIFrame
extends BasicMDIFrame {
    static final ImageIcon ICON_APPLICATION = BrowserMDIFrame.loadIcon("jclasslib.gif");
    private static final String SETTINGS_WORKSPACE_CHOOSER_PATH = "workspaceChooserPath";
    private static final String SETTINGS_CLASSES_CHOOSER_PATH = "classesChooserPath";
    private static final ImageIcon ICON_OPEN_CLASS_FILE = BrowserMDIFrame.loadIcon("open_small.png");
    private static final ImageIcon ICON_OPEN_CLASS_FILE_LARGE = BrowserMDIFrame.loadIcon("open_large.png");
    private static final ImageIcon ICON_OPEN_WORKSPACE = BrowserMDIFrame.loadIcon("open_ws_small.png");
    private static final ImageIcon ICON_OPEN_WORKSPACE_LARGE = BrowserMDIFrame.loadIcon("open_ws_large.png");
    private static final ImageIcon ICON_SAVE_WORKSPACE = BrowserMDIFrame.loadIcon("save_ws_small.png");
    private static final ImageIcon ICON_SAVE_WORKSPACE_LARGE = BrowserMDIFrame.loadIcon("save_ws_large.png");
    private static final ImageIcon ICON_BACKWARD = BrowserMDIFrame.loadIcon("browser_backward_small.png");
    private static final ImageIcon ICON_BACKWARD_LARGE = BrowserMDIFrame.loadIcon("browser_backward_large.png");
    private static final ImageIcon ICON_FORWARD = BrowserMDIFrame.loadIcon("browser_forward_small.png");
    private static final ImageIcon ICON_FORWARD_LARGE = BrowserMDIFrame.loadIcon("browser_forward_large.png");
    private static final ImageIcon ICON_RELOAD = BrowserMDIFrame.loadIcon("reload_small.png");
    private static final ImageIcon ICON_RELOAD_LARGE = BrowserMDIFrame.loadIcon("reload_large.png");
    private static final ImageIcon ICON_WEB = BrowserMDIFrame.loadIcon("web_small.png");
    private static final ImageIcon ICON_WEB_LARGE = BrowserMDIFrame.loadIcon("web_large.png");
    private static final ImageIcon ICON_BROWSE_CLASSPATH = BrowserMDIFrame.loadIcon("tree_small.png");
    private static final ImageIcon ICON_BROWSE_CLASSPATH_LARGE = BrowserMDIFrame.loadIcon("tree_large.png");
    private static final ImageIcon ICON_HELP = BrowserMDIFrame.loadIcon("help.png");
    private Action actionOpenClassFile;
    private Action actionBrowseClasspath;
    private Action actionSetupClasspath;
    private Action actionNewWorkspace;
    private Action actionOpenWorkspace;
    private Action actionSaveWorkspace;
    private Action actionSaveWorkspaceAs;
    private Action actionQuit;
    private Action actionShowHomepage;
    private Action actionShowEJT;
    private Action actionBackward;
    private Action actionForward;
    private Action actionReload;
    private Action actionShowHelp;
    private Action actionAbout;
    private File workspaceFile;
    private String workspaceChooserPath = "";
    private String classesChooserPath = "";
    private BrowserConfig config;
    private JFileChooser workspaceFileChooser;
    private JFileChooser classesFileChooser;
    private RecentMenu recentMenu;
    private ClasspathSetupDialog classpathSetupDialog;
    private ClasspathBrowser classpathBrowser;
    private ClasspathBrowser jarBrowser;
    static /* synthetic */ Class class$org$gjt$jclasslib$browser$BrowserMDIFrame;

    public static ImageIcon loadIcon(String string) {
        URL uRL = (class$org$gjt$jclasslib$browser$BrowserMDIFrame == null ? (class$org$gjt$jclasslib$browser$BrowserMDIFrame = BrowserMDIFrame.class$("org.gjt.jclasslib.browser.BrowserMDIFrame")) : class$org$gjt$jclasslib$browser$BrowserMDIFrame).getResource("images/" + string);
        return new ImageIcon(uRL);
    }

    public BrowserMDIFrame() {
        this.doNewWorkspace();
        this.recentMenu = new RecentMenu(this);
        this.loadSettings();
        this.setupActions();
        this.setupMenu();
        this.setupFrame();
    }

    public BrowserConfig getConfig() {
        return this.config;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.desktopManager.showAll();
        }
    }

    public Action getActionSetupClasspath() {
        return this.actionSetupClasspath;
    }

    public Action getActionBackward() {
        return this.actionBackward;
    }

    public Action getActionForward() {
        return this.actionForward;
    }

    public Action getActionReload() {
        return this.actionReload;
    }

    public String getClassesChooserPath() {
        return this.classesChooserPath;
    }

    public void setClassesChooserPath(String string) {
        this.classesChooserPath = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void openWorkspace(File file) {
        block5: {
            this.repaintNow();
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.closeAllFrames();
            try {
                block4: {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        XMLDecoder xMLDecoder = new XMLDecoder(fileInputStream);
                        this.config = (BrowserConfig)xMLDecoder.readObject();
                        this.readMDIConfig(this.config.getMDIConfig());
                        xMLDecoder.close();
                        this.recentMenu.addRecentWorkspace(file);
                        if (this.classpathBrowser == null) break block4;
                        this.classpathBrowser.setClasspathComponent(this.config);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        GUIHelper.showMessage(this, "An error occured while reading " + file.getPath(), 0);
                        Object var5_6 = null;
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        break block5;
                    }
                }
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.setCursor(Cursor.getPredefinedCursor(0));
                throw throwable;
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.workspaceFile = file;
        this.updateTitle();
        this.actionSaveWorkspaceAs.setEnabled(true);
    }

    public BrowserInternalFrame openClassFromFile(File file) {
        BrowserInternalFrame browserInternalFrame;
        block5: {
            browserInternalFrame = new BrowserInternalFrame(this.desktopManager, new WindowState(file.getPath()));
            ClassFile classFile = browserInternalFrame.getClassFile();
            if (classFile == null) break block5;
            try {
                String string = classFile.getThisClassName();
                String[] stringArray = string.split("/");
                File file2 = file.getParentFile();
                boolean bl = true;
                int n = stringArray.length - 2;
                while (n >= 0) {
                    String string2 = stringArray[n];
                    if (!file2.getName().equals(string2)) {
                        bl = false;
                        break;
                    }
                    file2 = file2.getParentFile();
                    --n;
                }
                if (bl) {
                    this.config.addClasspathDirectory(file2.getPath());
                }
            }
            catch (InvalidByteCodeException invalidByteCodeException) {}
        }
        return browserInternalFrame;
    }

    protected void doQuit() {
        this.saveSettings();
        super.doQuit();
    }

    protected BasicDesktopManager createDesktopManager() {
        return new BrowserDesktopManager(this);
    }

    protected Class[] getFrameConstructorArguments(Class clazz) {
        return BrowserInternalFrame.CONSTRUCTOR_ARGUMENTS;
    }

    private void setupActions() {
        this.actionOpenClassFile = new DefaultAction("Open class file", ICON_OPEN_CLASS_FILE);
        this.actionOpenClassFile.putValue("ShortDescription", "Open a class file");
        this.actionBrowseClasspath = new DefaultAction("Browse classpath", ICON_BROWSE_CLASSPATH);
        this.actionBrowseClasspath.putValue("ShortDescription", "Browse the current classpath to open a class file");
        this.actionSetupClasspath = new DefaultAction("Setup classpath", GUIHelper.ICON_EMPTY);
        this.actionSetupClasspath.putValue("ShortDescription", "Configure the classpath");
        this.actionNewWorkspace = new DefaultAction("New workspace", GUIHelper.ICON_EMPTY);
        this.actionNewWorkspace.putValue("ShortDescription", "Close all frames and open a new workspace");
        this.actionOpenWorkspace = new DefaultAction("Open workspace", ICON_OPEN_WORKSPACE);
        this.actionOpenWorkspace.putValue("ShortDescription", "Open workspace from disk");
        this.actionSaveWorkspace = new DefaultAction("Save workspace", ICON_SAVE_WORKSPACE);
        this.actionSaveWorkspace.putValue("ShortDescription", "Save current workspace to disk");
        this.actionSaveWorkspaceAs = new DefaultAction("Save workspace as", GUIHelper.ICON_EMPTY);
        this.actionSaveWorkspaceAs.putValue("ShortDescription", "Save current workspace to a different file");
        this.actionSaveWorkspaceAs.setEnabled(false);
        this.actionQuit = new DefaultAction("Quit", GUIHelper.ICON_EMPTY);
        this.actionBackward = new DefaultAction("Backward", ICON_BACKWARD);
        this.actionBackward.putValue("ShortDescription", "Move backward in the navigation history");
        this.actionBackward.setEnabled(false);
        this.actionForward = new DefaultAction("Forward", ICON_FORWARD);
        this.actionForward.putValue("ShortDescription", "Move forward in the navigation history");
        this.actionForward.setEnabled(false);
        this.actionReload = new DefaultAction("Reload", ICON_RELOAD);
        this.actionReload.putValue("ShortDescription", "Reload class file");
        this.actionReload.setEnabled(false);
        this.actionShowHomepage = new DefaultAction("jclasslib on the web", ICON_WEB);
        this.actionShowHomepage.putValue("ShortDescription", "Visit jclasslib on the web");
        this.actionShowEJT = new DefaultAction("ej-technologies on the web", ICON_WEB);
        this.actionShowEJT.putValue("ShortDescription", "Visit ej-technologies on the web");
        this.actionShowHelp = new DefaultAction("Show help", ICON_HELP);
        this.actionShowHelp.putValue("ShortDescription", "Show the jclasslib documentation");
        this.actionAbout = new DefaultAction("About the jclasslib bytecode viewer", GUIHelper.ICON_EMPTY);
        this.actionAbout.putValue("ShortDescription", "Show the jclasslib documentation");
    }

    private void setupMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.add(this.actionOpenClassFile);
        jMenu.addSeparator();
        jMenu.add(this.actionNewWorkspace);
        jMenu.add(this.actionOpenWorkspace);
        jMenu.add(this.recentMenu);
        jMenu.addSeparator();
        jMenu.add(this.actionSaveWorkspace);
        jMenu.add(this.actionSaveWorkspaceAs);
        jMenu.addSeparator();
        jMenu.add(this.actionShowHomepage);
        jMenu.add(this.actionShowEJT);
        jMenu.addSeparator();
        jMenu.add(this.actionQuit);
        JMenu jMenu2 = new JMenu("Classpath");
        jMenu2.add(this.actionBrowseClasspath);
        jMenu2.add(this.actionSetupClasspath);
        JMenu jMenu3 = new JMenu("Browse");
        JMenuItem jMenuItem = jMenu3.add(this.actionBackward);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(37, 8));
        jMenuItem = jMenu3.add(this.actionForward);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(39, 8));
        jMenu3.addSeparator();
        jMenuItem = jMenu3.add(this.actionReload);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        JMenu jMenu4 = new JMenu("Help");
        jMenuItem = jMenu4.add(this.actionShowHelp);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        jMenu4.add(this.actionAbout);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(this.menuWindow);
        jMenuBar.add(jMenu4);
        this.setJMenuBar(jMenuBar);
    }

    private void setupFrame() {
        Container container = this.getContentPane();
        container.add((Component)this.buildToolbar(), "North");
        this.setIconImage(ICON_APPLICATION.getImage());
    }

    private void updateTitle() {
        if (this.workspaceFile == null) {
            this.setTitle("Bytecode viewer");
            if (this.actionSaveWorkspaceAs != null) {
                this.actionSaveWorkspaceAs.setEnabled(false);
            }
        } else {
            this.setTitle("Bytecode viewer [" + this.workspaceFile.getName() + "]");
        }
    }

    private JToolBar buildToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.actionOpenClassFile).setIcon(ICON_OPEN_CLASS_FILE_LARGE);
        jToolBar.add(this.actionBrowseClasspath).setIcon(ICON_BROWSE_CLASSPATH_LARGE);
        jToolBar.addSeparator();
        jToolBar.add(this.actionOpenWorkspace).setIcon(ICON_OPEN_WORKSPACE_LARGE);
        jToolBar.add(this.actionSaveWorkspace).setIcon(ICON_SAVE_WORKSPACE_LARGE);
        jToolBar.addSeparator();
        jToolBar.add(this.actionBackward).setIcon(ICON_BACKWARD_LARGE);
        jToolBar.add(this.actionForward).setIcon(ICON_FORWARD_LARGE);
        jToolBar.addSeparator();
        jToolBar.add(this.actionReload).setIcon(ICON_RELOAD_LARGE);
        jToolBar.addSeparator();
        jToolBar.add(this.actionShowHomepage).setIcon(ICON_WEB_LARGE);
        jToolBar.setFloatable(false);
        return jToolBar;
    }

    private void repaintNow() {
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.paintImmediately(0, 0, jComponent.getWidth(), jComponent.getHeight());
        JMenuBar jMenuBar = this.getJMenuBar();
        jMenuBar.paintImmediately(0, 0, jMenuBar.getWidth(), jMenuBar.getHeight());
    }

    private void loadSettings() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        this.workspaceChooserPath = preferences.get(SETTINGS_WORKSPACE_CHOOSER_PATH, this.workspaceChooserPath);
        this.classesChooserPath = preferences.get(SETTINGS_CLASSES_CHOOSER_PATH, this.classesChooserPath);
        this.recentMenu.read(preferences);
    }

    private void saveSettings() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        preferences.put(SETTINGS_WORKSPACE_CHOOSER_PATH, this.workspaceChooserPath);
        preferences.put(SETTINGS_CLASSES_CHOOSER_PATH, this.classesChooserPath);
        this.recentMenu.save(preferences);
    }

    private void doSaveWorkspace(boolean bl) {
        this.config.setMDIConfig(this.createMDIConfig());
        if (this.workspaceFile != null && !bl) {
            this.saveWorkspaceToFile(this.workspaceFile);
            return;
        }
        JFileChooser jFileChooser = this.getWorkspaceFileChooser();
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".jcw")) {
                file = new File(file.getPath() + "." + "jcw");
            }
            if (file.exists() && GUIHelper.showOptionDialog(this, "The file " + file.getPath() + "\nexists. Do you want to overwrite this file?", GUIHelper.YES_NO_OPTIONS, 3) != 0) {
                return;
            }
            this.saveWorkspaceToFile(file);
            this.workspaceFile = file;
            this.updateTitle();
            this.workspaceChooserPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
        }
    }

    private void saveWorkspaceToFile(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            XMLEncoder xMLEncoder = new XMLEncoder(fileOutputStream);
            xMLEncoder.writeObject(this.config);
            xMLEncoder.close();
            this.recentMenu.addRecentWorkspace(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            GUIHelper.showMessage(this, "An error occured while saving to " + file.getPath(), 0);
        }
        GUIHelper.showMessage(this, "Workspace saved to " + file.getPath(), 1);
        this.actionSaveWorkspaceAs.setEnabled(true);
    }

    private void doNewWorkspace() {
        this.closeAllFrames();
        this.workspaceFile = null;
        this.config = new BrowserConfig();
        this.config.addRuntimeLib();
        if (this.classpathBrowser != null) {
            this.classpathBrowser.setClasspathComponent(this.config);
        }
        this.updateTitle();
    }

    private void doOpenWorkspace() {
        JFileChooser jFileChooser = this.getWorkspaceFileChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.openWorkspace(file);
            this.workspaceChooserPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
        }
    }

    private void doOpenClassFile() {
        JFileChooser jFileChooser = this.getClassesFileChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.repaintNow();
            this.setCursor(Cursor.getPredefinedCursor(3));
            File file = jFileChooser.getSelectedFile();
            this.classesChooserPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
            BrowserInternalFrame browserInternalFrame = file.getPath().toLowerCase().endsWith(".class") ? this.openClassFromFile(file) : this.openClassFromJar(file);
            if (browserInternalFrame != null) {
                try {
                    browserInternalFrame.setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private BrowserInternalFrame openClassFromJar(File file) {
        ClasspathArchiveEntry classpathArchiveEntry = new ClasspathArchiveEntry();
        classpathArchiveEntry.setFileName(file.getPath());
        if (this.jarBrowser == null) {
            this.jarBrowser = new ClasspathBrowser(this, null, "Classes in selected JAR file:", false);
        }
        this.jarBrowser.clear();
        this.jarBrowser.setClasspathComponent(classpathArchiveEntry);
        this.jarBrowser.setVisible(true);
        String string = this.jarBrowser.getSelectedClassName();
        if (string == null) {
            return null;
        }
        String string2 = file.getPath() + "!" + string + ".class";
        BrowserInternalFrame browserInternalFrame = new BrowserInternalFrame(this.desktopManager, new WindowState(string2));
        ClassFile classFile = browserInternalFrame.getClassFile();
        if (classFile != null) {
            this.config.addClasspathArchive(file.getPath());
        }
        return browserInternalFrame;
    }

    private void doBrowseClasspath() {
        if (this.classpathBrowser == null) {
            this.classpathBrowser = new ClasspathBrowser(this, this.config, "Configured classpath:", true);
        }
        this.classpathBrowser.setVisible(true);
        String string = this.classpathBrowser.getSelectedClassName();
        if (string == null) {
            return;
        }
        FindResult findResult = this.config.findClass(string);
        if (findResult == null) {
            GUIHelper.showMessage(this, "Error loading " + string, 0);
            return;
        }
        this.repaintNow();
        this.setCursor(Cursor.getPredefinedCursor(3));
        BrowserInternalFrame browserInternalFrame = new BrowserInternalFrame(this.desktopManager, new WindowState(findResult.getFileName()));
        try {
            browserInternalFrame.setMaximum(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void doSetupClasspath() {
        if (this.classpathSetupDialog == null) {
            this.classpathSetupDialog = new ClasspathSetupDialog(this);
        }
        this.classpathSetupDialog.setVisible(true);
    }

    private void doBackward() {
        BrowserInternalFrame browserInternalFrame = (BrowserInternalFrame)this.desktopPane.getSelectedFrame();
        if (browserInternalFrame != null) {
            browserInternalFrame.getBrowserComponent().getHistory().historyBackward();
        }
    }

    private void doForward() {
        BrowserInternalFrame browserInternalFrame = (BrowserInternalFrame)this.desktopPane.getSelectedFrame();
        if (browserInternalFrame != null) {
            browserInternalFrame.getBrowserComponent().getHistory().historyForward();
        }
    }

    private void doReload() {
        BrowserInternalFrame browserInternalFrame = (BrowserInternalFrame)this.desktopPane.getSelectedFrame();
        if (browserInternalFrame != null) {
            browserInternalFrame.reload();
        }
    }

    private JFileChooser getWorkspaceFileChooser() {
        if (this.workspaceFileChooser == null) {
            this.workspaceFileChooser = new JFileChooser(this.workspaceChooserPath);
            this.workspaceFileChooser.setDialogTitle("Choose workspace file");
            this.workspaceFileChooser.setFileFilter(new BasicFileFilter("jcw", "jclasslib workspace files"));
        }
        return this.workspaceFileChooser;
    }

    private JFileChooser getClassesFileChooser() {
        if (this.classesFileChooser == null) {
            this.classesFileChooser = new JFileChooser(this.classesChooserPath);
            this.classesFileChooser.setDialogTitle("Choose class file or jar file");
            this.classesFileChooser.addChoosableFileFilter(new BasicFileFilter("class", "class files"));
            this.classesFileChooser.addChoosableFileFilter(new BasicFileFilter("jar", "jar files"));
            this.classesFileChooser.setFileFilter(new BasicFileFilter(new String[]{"class", "jar"}, "class files and jar files"));
        }
        return this.classesFileChooser;
    }

    private void doShowURL(String string) {
        String string2 = System.getProperty("os.name").startsWith("Windows") ? "rundll32.exe url.dll,FileProtocolHandler " + string : "netscape " + string;
        try {
            Runtime.getRuntime().exec(string2);
        }
        catch (IOException iOException) {}
    }

    private void doAbout() {
        new BrowserAboutDialog(this).setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DefaultAction
    extends AbstractAction {
        private DefaultAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this == BrowserMDIFrame.this.actionOpenClassFile) {
                BrowserMDIFrame.this.doOpenClassFile();
            } else if (this == BrowserMDIFrame.this.actionBrowseClasspath) {
                BrowserMDIFrame.this.doBrowseClasspath();
            } else if (this == BrowserMDIFrame.this.actionSetupClasspath) {
                BrowserMDIFrame.this.doSetupClasspath();
            } else if (this == BrowserMDIFrame.this.actionNewWorkspace) {
                BrowserMDIFrame.this.doNewWorkspace();
            } else if (this == BrowserMDIFrame.this.actionOpenWorkspace) {
                BrowserMDIFrame.this.doOpenWorkspace();
            } else if (this == BrowserMDIFrame.this.actionSaveWorkspace) {
                BrowserMDIFrame.this.doSaveWorkspace(false);
            } else if (this == BrowserMDIFrame.this.actionSaveWorkspaceAs) {
                BrowserMDIFrame.this.doSaveWorkspace(true);
            } else if (this == BrowserMDIFrame.this.actionQuit) {
                BrowserMDIFrame.this.doQuit();
            } else if (this == BrowserMDIFrame.this.actionBackward) {
                BrowserMDIFrame.this.doBackward();
            } else if (this == BrowserMDIFrame.this.actionForward) {
                BrowserMDIFrame.this.doForward();
            } else if (this == BrowserMDIFrame.this.actionReload) {
                BrowserMDIFrame.this.doReload();
            } else if (this == BrowserMDIFrame.this.actionShowHomepage) {
                BrowserMDIFrame.this.doShowURL("http://www.ej-technologies.com/products/jclasslib/overview.html");
            } else if (this == BrowserMDIFrame.this.actionShowEJT) {
                BrowserMDIFrame.this.doShowURL("http://www.ej-technologies.com");
            } else if (this == BrowserMDIFrame.this.actionShowHelp) {
                BrowserMDIFrame.this.doShowURL("doc/help.html");
            } else if (this == BrowserMDIFrame.this.actionAbout) {
                BrowserMDIFrame.this.doAbout();
            }
        }
    }
}

