#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <jmp-config.h>
#include <jmp.h>
#include <method.h>
#include <jthread.h>
#include <cls.h>

/** dump a method to the given file */
void dump_method_row (method* m, FILE* f) {
    jlong jsec, jnsec, hsec, hnsec; 
    methodtime* mt;
    cls* c = method_get_owner (m);
    mt = method_get_time_used (m);
    jsec = mt->tv / 1000000000ll;
    jnsec = mt->tv % 1000000000000ll; // remove 3 extra zeroes...
    hsec = mt->tv_hold / 1000000000ll;
    hnsec = mt->tv_hold % 1000000000000ll; // remove 3 extra zeroes...
    fprintf (f, "%s\t%s\t%lld.%09lld\t%ld\t%lld.%09lld\t%d\t%lld\n", 
	     cls_get_name (c),
	     method_get_method_jmpname (m),
	     jsec,
	     jnsec,
	     method_get_calls (m),
	     hsec, 
	     hnsec,
	     method_get_allocated_objects (m),
	     method_get_allocated_memory (m));
}

void dump_jthread_row (jthread* t, FILE* f) {
    method* mp = NULL;
    timerstack* s;
    int i;

    fprintf (f, "%p\t%s\t%s\t%s\t\n",
	     t->env_id,
	     jthread_get_thread_name(t),
	     jthread_get_group_name(t),
	     jthread_get_parent_name(t));

    /* MW: Hack  */
    /* I dont see why this is neccessary /robo */
    if (strcmp (jthread_get_thread_name (t), "Shutdown-Thread") == 0) {
        return;
    }

    s = get_timerstack ((JNIEnv*)t->env_id);
    for (i = s->top - 1; i >= 0; i--) {
	methodtime* mt = s->times + i;
	mp = mt->method;
	if (mp != NULL) 
	    fprintf (f, "\t%s\t%s\n",
		     cls_get_name (mp->owner),
		     method_get_method_jmpname (mp));
	else 
	    fprintf (f, "\t?\t?\n" );	    	
    }
}

/** Dump a class to the given file. */
void dump_class_row (cls* c, FILE* f) {
    fprintf (f, "%s\t%ld\t%ld\t%ld\t%ld\n", 
	     cls_get_name (c),
	     cls_get_instances (c),
	     cls_get_max_instances (c),
	     cls_get_size (c),
	     cls_get_total_gc (c));    
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
