#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <jmp.h>
#include <jthread.h>
#include <cls.h>
#include <method.h>

/** Thread comparators */

/** Compare two jthreads by there name. */
int jthread_compr_name (const void* v1, const void* v2) {
    jthread **t1 = (jthread**) v1;
    jthread **t2 = (jthread**) v2;
    return strcmp (jthread_get_thread_name(*t1), jthread_get_thread_name(*t2));
}

/** compare threads based on thread group */
int jthread_compr_group (const void* v1, const void* v2) {
    jthread** t1 = (jthread**)v1;
    jthread** t2 = (jthread**)v2;
    return (strcmp (jthread_get_group_name (*t1), jthread_get_group_name (*t2)));
}

/** compare threads based on thread parent */
int jthread_compr_parent (const void* v1, const void* v2) {
    jthread** t1 = (jthread**)v1;
    jthread** t2 = (jthread**)v2;
    return (strcmp (jthread_get_parent_name (*t1), jthread_get_parent_name (*t2)));
}

/** Compare threads based on contenation time for the threads. */
int jthread_compr_contenation (const void* v1, const void* v2) {
    jlong l;
    jthread** t1 = (jthread**)v1;
    jthread** t2 = (jthread**)v2;
    l = (*t1)->timerstack->contendtime - (*t2)->timerstack->contendtime;
    if (l < 0)
	return 1;
    else if (l > 0)
	return -1;
    return 0;
}

/** Compare threads based on consumed cpu time. */
int jthread_compr_state (const void* v1, const void* v2) {
    jthread** t1 = (jthread**)v1;
    jthread** t2 = (jthread**)v2;
    return (*t1)->state - (*t2)->state;
}

/** Compare threads based on consumed cpu time. */
int jthread_compr_cputime (const void* v1, const void* v2) {
    jlong l;
    jthread** t1 = (jthread**)v1;
    jthread** t2 = (jthread**)v2;
    l = (*t1)->timerstack->cpu_time - (*t2)->timerstack->cpu_time;
    if (l < 0)
	return 1;
    else if (l > 0)
	return -1;
    return 0;
}


/** class comparators... */

/** compare classes based on class name */
int cls_compr_name (const void* v1, const void* v2) {
    cls** c1 = (cls**)v1;
    cls** c2 = (cls**)v2;
    return (strcmp (cls_get_name (*c1), cls_get_name (*c2)));
}

/** compare classes based on instance count */
int cls_compr_instance (const void* v1, const void* v2) {
    cls** c1 = (cls**)v1;
    cls** c2 = (cls**)v2;
    return (cls_get_instances (*c2) - cls_get_instances (*c1));
}

/** compare classes based on maximum instance count */
int cls_compr_max_instance (const void* v1, const void* v2) {
    cls** c1 = (cls**)v1;
    cls** c2 = (cls**)v2;
    return (cls_get_max_instances (*c2) - cls_get_max_instances (*c1));
}

/** compare classes based on current size in bytes */
int cls_compr_size (const void* v1, const void* v2) {
    cls** c1 = (cls**)v1;
    cls** c2 = (cls**)v2;
    return (cls_get_size (*c2) - cls_get_size (*c1));
}

/** compare classes based on number of garbage collected instances */
int cls_compr_instance_gc (const void* v1, const void* v2) {
    cls** c1 = (cls**)v1;
    cls** c2 = (cls**)v2;
    return (cls_get_total_gc (*c2) - cls_get_total_gc (*c1));
}


/** Method comparators. */

/** Compare methods based on signature. */
int method_compr_signature (const void* v1, const void* v2) {
    method** m1 = (method**)v1;
    method** m2 = (method**)v2;
    return (strcmp (method_get_method_signature (*m1), method_get_method_signature (*m2)));
}

/** Compare methods based on method name (and signature if needed) */
int method_compr_name (const void* v1, const void* v2) {
    method** m1 = (method**)v1;
    method** m2 = (method**)v2;
    int c = 0; 
    c = (strcmp (method_get_method_name (*m1), method_get_method_name (*m2)));
    if (c) 
	return c;
    return method_compr_signature (v1, v2);
}

/** Compare method based on class name, method name and signature (in that order) */
int method_compr_class (const void* v1, const void* v2) {
    cls* c1;
    cls* c2;
    int c;
    method** m1 = (method**)v1;
    method** m2 = (method**)v2;
    c1 = method_get_owner (*m1);
    c2 = method_get_owner (*m2);
    c = (strcmp (cls_get_class_name (c1), cls_get_class_name (c2)));    
    if (c)
	return c;
    return method_compr_name (v1, v2);
}

/** Compare methods based on used time in the method. */
int method_compr_time (const void* v1, const void* v2) {
    jlong l;
    method** m1 = (method**)v1;
    method** m2 = (method**)v2;
    l = (*m1)->time_used.tv - (*m2)->time_used.tv;
    /* l is a long long, dont want it to be auto casted to an int, 
     * so check and return by ourselfs..
     */
    if (l < 0)
	return 1;
    else if (l > 0)
	return -1;
    return 0;
}

/** Compare methods based on number of calls. */
int method_compr_calls (const void* v1, const void* v2) {
    method** m1 = (method**)v1;
    method** m2 = (method**)v2;
    return method_get_calls (*m2) - method_get_calls (*m1);
}

/** Compare methods based on time used in method called from this method. */
int method_compr_hold_time (const void* v1, const void* v2) {
    jlong l;
    method** m1 = (method**)v1;
    method** m2 = (method**)v2;
    
    l = (*m1)->time_used.tv_hold - (*m2)->time_used.tv_hold;
    if (l < 0) 
	return 1;
    else if (l > 0)
	return -1;
    return 0;
}

/** Compare methods based on time used in this method and method called from this method. */
int method_compr_total_time (const void* v1, const void* v2) {
    jlong diff, tot1, tot2;
    method** m1 = (method**)v1;
    method** m2 = (method**)v2;

    tot1 = (*m1)->time_used.tv + (*m1)->time_used.tv_hold;
    tot2 = (*m2)->time_used.tv + (*m2)->time_used.tv_hold;
    
    if ((diff = (tot1 - tot2)) < 0) 
	return 1;
    else if (diff > 0) 
	return -1;
    return 0;
}

/** Compare methods based on allocated objects */
int method_compr_objects (const void* v1, const void* v2) {
    method** m1 = (method**) v1;
    method** m2 = (method**) v2;
    return (*m2)->allocated_objects - (*m1)->allocated_objects;
}

/** Compare methods based on allocated memory */
int method_compr_bytes (const void* v1, const void* v2) {
    jlong diff;
    method** m1 = (method**) v1;
    method** m2 = (method**) v2;
    
    diff = (*m2)->allocated_memory - (*m1)->allocated_memory;

    if (diff<0) return -1;
    else if (diff==0) return 0;
    else return 1;
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
