// $Header: /home/cvs/jakarta-jmeter/src/core/org/apache/jmeter/util/LocaleChangeEvent.java,v 1.4 2004/02/13 02:21:37 sebb Exp $
/*
 * Copyright 2002-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
*/

package org.apache.jmeter.util;


import java.util.EventObject;
import java.util.Locale;


/**
 * @author Oliver Rossmueller <oliver@oross.net>
 * @version $Revision: 1.4 $
 */
public class LocaleChangeEvent extends EventObject
{

    private Locale locale;
    

    public LocaleChangeEvent(Object source)
    {
        super(source);
    }


    public LocaleChangeEvent(Object source, Locale locale)
    {
        super(source);
        this.locale = locale;
    }


    public Locale getLocale()
    {
        return locale;
    }
}
