// $Header: /home/cvs/jakarta-jmeter/src/components/org/apache/jmeter/timers/ConstantTimer.java,v 1.17 2004/02/13 03:46:14 sebb Exp $
/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
*/

package org.apache.jmeter.timers;

import java.io.Serializable;

import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.util.JMeterUtils;

/**
 * This class implements a constant timer with its own panel and fields for
 * value update and user interaction.
 *
 * @author <a href="mailto:stefano@apache.org">Stefano Mazzocchi</a>
 * @author <a href="mailto:seade@backstagetech.com.au">Scott Eade</a>
 * @version $Revision: 1.17 $ $Date: 2004/02/13 03:46:14 $
 */
public class ConstantTimer
    extends AbstractTestElement
    implements Timer, Serializable, LoopIterationListener
{

    public final static String DELAY = "ConstantTimer.delay";
    private long delay = 0;

    /**
     * No-arg constructor.
     */
    public ConstantTimer()
    {
    }

    /**
     * Set the delay for this timer.
     *  
     */
    public void setDelay(String delay)
    {
        setProperty(DELAY, delay);
    }

    /**
     * Set the range (not used for this timer).
     * 
     */
    public void setRange(double range)
    {
    }

    /**
     * Get the delay value for display.
     * 
     * @return the delay value for display.
     */
    public String getDelay()
    {
        return getPropertyAsString(DELAY);
    }

    /**
     * Retrieve the range (not used for this timer).
     * 
     * @return the range (always zero for this timer).
     */
    public double getRange()
    {
        return (double) 0;
    }

    /**
     * Retrieve the delay to use during test execution.
     * 
     * @return the delay.
     */
    public long delay()
    {
        return delay;
    }

    /**
     * Provide a description of this timer class.
     * 
     * @return the description of this timer class.
     */
    public String toString()
    {
        return JMeterUtils.getResString("constant_timer_memo");
    }

    /**
     * Gain access to any variables that have been defined.
     * 
     * @see LoopIterationListener#iterationStart(LoopIterationEvent)
     */
    public void iterationStart(LoopIterationEvent event)
    {
        delay = getPropertyAsLong(DELAY);
        
    }

    /* This method doesn't appear to be used anymore.
     * jeremy_a@bigfoot.com  02 May 2003
     * 
     * Make changes to variables available elsewhere.
     * 
     * @see ThreadListener#setJMeterVariables(JMeterVariables)
    public void setJMeterVariables(JMeterVariables jmVars)
    {
        //vars.addJMeterVariables(jmVars);
    }
     */

}
