// $Header: /home/cvs/jakarta-jmeter/src/components/org/apache/jmeter/timers/ConstantThroughputTimerBeanInfo.java,v 1.5 2004/03/11 01:21:03 sebb Exp $
/*
 * Copyright 2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
*/

package org.apache.jmeter.timers;

import java.beans.PropertyDescriptor;

import org.apache.jmeter.testbeans.BeanInfoSupport;

/**
 * BeanInfo for the ConstantThroughputTimer.
 *
 * @version $Revision: 1.5 $ updated on $Date: 2004/03/11 01:21:03 $
 */
public class ConstantThroughputTimerBeanInfo extends BeanInfoSupport
{
    public ConstantThroughputTimerBeanInfo()
    {
        super(ConstantThroughputTimer.class);
        
        createPropertyGroup("delay", new String[] { "throughput" });

        PropertyDescriptor p= property("throughput");
        p.setValue(NOT_UNDEFINED, Boolean.TRUE);
        p.setValue(DEFAULT, new Double(0.0));
    }
}