/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.UUIDInfoBox;
import java.io.IOException;
import java.io.RandomAccessFile;

public class UUIDListBox
extends JP2Box {
    public UUIDListBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof UUIDInfoBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        int n = this._module.readUnsignedShort(this._dstrm);
        if ((long)(16 * n + 2) != this._boxHeader.getDataLength()) {
            this.wrongBoxSize();
            return false;
        }
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ModuleBase.readByteBuf(this._dstrm, byArrayArray[i], this._module);
        }
        if (this._parentBox instanceof UUIDInfoBox) {
            ((UUIDInfoBox)this._parentBox).setUUIDList(byArrayArray);
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "UUID List Box";
    }
}

