package jfractionlab.worksheets;

import jfractionlab.FractionMaker;
import jfractionlab.JFractionLab;

public class ExerciseSubtraction{

	private int n1=0;
	private int d1=0;
	private int n2=0;
	private int d2=0;
	private int lcd=0;
	
	public ExerciseSubtraction(int max){
		mkExercise(max);
	}
	
	public ExerciseSubtraction mkExercise(int max){
		do{
			FractionMaker fraction = new FractionMaker(max);
			n1 = fraction.getNumerator_1();
			d1 = fraction.getDenominator_1();
			n2 = fraction.getNumerator_2();
			d2 = fraction.getDenominator_2();
		}while(!((float)n1/d1 > (float)n2/d2));
		lcd = JFractionLab.leastComonMultiple(d1, d2);
		return this;
	}

	public int getN1() {
		return n1;
	}

	public int getD1() {
		return d1;
	}

	public int getN2() {
		return n2;
	}

	public int getD2() {
		return d2;
	}

	public int getLCD() {
		return lcd;
	}

}
