/**
 *	JFractionLab
 *	Copyright (C) 2005 jochen georges, gnugeo _ at _ gnugeo _ dot _ de
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

package jfractionlab;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

import javax.swing.JOptionPane;

public class ConfManager{

	private String confpath;
	//"tabtipp" does not exists
	//it is just an example how to install new options
	private String[] ar_standardtext = {
				"This file is generated by JFractionLab",
				"DO NOT EDIT!",
				"tippatstart=true",
				"tabtipp=true"
	};

	/**
	 *
	 *
	 */
	public ConfManager(){
		//System.out.println("==ConfManager");
		if (System.getProperty("os.name").toLowerCase().contains("win")){
			//windows
			confpath = System.getProperty("user.home") + "/jfractionlab.conf";
			//try{
			//	Runtime.getRuntime().exec("cmd.exe attrib +h" + confpath);
			//}acatch(IOException e){}
		}else{
			confpath = System.getProperty("user.home") + "/.jfractionlab.conf";
		}
		if(!confFileExists()){
		 	writeConfFile(ar_standardtext);
		 }
	}//Konstruktor

	/**
	 * 
	 * @param ar_str
	 */
	private void writeConfFile(String[] ar_str){
		//System.out.println("==writeConfFile");
		try {
			BufferedWriter bw = new BufferedWriter(
				new OutputStreamWriter(
					new FileOutputStream(confpath),
					"UTF-8"
				)//OutputStreamWriter
			);//BufferedWriter
			for (int i = 0; i < ar_str.length; i++){
				bw.write(ar_str[i]);
				bw.newLine();
			}
			bw.close();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}//writeConfFile

	/**
	 * 
	 * @param bl
	 */
	public void writeTippValueToConf(String typ, boolean bl){
		//System.out.println("==setShowTippAtStart");
		if(typ.equals("tippatstart") || typ.equals("tabtipp")){
			int numbersOfLines=0;
			String ln;//line
	
			//1. ermitteln der anzahl der zeilen ########################
			try{
				LineNumberReader f = new LineNumberReader(
					new FileReader(confpath)
				);
				while ((ln = f.readLine()) != null) {
					numbersOfLines++;
					//numbersOfLines = f.getLineNumber();
				}
				f.close();
			}catch (UnsupportedEncodingException e){
				e.printStackTrace();
				//System.out.println("UnsupportedEncodingException");
			}catch (IOException e) {
				e.printStackTrace();
				//System.out.println("IOException, "+confpath);
			}
			//System.out.println("1.Schritt: numbersOfLines = "+numbersOfLines);
			
			//2. erzeugen eines arrays fuer die zeilen #########################
			String[] ar_conftext = new String[numbersOfLines];
			try{
				LineNumberReader f;
				f = new LineNumberReader(
					new FileReader(confpath)
				);
				int i = 0;
				f.setLineNumber(1);
				while ((ln = f.readLine()) != null) {
					ar_conftext[i] = ln.trim();
					i++;
				}
				f.close();
			}catch (UnsupportedEncodingException e){
				e.printStackTrace();
				//System.out.println("UnsupportedEncodingException");
			}catch (IOException e) {
				e.printStackTrace();
				//System.out.println("IOException, "+confpath);
			}
			//System.out.println("2.Schritt: ar_conftext =");
			for(int p = 0; p < ar_conftext.length; p++ ){
				System.out.println("   zeile"+p+" = "+ar_conftext[p]);
			}
			
			//3. ermitteln der "entsprechenden-arrayzelle ###########################
			int indexOfTipp = 0;
			for(int j = 0; j < ar_conftext.length; j++ ){
				if(ar_conftext[j].toLowerCase().contains(typ)){
					//das ist die Zeile
					indexOfTipp = j;
				}
			}//for
			//System.out.println("3.Schritt: indexOfShowTippAtStartCell ="+indexOfShowTippAtStartCell);
			
			//4. setzen der zeile ###################################################
			if(bl){
				ar_conftext[indexOfTipp] = typ+"=true";
				//System.out.println("4.Schritt: showtippatstart=true");
			}else{
				ar_conftext[indexOfTipp] = typ+"=false";
				//System.out.println("4.Schritt: showtippatstart=false");
			}
			
			//5. schreiben der zeile
			new File(confpath).delete();
			writeConfFile(ar_conftext);
			//System.out.println("5.Schritt: neue confdatei");
			//5.Menu in JFractionLab anpassen
			JFractionLab.setCheckBoxValue();
		}//if(str.equals)
		else{
			System.out.println("UEbergabeparameter muss tippatstart oder tabtipp sein!");
		}
	}//writeTippValueToConf

	/**
	 * 
	 * @return
	 */
	public boolean tippIsSet(String str){
		if(str.equals("tippatstart") || str.equals("tabtipp")){
			//System.out.println("==getShowTippAtStart");
			boolean showtipp = true;
			LineNumberReader f;
			String ln;//line
			String tl;//trimmedline
			try {
				f = new LineNumberReader(
					new FileReader(confpath)
				);
				while ((ln = f.readLine()) != null) {
					if(ln.indexOf("=") != -1){
						tl=ln.trim();
						if(tl.substring(0,tl.indexOf("=")).equals(str)){
							String st = tl.substring(tl.indexOf("=")+1,tl.length());
							st = st.toLowerCase();
							if(st.equals("true")){
								showtipp = true;
							}else if(st.equals("false")){
								showtipp = false;
							}else{
								JOptionPane.showMessageDialog(null,"set value of showtipp to true or false");
							}
						}
					}//if(ln.indexOf("=") != -1)
				}//while
				f.close();
				return showtipp;
			}catch (IOException e) {
				e.printStackTrace();
				JOptionPane.showMessageDialog(null,"Can not read jfractionlab.conf");
				return true;
			}
		}//if(str.equals)
		else{
			System.out.println("UEbergabeparameter muss tippatstart oder tabtipp sein!");
			return false;
		}
	}//getShowTippAtStart

	/**
	 * 
	 * @return
	 */
	private boolean confFileExists(){
		if(new File(confpath).exists()){
			return true;
		}else{
			return false;
		}
	}//existingConfFile()

	}//ConfManager