/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Javadoc
extends Task {
    private static boolean javadoc1 = JavaEnvUtils.isJavaVersion("1.1");
    private static boolean javadoc4;
    static final String[] SCOPE_ELEMENTS;
    private Commandline cmd;
    private boolean failOnError;
    private Path sourcePath;
    private File destDir;
    private Vector sourceFiles;
    private Vector packageNames;
    private Vector excludePackageNames;
    private boolean author;
    private boolean version;
    private DocletInfo doclet;
    private Path classpath;
    private Path bootclasspath;
    private String group;
    private String packageList;
    private Vector links;
    private Vector groups;
    private Vector tags;
    private boolean useDefaultExcludes;
    private Html doctitle;
    private Html header;
    private Html footer;
    private Html bottom;
    private boolean useExternalFile;
    private FileUtils fileUtils;
    private String source;
    private boolean linksource;
    private boolean breakiterator;
    private String noqualifier;
    private Vector fileSets;
    private Vector packageSets;

    private final void addArgIf(boolean bl, String string) {
        if (bl) {
            this.cmd.createArgument().setValue(string);
        }
    }

    private final void add12ArgIfNotEmpty(String string, String string2) {
        if (!javadoc1) {
            if (string2 != null && string2.length() != 0) {
                this.cmd.createArgument().setValue(string);
                this.cmd.createArgument().setValue(string2);
            } else {
                this.log("Warning: Leaving out empty argument '" + string + '\'', 1);
            }
        }
    }

    private final void add12ArgIf(boolean bl, String string) {
        if (!javadoc1 && bl) {
            this.cmd.createArgument().setValue(string);
        }
    }

    public void setUseExternalFile(boolean bl) {
        if (!javadoc1) {
            this.useExternalFile = bl;
        }
    }

    public void setDefaultexcludes(boolean bl) {
        this.useDefaultExcludes = bl;
    }

    public void setMaxmemory(String string) {
        if (javadoc1) {
            this.cmd.createArgument().setValue("-J-mx" + string);
        } else {
            this.cmd.createArgument().setValue("-J-Xmx" + string);
        }
    }

    public void setAdditionalparam(String string) {
        this.cmd.createArgument().setLine(string);
    }

    public Commandline.Argument createArg() {
        return this.cmd.createArgument();
    }

    public void setSourcepath(Path path) {
        if (this.sourcePath == null) {
            this.sourcePath = path;
        } else {
            this.sourcePath.append(path);
        }
    }

    public Path createSourcepath() {
        if (this.sourcePath == null) {
            this.sourcePath = new Path(this.getProject());
        }
        return this.sourcePath.createPath();
    }

    public void setSourcepathRef(Reference reference) {
        this.createSourcepath().setRefid(reference);
    }

    public void setDestdir(File file) {
        this.destDir = file;
        this.cmd.createArgument().setValue("-d");
        this.cmd.createArgument().setFile(this.destDir);
    }

    public void setSourcefiles(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            SourceFile sourceFile = new SourceFile();
            sourceFile.setFile(this.getProject().resolveFile(string2.trim()));
            this.addSource(sourceFile);
        }
    }

    public void addSource(SourceFile sourceFile) {
        this.sourceFiles.addElement(sourceFile);
    }

    public void setPackagenames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            PackageName packageName = new PackageName();
            packageName.setName(string2);
            this.addPackage(packageName);
        }
    }

    public void addPackage(PackageName packageName) {
        this.packageNames.addElement(packageName);
    }

    public void setExcludePackageNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            PackageName packageName = new PackageName();
            packageName.setName(string2);
            this.addExcludePackage(packageName);
        }
    }

    public void addExcludePackage(PackageName packageName) {
        this.excludePackageNames.addElement(packageName);
    }

    public void setOverview(File file) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-overview");
            this.cmd.createArgument().setFile(file);
        }
    }

    public void setPublic(boolean bl) {
        this.addArgIf(bl, "-public");
    }

    public void setProtected(boolean bl) {
        this.addArgIf(bl, "-protected");
    }

    public void setPackage(boolean bl) {
        this.addArgIf(bl, "-package");
    }

    public void setPrivate(boolean bl) {
        this.addArgIf(bl, "-private");
    }

    public void setAccess(AccessType accessType) {
        this.cmd.createArgument().setValue("-" + accessType.getValue());
    }

    public void setDoclet(String string) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
            this.doclet.setProject(this.getProject());
        }
        this.doclet.setName(string);
    }

    public void setDocletPath(Path path) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
            this.doclet.setProject(this.getProject());
        }
        this.doclet.setPath(path);
    }

    public void setDocletPathRef(Reference reference) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
            this.doclet.setProject(this.getProject());
        }
        this.doclet.createPath().setRefid(reference);
    }

    public DocletInfo createDoclet() {
        this.doclet = new DocletInfo();
        return this.doclet;
    }

    public void addTaglet(ExtensionInfo extensionInfo) {
        this.tags.addElement(extensionInfo);
    }

    public void setOld(boolean bl) {
        if (bl) {
            if (javadoc1) {
                this.log("Javadoc 1.1 doesn't support the -1.1 switch", 1);
            } else if (javadoc4) {
                this.log("Javadoc 1.4 doesn't support the -1.1 switch anymore", 1);
            } else {
                this.cmd.createArgument().setValue("-1.1");
            }
        }
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setBootclasspath(Path path) {
        if (this.bootclasspath == null) {
            this.bootclasspath = path;
        } else {
            this.bootclasspath.append(path);
        }
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.getProject());
        }
        return this.bootclasspath.createPath();
    }

    public void setBootClasspathRef(Reference reference) {
        this.createBootclasspath().setRefid(reference);
    }

    public void setExtdirs(String string) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-extdirs");
            this.cmd.createArgument().setValue(string);
        }
    }

    public void setExtdirs(Path path) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-extdirs");
            this.cmd.createArgument().setPath(path);
        }
    }

    public void setVerbose(boolean bl) {
        this.add12ArgIf(bl, "-verbose");
    }

    public void setLocale(String string) {
        if (!javadoc1) {
            this.cmd.createArgument(true).setValue(string);
            this.cmd.createArgument(true).setValue("-locale");
        }
    }

    public void setEncoding(String string) {
        this.cmd.createArgument().setValue("-encoding");
        this.cmd.createArgument().setValue(string);
    }

    public void setVersion(boolean bl) {
        this.version = bl;
    }

    public void setUse(boolean bl) {
        this.add12ArgIf(bl, "-use");
    }

    public void setAuthor(boolean bl) {
        this.author = bl;
    }

    public void setSplitindex(boolean bl) {
        this.add12ArgIf(bl, "-splitindex");
    }

    public void setWindowtitle(String string) {
        this.add12ArgIfNotEmpty("-windowtitle", string);
    }

    public void setDoctitle(String string) {
        Html html = new Html();
        html.addText(string);
        this.addDoctitle(html);
    }

    public void addDoctitle(Html html) {
        if (!javadoc1) {
            this.doctitle = html;
        }
    }

    public void setHeader(String string) {
        Html html = new Html();
        html.addText(string);
        this.addHeader(html);
    }

    public void addHeader(Html html) {
        if (!javadoc1) {
            this.header = html;
        }
    }

    public void setFooter(String string) {
        Html html = new Html();
        html.addText(string);
        this.addFooter(html);
    }

    public void addFooter(Html html) {
        if (!javadoc1) {
            this.footer = html;
        }
    }

    public void setBottom(String string) {
        Html html = new Html();
        html.addText(string);
        this.addBottom(html);
    }

    public void addBottom(Html html) {
        if (!javadoc1) {
            this.bottom = html;
        }
    }

    public void setLinkoffline(String string) {
        if (!javadoc1) {
            LinkArgument linkArgument = this.createLink();
            linkArgument.setOffline(true);
            String string2 = "The linkoffline attribute must include a URL and a package-list file location separated by a space";
            if (string.trim().length() == 0) {
                throw new BuildException(string2);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
            linkArgument.setHref(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) {
                throw new BuildException(string2);
            }
            linkArgument.setPackagelistLoc(this.getProject().resolveFile(stringTokenizer.nextToken()));
        }
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public void setLink(String string) {
        if (!javadoc1) {
            this.createLink().setHref(string);
        }
    }

    public void setNodeprecated(boolean bl) {
        this.addArgIf(bl, "-nodeprecated");
    }

    public void setNodeprecatedlist(boolean bl) {
        this.add12ArgIf(bl, "-nodeprecatedlist");
    }

    public void setNotree(boolean bl) {
        this.addArgIf(bl, "-notree");
    }

    public void setNoindex(boolean bl) {
        this.addArgIf(bl, "-noindex");
    }

    public void setNohelp(boolean bl) {
        this.add12ArgIf(bl, "-nohelp");
    }

    public void setNonavbar(boolean bl) {
        this.add12ArgIf(bl, "-nonavbar");
    }

    public void setSerialwarn(boolean bl) {
        this.add12ArgIf(bl, "-serialwarn");
    }

    public void setStylesheetfile(File file) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-stylesheetfile");
            this.cmd.createArgument().setFile(file);
        }
    }

    public void setHelpfile(File file) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-helpfile");
            this.cmd.createArgument().setFile(file);
        }
    }

    public void setDocencoding(String string) {
        this.cmd.createArgument().setValue("-docencoding");
        this.cmd.createArgument().setValue(string);
    }

    public void setPackageList(String string) {
        if (!javadoc1) {
            this.packageList = string;
        }
    }

    public LinkArgument createLink() {
        LinkArgument linkArgument = new LinkArgument();
        this.links.addElement(linkArgument);
        return linkArgument;
    }

    public TagArgument createTag() {
        if (!javadoc4) {
            this.log("-tag option not supported on JavaDoc < 1.4", 3);
        }
        TagArgument tagArgument = new TagArgument();
        this.tags.addElement(tagArgument);
        return tagArgument;
    }

    public GroupArgument createGroup() {
        GroupArgument groupArgument = new GroupArgument();
        this.groups.addElement(groupArgument);
        return groupArgument;
    }

    public void setCharset(String string) {
        this.add12ArgIfNotEmpty("-charset", string);
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void setSource(String string) {
        if (!javadoc4) {
            this.log("-source option not supported on JavaDoc < 1.4", 3);
        }
        this.source = string;
    }

    public void addPackageset(DirSet dirSet) {
        this.packageSets.addElement(dirSet);
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.addElement(fileSet);
    }

    public void setLinksource(boolean bl) {
        if (!javadoc4) {
            this.log("-linksource option not supported on JavaDoc < 1.4", 3);
        }
        this.linksource = bl;
    }

    public void setBreakiterator(boolean bl) {
        if (!javadoc4) {
            this.log("-breakiterator option not supported on JavaDoc < 1.4", 3);
        }
        this.breakiterator = bl;
    }

    public void setNoqualifier(String string) {
        if (!javadoc4) {
            this.log("-noqualifier option not supported on JavaDoc < 1.4", 3);
        }
        this.noqualifier = string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        Object object;
        Object object2;
        block78: {
            Object object3;
            Object object4;
            Commandline commandline;
            block77: {
                Object object5;
                if ("javadoc2".equals(this.getTaskType())) {
                    this.log("!! javadoc2 is deprecated. Use javadoc instead. !!");
                }
                Vector vector = new Vector();
                Path path = new Path(this.getProject());
                if (this.packageList != null && this.sourcePath == null) {
                    String string = "sourcePath attribute must be set when specifying packagelist.";
                    throw new BuildException(string);
                }
                if (this.sourcePath != null) {
                    path.addExisting(this.sourcePath);
                }
                this.parsePackages(vector, path);
                if (vector.size() != 0 && path.size() == 0) {
                    String string = "sourcePath attribute must be set when specifying package names.";
                    throw new BuildException(string);
                }
                Vector vector2 = (Vector)this.sourceFiles.clone();
                this.addFileSets(vector2);
                if (this.packageList == null && vector.size() == 0 && vector2.size() == 0) {
                    throw new BuildException("No source files and no packages have been specified.");
                }
                this.log("Generating Javadoc", 2);
                commandline = (Commandline)this.cmd.clone();
                commandline.setExecutable(JavaEnvUtils.getJdkExecutable("javadoc"));
                if (this.doctitle != null) {
                    commandline.createArgument().setValue("-doctitle");
                    commandline.createArgument().setValue(this.expand(this.doctitle.getText()));
                }
                if (this.header != null) {
                    commandline.createArgument().setValue("-header");
                    commandline.createArgument().setValue(this.expand(this.header.getText()));
                }
                if (this.footer != null) {
                    commandline.createArgument().setValue("-footer");
                    commandline.createArgument().setValue(this.expand(this.footer.getText()));
                }
                if (this.bottom != null) {
                    commandline.createArgument().setValue("-bottom");
                    commandline.createArgument().setValue(this.expand(this.bottom.getText()));
                }
                this.classpath = this.classpath == null ? new Path(this.getProject()).concatSystemClasspath("last") : this.classpath.concatSystemClasspath("ignore");
                if (!javadoc1) {
                    if (this.classpath.size() > 0) {
                        commandline.createArgument().setValue("-classpath");
                        commandline.createArgument().setPath(this.classpath);
                    }
                    if (path.size() > 0) {
                        commandline.createArgument().setValue("-sourcepath");
                        commandline.createArgument().setPath(path);
                    }
                } else {
                    path.append(this.classpath);
                    if (path.size() > 0) {
                        commandline.createArgument().setValue("-classpath");
                        commandline.createArgument().setPath(path);
                    }
                }
                if (this.version && this.doclet == null) {
                    commandline.createArgument().setValue("-version");
                }
                if (this.author && this.doclet == null) {
                    commandline.createArgument().setValue("-author");
                }
                if ((javadoc1 || this.doclet == null) && this.destDir == null) {
                    String string = "destDir attribute must be set!";
                    throw new BuildException(string);
                }
                if (!javadoc1) {
                    if (this.doclet != null) {
                        if (this.doclet.getName() == null) {
                            throw new BuildException("The doclet name must be specified.", this.getLocation());
                        }
                        commandline.createArgument().setValue("-doclet");
                        commandline.createArgument().setValue(this.doclet.getName());
                        if (this.doclet.getPath() != null && ((Path)(object4 = this.doclet.getPath().concatSystemClasspath("ignore"))).size() != 0) {
                            commandline.createArgument().setValue("-docletpath");
                            commandline.createArgument().setPath((Path)object4);
                        }
                        object4 = this.doclet.getParams();
                        while (object4.hasMoreElements()) {
                            object5 = (DocletParam)object4.nextElement();
                            if (((DocletParam)object5).getName() == null) {
                                throw new BuildException("Doclet parameters must have a name");
                            }
                            commandline.createArgument().setValue(((DocletParam)object5).getName());
                            if (((DocletParam)object5).getValue() == null) continue;
                            commandline.createArgument().setValue(((DocletParam)object5).getValue());
                        }
                    }
                    if (this.bootclasspath != null && this.bootclasspath.size() > 0) {
                        commandline.createArgument().setValue("-bootclasspath");
                        commandline.createArgument().setPath(this.bootclasspath);
                    }
                    if (this.links.size() != 0) {
                        object4 = this.links.elements();
                        while (object4.hasMoreElements()) {
                            Serializable serializable;
                            object5 = (LinkArgument)object4.nextElement();
                            if (((LinkArgument)object5).getHref() == null || ((LinkArgument)object5).getHref().length() == 0) {
                                this.log("No href was given for the link - skipping", 3);
                                continue;
                            }
                            try {
                                serializable = new URL("file://.");
                                new URL((URL)serializable, ((LinkArgument)object5).getHref());
                            }
                            catch (MalformedURLException malformedURLException) {
                                this.log("Link href \"" + ((LinkArgument)object5).getHref() + "\" is not a valid url - skipping link", 1);
                                continue;
                            }
                            if (((LinkArgument)object5).isLinkOffline()) {
                                serializable = ((LinkArgument)object5).getPackagelistLoc();
                                if (serializable == null) {
                                    throw new BuildException("The package list  location for link " + ((LinkArgument)object5).getHref() + " must be provided because the link is offline");
                                }
                                object3 = new File((File)serializable, "package-list");
                                if (((File)object3).exists()) {
                                    try {
                                        object2 = this.fileUtils.getFileURL((File)serializable).toExternalForm();
                                        commandline.createArgument().setValue("-linkoffline");
                                        commandline.createArgument().setValue(((LinkArgument)object5).getHref());
                                        commandline.createArgument().setValue((String)object2);
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        this.log("Warning: Package list location was invalid " + serializable, 1);
                                    }
                                    continue;
                                }
                                this.log("Warning: No package list was found at " + serializable, 3);
                                continue;
                            }
                            commandline.createArgument().setValue("-link");
                            commandline.createArgument().setValue(((LinkArgument)object5).getHref());
                        }
                    }
                    if (this.group != null) {
                        object4 = new StringTokenizer(this.group, ",", false);
                        while (((StringTokenizer)object4).hasMoreTokens()) {
                            object5 = ((StringTokenizer)object4).nextToken().trim();
                            int n = ((String)object5).indexOf(" ");
                            if (n <= 0) continue;
                            object3 = ((String)object5).substring(0, n);
                            object2 = ((String)object5).substring(n + 1);
                            commandline.createArgument().setValue("-group");
                            commandline.createArgument().setValue((String)object3);
                            commandline.createArgument().setValue((String)object2);
                        }
                    }
                    if (this.groups.size() != 0) {
                        object4 = this.groups.elements();
                        while (object4.hasMoreElements()) {
                            object5 = (GroupArgument)object4.nextElement();
                            String string = ((GroupArgument)object5).getTitle();
                            object3 = ((GroupArgument)object5).getPackages();
                            if (string == null) throw new BuildException("The title and packages must be specified for group elements.");
                            if (object3 == null) {
                                throw new BuildException("The title and packages must be specified for group elements.");
                            }
                            commandline.createArgument().setValue("-group");
                            commandline.createArgument().setValue(this.expand(string));
                            commandline.createArgument().setValue((String)object3);
                        }
                    }
                    if (javadoc4) {
                        object4 = this.tags.elements();
                        block23: while (true) {
                            if (!object4.hasMoreElements()) {
                                if (this.source != null) {
                                    commandline.createArgument().setValue("-source");
                                    commandline.createArgument().setValue(this.source);
                                }
                                if (this.linksource && this.doclet == null) {
                                    commandline.createArgument().setValue("-linksource");
                                }
                                if (this.breakiterator && this.doclet == null) {
                                    commandline.createArgument().setValue("-breakiterator");
                                }
                                if (this.noqualifier == null || this.doclet != null) break;
                                commandline.createArgument().setValue("-noqualifier");
                                commandline.createArgument().setValue(this.noqualifier);
                                break;
                            }
                            object5 = object4.nextElement();
                            if (object5 instanceof TagArgument) {
                                TagArgument tagArgument = (TagArgument)object5;
                                object3 = tagArgument.getDir(this.getProject());
                                if (object3 == null) {
                                    commandline.createArgument().setValue("-tag");
                                    commandline.createArgument().setValue(tagArgument.getParameter());
                                    continue;
                                }
                                object2 = tagArgument.getDirectoryScanner(this.getProject());
                                object = ((DirectoryScanner)object2).getIncludedFiles();
                                int n = 0;
                                while (true) {
                                    if (n >= ((String[])object).length) continue block23;
                                    File file = new File((File)object3, object[n]);
                                    try {
                                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                                        String string = null;
                                        while (true) {
                                            if ((string = bufferedReader.readLine()) == null) {
                                                bufferedReader.close();
                                                break;
                                            }
                                            commandline.createArgument().setValue("-tag");
                                            commandline.createArgument().setValue(string);
                                        }
                                    }
                                    catch (IOException iOException) {
                                        throw new BuildException("Couldn't read  tag file from " + file.getAbsolutePath(), iOException);
                                    }
                                    ++n;
                                }
                            }
                            ExtensionInfo extensionInfo = (ExtensionInfo)object5;
                            commandline.createArgument().setValue("-taglet");
                            commandline.createArgument().setValue(extensionInfo.getName());
                            if (extensionInfo.getPath() == null || ((Path)(object3 = extensionInfo.getPath().concatSystemClasspath("ignore"))).size() == 0) continue;
                            commandline.createArgument().setValue("-tagletpath");
                            commandline.createArgument().setPath((Path)object3);
                        }
                    }
                }
                object4 = null;
                object5 = null;
                try {
                    try {
                        if (this.useExternalFile) {
                            if (object4 == null) {
                                object4 = this.fileUtils.createTempFile("javadoc", "", null);
                                ((File)object4).deleteOnExit();
                                commandline.createArgument().setValue("@" + ((File)object4).getAbsolutePath());
                            }
                            object5 = new PrintWriter(new FileWriter(((File)object4).getAbsolutePath(), true));
                        }
                        object2 = vector.elements();
                        while (true) {
                            if (!object2.hasMoreElements()) {
                                object2 = vector2.elements();
                                break;
                            }
                            object = (String)object2.nextElement();
                            if (this.useExternalFile) {
                                ((PrintWriter)object5).println((String)object);
                                continue;
                            }
                            commandline.createArgument().setValue((String)object);
                        }
                        while (object2.hasMoreElements()) {
                            object = (SourceFile)object2.nextElement();
                            String string = ((SourceFile)object).getFile().getAbsolutePath();
                            if (this.useExternalFile) {
                                if (javadoc4 && string.indexOf(" ") > -1) {
                                    ((PrintWriter)object5).println("\"" + string + '\"');
                                    continue;
                                }
                                ((PrintWriter)object5).println(string);
                                continue;
                            }
                            commandline.createArgument().setValue(string);
                        }
                    }
                    catch (IOException iOException) {
                        ((File)object4).delete();
                        throw new BuildException("Error creating temporary file", iOException, this.getLocation());
                    }
                }
                catch (Throwable throwable) {
                    object3 = null;
                    if (object5 == null) throw throwable;
                    ((PrintWriter)object5).close();
                    throw throwable;
                }
                {
                    object3 = null;
                    if (object5 != null) {
                        ((PrintWriter)object5).close();
                    }
                    if (this.packageList == null) break block77;
                    commandline.createArgument().setValue("@" + this.packageList);
                }
            }
            this.log(commandline.describeCommand(), 3);
            this.log("Javadoc execution", 2);
            object2 = new JavadocOutputStream(2);
            object = new JavadocOutputStream(1);
            Execute execute = new Execute(new PumpStreamHandler((OutputStream)object2, (OutputStream)object));
            execute.setAntRun(this.getProject());
            execute.setWorkingDirectory(null);
            try {
                try {
                    execute.setCommandline(commandline.getCommandline());
                    int n = execute.execute();
                    if (n != 0 && this.failOnError) {
                        throw new BuildException("Javadoc returned " + n, this.getLocation());
                    }
                }
                catch (IOException iOException) {
                    throw new BuildException("Javadoc failed: " + iOException, iOException, this.getLocation());
                }
            }
            catch (Throwable throwable) {
                object3 = null;
                if (object4 != null) {
                    ((File)object4).delete();
                    object4 = null;
                }
                ((JavadocOutputStream)object2).logFlush();
                ((JavadocOutputStream)object).logFlush();
                try {
                    ((LogOutputStream)object2).close();
                    ((LogOutputStream)object).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                object3 = null;
                if (object4 == null) break block78;
                ((File)object4).delete();
            }
            object4 = null;
        }
        ((JavadocOutputStream)object2).logFlush();
        ((JavadocOutputStream)object).logFlush();
        try {}
        catch (IOException iOException) {
            return;
        }
        ((LogOutputStream)object2).close();
        ((LogOutputStream)object).close();
    }

    private final void addFileSets(Vector vector) {
        Enumeration enumeration = this.fileSets.elements();
        while (enumeration.hasMoreElements()) {
            FileSet fileSet = (FileSet)enumeration.nextElement();
            if (!fileSet.hasPatterns() && !fileSet.hasSelectors()) {
                fileSet = (FileSet)fileSet.clone();
                fileSet.createInclude().setName("**/*.java");
            }
            File file = fileSet.getDir(this.getProject());
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(new SourceFile(new File(file, stringArray[n])));
                ++n;
            }
        }
    }

    private final void parsePackages(Vector vector, Path path) {
        Object object;
        Object object2;
        Enumeration enumeration;
        Object object3;
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = (Vector)this.packageSets.clone();
        if (this.sourcePath != null && this.packageNames.size() > 0) {
            String string;
            object3 = new PatternSet();
            enumeration = this.packageNames.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (PackageName)enumeration.nextElement();
                string = ((PackageName)object2).getName().replace('.', '/');
                if (string.endsWith("*")) {
                    string = string + '*';
                }
                ((PatternSet)object3).createInclude().setName(string);
            }
            enumeration = this.excludePackageNames.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (PackageName)enumeration.nextElement();
                string = ((PackageName)object2).getName().replace('.', '/');
                if (string.endsWith("*")) {
                    string = string + '*';
                }
                ((PatternSet)object3).createExclude().setName(string);
            }
            object2 = this.sourcePath.list();
            int n = 0;
            while (n < ((Object)object2).length) {
                object = new DirSet();
                ((AbstractFileSet)object).setDefaultexcludes(this.useDefaultExcludes);
                ((AbstractFileSet)object).setDir(new File((String)object2[n]));
                ((AbstractFileSet)object).createPatternSet().addConfiguredPatternset((PatternSet)object3);
                vector3.addElement(object);
                ++n;
            }
        }
        object3 = vector3.elements();
        while (object3.hasMoreElements()) {
            enumeration = (DirSet)object3.nextElement();
            object2 = ((AbstractFileSet)((Object)enumeration)).getDir(this.getProject());
            this.log("scanning " + object2 + " for packages.", 4);
            DirectoryScanner directoryScanner = ((AbstractFileSet)((Object)enumeration)).getDirectoryScanner(this.getProject());
            object = directoryScanner.getIncludedDirectories();
            boolean bl = false;
            int n = 0;
            while (n < ((Object)object).length) {
                File file = new File((File)object2, (String)object[n]);
                String[] stringArray = file.list(new FilenameFilter(){

                    public final boolean accept(File file, String string) {
                        return string.endsWith(".java");
                    }
                });
                if (stringArray.length > 0) {
                    bl = true;
                    String string = ((String)object[n]).replace(File.separatorChar, '.');
                    if (!vector2.contains(string)) {
                        vector2.addElement(string);
                        vector.addElement(string);
                    }
                }
                ++n;
            }
            if (bl) {
                path.createPathElement().setLocation((File)object2);
                continue;
            }
            this.log(object2 + " doesn't contain any packages, dropping it.", 3);
        }
    }

    protected String expand(String string) {
        return this.getProject().replaceProperties(string);
    }

    private final /* synthetic */ void this() {
        this.cmd = new Commandline();
        this.failOnError = false;
        this.sourcePath = null;
        this.destDir = null;
        this.sourceFiles = new Vector();
        this.packageNames = new Vector();
        this.excludePackageNames = new Vector(1);
        this.author = true;
        this.version = true;
        this.doclet = null;
        this.classpath = null;
        this.bootclasspath = null;
        this.group = null;
        this.packageList = null;
        this.links = new Vector();
        this.groups = new Vector();
        this.tags = new Vector();
        this.useDefaultExcludes = true;
        this.doctitle = null;
        this.header = null;
        this.footer = null;
        this.bottom = null;
        this.useExternalFile = false;
        this.fileUtils = FileUtils.newFileUtils();
        this.source = null;
        this.linksource = false;
        this.breakiterator = false;
        this.fileSets = new Vector();
        this.packageSets = new Vector();
    }

    public Javadoc() {
        this.this();
    }

    static {
        boolean bl = false;
        if (!(JavaEnvUtils.isJavaVersion("1.1") || JavaEnvUtils.isJavaVersion("1.2") || JavaEnvUtils.isJavaVersion("1.3"))) {
            bl = true;
        }
        javadoc4 = bl;
        SCOPE_ELEMENTS = new String[]{"overview", "packages", "types", "constructors", "methods", "fields"};
    }

    public static class SourceFile {
        private File file;

        public void setFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public SourceFile() {
        }

        public SourceFile(File file) {
            this.file = file;
        }
    }

    public static class PackageName {
        private String name;

        public void setName(String string) {
            this.name = string.trim();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class AccessType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"protected", "public", "package", "private"};
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DocletInfo
    extends ExtensionInfo {
        private Vector params;

        public DocletParam createParam() {
            DocletParam docletParam = new DocletParam();
            this.params.addElement(docletParam);
            return docletParam;
        }

        public Enumeration getParams() {
            return this.params.elements();
        }

        private final /* synthetic */ void this() {
            this.params = new Vector();
        }

        public DocletInfo() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Html {
        private StringBuffer text;

        public void addText(String string) {
            this.text.append(string);
        }

        public String getText() {
            return this.text.substring(0);
        }

        private final /* synthetic */ void this() {
            this.text = new StringBuffer();
        }

        public Html() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class LinkArgument {
        private String href;
        private boolean offline;
        private File packagelistLoc;

        public void setHref(String string) {
            this.href = string;
        }

        public String getHref() {
            return this.href;
        }

        public void setPackagelistLoc(File file) {
            this.packagelistLoc = file;
        }

        public File getPackagelistLoc() {
            return this.packagelistLoc;
        }

        public void setOffline(boolean bl) {
            this.offline = bl;
        }

        public boolean isLinkOffline() {
            return this.offline;
        }

        private final /* synthetic */ void this() {
            this.offline = false;
        }

        public LinkArgument() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TagArgument
    extends FileSet {
        private String name;
        private String description;
        private boolean enabled;
        private String scope;

        public void setName(String string) {
            this.name = string;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public void setScope(String string) throws BuildException {
            int n;
            CharSequence charSequence;
            string = string.toLowerCase(Locale.US);
            boolean[] blArray = new boolean[SCOPE_ELEMENTS.length];
            boolean bl = false;
            boolean bl2 = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                charSequence = stringTokenizer.nextToken().trim();
                if (((String)charSequence).equals("all")) {
                    if (bl) {
                        this.getProject().log("Repeated tag scope element: all", 3);
                    }
                    bl = true;
                    continue;
                }
                n = 0;
                while (n < SCOPE_ELEMENTS.length) {
                    if (((String)charSequence).equals(SCOPE_ELEMENTS[n])) break;
                    ++n;
                }
                if (n == SCOPE_ELEMENTS.length) {
                    throw new BuildException("Unrecognised scope element: " + (String)charSequence);
                }
                if (blArray[n]) {
                    this.getProject().log("Repeated tag scope element: " + (String)charSequence, 3);
                }
                blArray[n] = true;
                bl2 = true;
            }
            if (bl2 && bl) {
                throw new BuildException("Mixture of \"all\" and other scope elements in tag parameter.");
            }
            if (!bl2 && !bl) {
                throw new BuildException("No scope elements specified in tag parameter.");
            }
            if (bl) {
                this.scope = "a";
            } else {
                charSequence = new StringBuffer(blArray.length);
                n = 0;
                while (n < blArray.length) {
                    if (blArray[n]) {
                        ((StringBuffer)charSequence).append(SCOPE_ELEMENTS[n].charAt(0));
                    }
                    ++n;
                }
                this.scope = ((StringBuffer)charSequence).toString();
            }
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public String getParameter() throws BuildException {
            if (this.name == null || this.name.equals("")) {
                throw new BuildException("No name specified for custom tag.");
            }
            if (this.description != null) {
                return this.name + ':' + (this.enabled ? "" : "X") + this.scope + ':' + this.description;
            }
            return this.name;
        }

        private final /* synthetic */ void this() {
            this.name = null;
            this.description = null;
            this.enabled = true;
            this.scope = "a";
        }

        public TagArgument() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class GroupArgument {
        private Html title;
        private Vector packages;

        public void setTitle(String string) {
            Html html = new Html();
            html.addText(string);
            this.addTitle(html);
        }

        public void addTitle(Html html) {
            this.title = html;
        }

        public String getTitle() {
            return this.title != null ? this.title.getText() : null;
        }

        public void setPackages(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                PackageName packageName = new PackageName();
                packageName.setName(string2);
                this.addPackage(packageName);
            }
        }

        public void addPackage(PackageName packageName) {
            this.packages.addElement(packageName);
        }

        public String getPackages() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.packages.size()) {
                if (n > 0) {
                    stringBuffer.append(":");
                }
                stringBuffer.append(this.packages.elementAt(n).toString());
                ++n;
            }
            return stringBuffer.toString();
        }

        private final /* synthetic */ void this() {
            this.packages = new Vector();
        }

        public GroupArgument() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DocletParam {
        private String name;
        private String value;

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class ExtensionInfo
    extends ProjectComponent {
        private String name;
        private Path path;

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setPath(Path path) {
            if (this.path == null) {
                this.path = path;
            } else {
                this.path.append(path);
            }
        }

        public Path getPath() {
            return this.path;
        }

        public Path createPath() {
            if (this.path == null) {
                this.path = new Path(this.getProject());
            }
            return this.path.createPath();
        }

        public void setPathRef(Reference reference) {
            this.createPath().setRefid(reference);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class JavadocOutputStream
    extends LogOutputStream {
        private String queuedLine;

        protected void processLine(String string, int n) {
            if (n == 2 && string.startsWith("Generating ")) {
                if (this.queuedLine != null) {
                    super.processLine(this.queuedLine, 3);
                }
                this.queuedLine = string;
            } else {
                if (this.queuedLine != null) {
                    if (string.startsWith("Building ")) {
                        super.processLine(this.queuedLine, 3);
                    } else {
                        super.processLine(this.queuedLine, 2);
                    }
                    this.queuedLine = null;
                }
                super.processLine(string, n);
            }
        }

        protected void logFlush() {
            if (this.queuedLine != null) {
                super.processLine(this.queuedLine, 3);
                this.queuedLine = null;
            }
        }

        private final /* synthetic */ void this() {
            this.queuedLine = null;
        }

        JavadocOutputStream(int n) {
            super(Javadoc.this, n);
            this.this();
        }
    }
}

