/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.SourceFileScanner;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExecuteOn
extends ExecTask {
    protected Vector filesets;
    private Vector filelists;
    private boolean relative;
    private boolean parallel;
    private boolean forwardSlash;
    protected String type;
    protected Commandline.Marker srcFilePos;
    private boolean skipEmpty;
    protected Commandline.Marker targetFilePos;
    protected Mapper mapperElement;
    protected FileNameMapper mapper;
    protected File destDir;
    private int maxParallel;
    private boolean addSourceFile;
    private boolean verbose;
    private boolean ignoreMissing;
    protected boolean srcIsFirst;

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void addDirset(DirSet dirSet) {
        this.filesets.addElement(dirSet);
    }

    public void addFilelist(FileList fileList) {
        this.filelists.addElement(fileList);
    }

    public void setRelative(boolean bl) {
        this.relative = bl;
    }

    public void setParallel(boolean bl) {
        this.parallel = bl;
    }

    public void setType(FileDirBoth fileDirBoth) {
        this.type = fileDirBoth.getValue();
    }

    public void setSkipEmptyFilesets(boolean bl) {
        this.skipEmpty = bl;
    }

    public void setDest(File file) {
        this.destDir = file;
    }

    public void setForwardslash(boolean bl) {
        this.forwardSlash = bl;
    }

    public void setMaxParallel(int n) {
        this.maxParallel = n;
    }

    public void setAddsourcefile(boolean bl) {
        this.addSourceFile = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setIgnoremissing(boolean bl) {
        this.ignoreMissing = bl;
    }

    public Commandline.Marker createSrcfile() {
        if (this.srcFilePos != null) {
            throw new BuildException(this.getTaskType() + " doesn't support multiple srcfile elements.", this.getLocation());
        }
        this.srcFilePos = this.cmdl.createMarker();
        return this.srcFilePos;
    }

    public Commandline.Marker createTargetfile() {
        if (this.targetFilePos != null) {
            throw new BuildException(this.getTaskType() + " doesn't support multiple targetfile elements.", this.getLocation());
        }
        this.targetFilePos = this.cmdl.createMarker();
        boolean bl = false;
        if (this.srcFilePos != null) {
            bl = true;
        }
        this.srcIsFirst = bl;
        return this.targetFilePos;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    protected void checkConfiguration() {
        if ("execon".equals(this.getTaskName())) {
            this.log("!! execon is deprecated. Use apply instead. !!");
        }
        super.checkConfiguration();
        if (this.filesets.size() == 0 && this.filelists.size() == 0) {
            throw new BuildException("no filesets and no filelists specified", this.getLocation());
        }
        if (this.targetFilePos != null || this.mapperElement != null || this.destDir != null) {
            if (this.mapperElement == null) {
                throw new BuildException("no mapper specified", this.getLocation());
            }
            if (this.destDir == null) {
                throw new BuildException("no dest attribute specified", this.getLocation());
            }
            this.mapper = this.mapperElement.getImplementation();
        }
    }

    protected ExecuteStreamHandler createHandler() throws BuildException {
        return this.redirectorElement == null ? super.createHandler() : new PumpStreamHandler();
    }

    protected void setupRedirector() {
        super.setupRedirector();
        this.redirector.setAppendProperties(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runExec(Execute execute) throws BuildException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        try {
            try {
                String[] stringArray;
                Object object;
                Object object2;
                Vector<Object> vector = new Vector<Object>();
                Vector<Object> vector2 = new Vector<Object>();
                int n3 = 0;
                while (n3 < this.filesets.size()) {
                    int n4;
                    Object[] objectArray;
                    object2 = this.type;
                    object = (AbstractFileSet)this.filesets.elementAt(n3);
                    if (object instanceof DirSet && !"dir".equals(this.type)) {
                        this.log("Found a nested dirset but type is " + this.type + ". Temporarily switching to type=\"dir\" on the assumption that you really did mean <dirset> not <fileset>.", 4);
                        object2 = "dir";
                    }
                    stringArray = ((AbstractFileSet)object).getDir(this.getProject());
                    ExtendedDirectoryScanner extendedDirectoryScanner = new ExtendedDirectoryScanner();
                    ((AbstractFileSet)object).setupDirectoryScanner(extendedDirectoryScanner, this.getProject());
                    extendedDirectoryScanner.setFollowSymlinks(((AbstractFileSet)object).isFollowSymlinks());
                    extendedDirectoryScanner.scan();
                    if (!"dir".equals(object2)) {
                        objectArray = this.getFiles((File)stringArray, extendedDirectoryScanner);
                        n4 = 0;
                        while (n4 < objectArray.length) {
                            ++n;
                            vector.addElement(objectArray[n4]);
                            vector2.addElement(stringArray);
                            ++n4;
                        }
                    }
                    if (!"file".equals(object2)) {
                        objectArray = this.getDirs((File)stringArray, extendedDirectoryScanner);
                        n4 = 0;
                        while (n4 < objectArray.length) {
                            ++n2;
                            vector.addElement(objectArray[n4]);
                            vector2.addElement(stringArray);
                            ++n4;
                        }
                    }
                    if (vector.size() == 0 && this.skipEmpty) {
                        int n5 = 0;
                        if (!"dir".equals(object2)) {
                            n5 = extendedDirectoryScanner.getIncludedFilesCount();
                        }
                        int n6 = 0;
                        if (!"file".equals(object2)) {
                            n6 = extendedDirectoryScanner.getIncludedDirsCount();
                        }
                        int n7 = n5 + n6;
                        this.log("Skipping fileset for directory " + stringArray + ". It is " + (n7 > 0 ? "up to date." : "empty."), 2);
                    } else if (!this.parallel) {
                        objectArray = new String[vector.size()];
                        vector.copyInto(objectArray);
                        n4 = 0;
                        while (n4 < objectArray.length) {
                            String[] stringArray2 = this.getCommandline((String)objectArray[n4], (File)stringArray);
                            this.log(Commandline.describeCommand(stringArray2), 3);
                            execute.setCommandline(stringArray2);
                            if (this.redirectorElement != null) {
                                this.setupRedirector();
                                this.redirectorElement.configure(this.redirector, (String)objectArray[n4]);
                            }
                            if (this.redirectorElement != null || bl) {
                                execute.setStreamHandler(this.redirector.createHandler());
                            }
                            this.runExecute(execute);
                            bl = true;
                            ++n4;
                        }
                        vector.removeAllElements();
                        vector2.removeAllElements();
                    }
                    ++n3;
                }
                n3 = 0;
                while (n3 < this.filelists.size()) {
                    object2 = (FileList)this.filelists.elementAt(n3);
                    object = ((FileList)object2).getDir(this.getProject());
                    stringArray = this.getFilesAndDirs((FileList)object2);
                    int n8 = 0;
                    while (n8 < stringArray.length) {
                        File file = new File((File)object, stringArray[n8]);
                        if (!this.ignoreMissing || file.isFile() && !"dir".equals(this.type) || file.isDirectory() && !"file".equals(this.type)) {
                            if (this.ignoreMissing || file.isFile()) {
                                ++n;
                            } else {
                                ++n2;
                            }
                            vector.addElement(stringArray[n8]);
                            vector2.addElement(object);
                        }
                        ++n8;
                    }
                    if (vector.size() == 0 && this.skipEmpty) {
                        ExtendedDirectoryScanner extendedDirectoryScanner = new ExtendedDirectoryScanner();
                        extendedDirectoryScanner.setBasedir((File)object);
                        extendedDirectoryScanner.setIncludes(((FileList)object2).getFiles(this.getProject()));
                        extendedDirectoryScanner.scan();
                        int n9 = extendedDirectoryScanner.getIncludedFilesCount() + extendedDirectoryScanner.getIncludedDirsCount();
                        this.log("Skipping filelist for directory " + object + ". It is " + (n9 > 0 ? "up to date." : "empty."), 2);
                    } else if (!this.parallel) {
                        Object[] objectArray = new String[vector.size()];
                        vector.copyInto(objectArray);
                        int n10 = 0;
                        while (n10 < objectArray.length) {
                            String[] stringArray3 = this.getCommandline((String)objectArray[n10], (File)object);
                            this.log(Commandline.describeCommand(stringArray3), 3);
                            execute.setCommandline(stringArray3);
                            if (this.redirectorElement != null) {
                                this.setupRedirector();
                                this.redirectorElement.configure(this.redirector, (String)objectArray[n10]);
                            }
                            if (this.redirectorElement != null || bl) {
                                execute.setStreamHandler(this.redirector.createHandler());
                            }
                            this.runExecute(execute);
                            bl = true;
                            ++n10;
                        }
                        vector.removeAllElements();
                        vector2.removeAllElements();
                    }
                    ++n3;
                }
                if (this.parallel && (vector.size() > 0 || !this.skipEmpty)) {
                    this.runParallel(execute, vector, vector2);
                    bl = true;
                }
                if (bl) {
                    this.log("Applied " + this.cmdl.getExecutable() + " to " + n + " file" + (n != 1 ? "s" : "") + " and " + n2 + " director" + (n2 != 1 ? "ies" : "y") + '.', 3 - this.verbose);
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Execute failed: " + iOException, iOException, this.getLocation());
            }
            Object var6_27 = null;
        }
        catch (Throwable throwable) {
            Object var6_26 = null;
            this.logFlush();
            this.redirector.setAppendProperties(false);
            this.redirector.setProperties();
            throw throwable;
        }
        this.logFlush();
        this.redirector.setAppendProperties(false);
        this.redirector.setProperties();
    }

    protected String[] getCommandline(String[] stringArray, File[] fileArray) {
        int n;
        String[] stringArray2;
        Object[] objectArray;
        char c = File.separatorChar;
        Vector<String> vector = new Vector<String>();
        if (this.targetFilePos != null) {
            objectArray = new Hashtable();
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray2 = this.mapper.mapFileName(stringArray[n2]);
                if (stringArray2 != null) {
                    n = 0;
                    while (n < stringArray2.length) {
                        String string = null;
                        string = !this.relative ? new File(this.destDir, stringArray2[n]).getAbsolutePath() : stringArray2[n];
                        if (this.forwardSlash && c != '/') {
                            string = string.replace(c, '/');
                        }
                        if (!objectArray.contains(string)) {
                            vector.addElement(string);
                            objectArray.put(string, string);
                        }
                        ++n;
                    }
                }
                ++n2;
            }
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        if (!this.addSourceFile) {
            stringArray = new String[]{};
        }
        String[] stringArray3 = this.cmdl.getCommandline();
        stringArray2 = new String[stringArray3.length + stringArray.length + objectArray.length];
        n = stringArray3.length;
        if (this.srcFilePos != null) {
            n = this.srcFilePos.getPosition();
        }
        if (this.targetFilePos != null) {
            int n3 = this.targetFilePos.getPosition();
            if (n < n3 || n == n3 && this.srcIsFirst) {
                System.arraycopy(stringArray3, 0, stringArray2, 0, n);
                System.arraycopy(stringArray3, n, stringArray2, n + stringArray.length, n3 - n);
                System.arraycopy(objectArray, 0, stringArray2, n3 + stringArray.length, objectArray.length);
                System.arraycopy(stringArray3, n3, stringArray2, n3 + stringArray.length + objectArray.length, stringArray3.length - n3);
            } else {
                System.arraycopy(stringArray3, 0, stringArray2, 0, n3);
                System.arraycopy(objectArray, 0, stringArray2, n3, objectArray.length);
                System.arraycopy(stringArray3, n3, stringArray2, n3 + objectArray.length, n - n3);
                System.arraycopy(stringArray3, n, stringArray2, n + stringArray.length + objectArray.length, stringArray3.length - n);
                n += objectArray.length;
            }
        } else {
            System.arraycopy(stringArray3, 0, stringArray2, 0, n);
            System.arraycopy(stringArray3, n, stringArray2, n + stringArray.length, stringArray3.length - n);
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            stringArray2[n + n4] = !this.relative ? new File(fileArray[n4], stringArray[n4]).getAbsolutePath() : stringArray[n4];
            if (this.forwardSlash && c != '/') {
                stringArray2[n + n4] = stringArray2[n + n4].replace(c, '/');
            }
            ++n4;
        }
        return stringArray2;
    }

    protected String[] getCommandline(String string, File file) {
        return this.getCommandline(new String[]{string}, new File[]{file});
    }

    protected String[] getFiles(File file, DirectoryScanner directoryScanner) {
        if (this.mapper != null) {
            SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
            return sourceFileScanner.restrict(directoryScanner.getIncludedFiles(), file, this.destDir, this.mapper);
        }
        return directoryScanner.getIncludedFiles();
    }

    protected String[] getDirs(File file, DirectoryScanner directoryScanner) {
        if (this.mapper != null) {
            SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
            return sourceFileScanner.restrict(directoryScanner.getIncludedDirectories(), file, this.destDir, this.mapper);
        }
        return directoryScanner.getIncludedDirectories();
    }

    protected String[] getFilesAndDirs(FileList fileList) {
        if (this.mapper != null) {
            SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
            return sourceFileScanner.restrict(fileList.getFiles(this.getProject()), fileList.getDir(this.getProject()), this.destDir, this.mapper);
        }
        return fileList.getFiles(this.getProject());
    }

    protected void runParallel(Execute execute, Vector vector, Vector vector2) throws IOException, BuildException {
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Object[] objectArray2 = new File[vector2.size()];
        vector2.copyInto(objectArray2);
        if (this.maxParallel <= 0 || objectArray.length == 0) {
            String[] stringArray = this.getCommandline((String[])objectArray, (File[])objectArray2);
            this.log(Commandline.describeCommand(stringArray), 3);
            execute.setCommandline(stringArray);
            this.runExecute(execute);
        } else {
            int n = vector.size();
            int n2 = 0;
            while (n > 0) {
                int n3 = Math.min(n, this.maxParallel);
                String[] stringArray = new String[n3];
                System.arraycopy(objectArray, n2, stringArray, 0, n3);
                File[] fileArray = new File[n3];
                System.arraycopy(objectArray2, n2, fileArray, 0, n3);
                String[] stringArray2 = this.getCommandline(stringArray, fileArray);
                this.log(Commandline.describeCommand(stringArray2), 3);
                execute.setCommandline(stringArray2);
                if (this.redirectorElement != null) {
                    this.setupRedirector();
                    this.redirectorElement.configure(this.redirector, null);
                }
                if (this.redirectorElement != null || n2 > 0) {
                    execute.setStreamHandler(this.redirector.createHandler());
                }
                this.runExecute(execute);
                n -= n3;
                n2 += n3;
            }
        }
    }

    private final /* synthetic */ void this() {
        this.filesets = new Vector();
        this.filelists = new Vector();
        this.relative = false;
        this.parallel = false;
        this.forwardSlash = false;
        this.type = "file";
        this.srcFilePos = null;
        this.skipEmpty = false;
        this.targetFilePos = null;
        this.mapperElement = null;
        this.mapper = null;
        this.destDir = null;
        this.maxParallel = -1;
        this.addSourceFile = true;
        this.verbose = false;
        this.ignoreMissing = true;
        this.srcIsFirst = true;
    }

    public ExecuteOn() {
        this.this();
    }

    public static class FileDirBoth
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"file", "dir", "both"};
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ExtendedDirectoryScanner
    extends DirectoryScanner {
        public int getIncludedFilesCount() {
            if (this.filesIncluded == null) {
                throw new IllegalStateException();
            }
            return this.filesIncluded.size();
        }

        public int getIncludedDirsCount() {
            if (this.dirsIncluded == null) {
                throw new IllegalStateException();
            }
            return this.dirsIncluded.size();
        }

        private ExtendedDirectoryScanner() {
        }
    }
}

