/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DependSet
extends MatchingTask {
    private Vector sourceFileSets;
    private Vector sourceFileLists;
    private Vector targetFileSets;
    private Vector targetFileLists;

    public void addSrcfileset(FileSet fileSet) {
        this.sourceFileSets.addElement(fileSet);
    }

    public void addSrcfilelist(FileList fileList) {
        this.sourceFileLists.addElement(fileList);
    }

    public void addTargetfileset(FileSet fileSet) {
        this.targetFileSets.addElement(fileSet);
    }

    public void addTargetfilelist(FileList fileList) {
        this.targetFileLists.addElement(fileList);
    }

    public void execute() throws BuildException {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        if (this.sourceFileSets.size() == 0 && this.sourceFileLists.size() == 0) {
            throw new BuildException("At least one <srcfileset> or <srcfilelist> element must be set");
        }
        if (this.targetFileSets.size() == 0 && this.targetFileLists.size() == 0) {
            throw new BuildException("At least one <targetfileset> or <targetfilelist> element must be set");
        }
        long l = new Date().getTime();
        if (Os.isFamily("windows")) {
            l += 2000L;
        }
        Vector<Object> vector = new Vector<Object>();
        long l2 = 0L;
        String[] stringArray2 = null;
        Enumeration enumeration = this.targetFileSets.elements();
        while (enumeration.hasMoreElements()) {
            FileSet fileSet = (FileSet)enumeration.nextElement();
            if (!fileSet.getDir(this.getProject()).exists()) continue;
            object3 = fileSet.getDirectoryScanner(this.getProject());
            object2 = ((DirectoryScanner)object3).getIncludedFiles();
            int n = 0;
            while (n < ((String[])object2).length) {
                object = new File(fileSet.getDir(this.getProject()), (String)object2[n]);
                vector.addElement(object);
                if (((File)object).lastModified() > l) {
                    this.log("Warning: " + (String)object2[n] + " modified in the future.", 1);
                }
                if (stringArray2 == null || ((File)object).lastModified() < l2) {
                    l2 = ((File)object).lastModified();
                    stringArray2 = object;
                }
                ++n;
            }
        }
        boolean bl = true;
        object3 = this.targetFileLists.elements();
        while (object3.hasMoreElements()) {
            object2 = (String[])object3.nextElement();
            String[] stringArray3 = ((FileList)object2).getFiles(this.getProject());
            int n = 0;
            while (n < stringArray3.length) {
                stringArray = new File(((FileList)object2).getDir(this.getProject()), stringArray3[n]);
                if (!stringArray.exists()) {
                    this.log(stringArray3[n] + " does not exist.", 3);
                    bl = false;
                } else {
                    vector.addElement(stringArray);
                    if (stringArray.lastModified() > l) {
                        this.log("Warning: " + stringArray3[n] + " modified in the future.", 1);
                    }
                    if (stringArray2 == null || stringArray.lastModified() < l2) {
                        l2 = stringArray.lastModified();
                        stringArray2 = stringArray;
                    }
                }
                ++n;
            }
        }
        if (stringArray2 != null) {
            this.log(stringArray2 + " is oldest target file", 3);
        } else {
            bl = false;
        }
        if (bl) {
            object2 = this.sourceFileLists.elements();
            block4: while (bl && object2.hasMoreElements()) {
                FileList fileList = (FileList)object2.nextElement();
                object = fileList.getFiles(this.getProject());
                int n = 0;
                while (bl && n < ((Object)object).length) {
                    File file = new File(fileList.getDir(this.getProject()), (String)object[n]);
                    if (file.lastModified() > l) {
                        this.log("Warning: " + (String)object[n] + " modified in the future.", 1);
                    }
                    if (!file.exists()) {
                        this.log((String)object[n] + " does not exist.", 3);
                        bl = false;
                        continue block4;
                    }
                    if (file.lastModified() > l2) {
                        bl = false;
                        this.log(stringArray2 + " is out of date with respect to " + (String)object[n], 3);
                    }
                    ++n;
                }
            }
        }
        if (bl) {
            object2 = this.sourceFileSets.elements();
            while (bl && object2.hasMoreElements()) {
                FileSet fileSet = (FileSet)object2.nextElement();
                object = fileSet.getDirectoryScanner(this.getProject());
                stringArray = ((DirectoryScanner)object).getIncludedFiles();
                int n = 0;
                while (bl && n < stringArray.length) {
                    File file = new File(fileSet.getDir(this.getProject()), stringArray[n]);
                    if (file.lastModified() > l) {
                        this.log("Warning: " + stringArray[n] + " modified in the future.", 1);
                    }
                    if (file.lastModified() > l2) {
                        bl = false;
                        this.log(stringArray2 + " is out of date with respect to " + stringArray[n], 3);
                    }
                    ++n;
                }
            }
        }
        if (!bl) {
            this.log("Deleting all target files. ", 3);
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                File file = (File)object2.nextElement();
                this.log("Deleting file " + file.getAbsolutePath(), 3);
                file.delete();
            }
        }
    }

    private final /* synthetic */ void this() {
        this.sourceFileSets = new Vector();
        this.sourceFileLists = new Vector();
        this.targetFileSets = new Vector();
        this.targetFileLists = new Vector();
    }

    public DependSet() {
        this.this();
    }
}

