/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ConcatFilter
extends BaseParamFilterReader
implements ChainableReader {
    private File prepend;
    private File append;
    private Reader prependReader;
    private Reader appendReader;

    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int ch = -1;
        if (this.prependReader != null && (ch = this.prependReader.read()) == -1) {
            this.prependReader.close();
            this.prependReader = null;
        }
        if (ch == -1) {
            ch = super.read();
        }
        if (ch == -1 && this.appendReader != null && (ch = this.appendReader.read()) == -1) {
            this.appendReader.close();
            this.appendReader = null;
        }
        return ch;
    }

    public final void setPrepend(File prepend) {
        this.prepend = prepend;
    }

    public final File getPrepend() {
        return this.prepend;
    }

    public final void setAppend(File append) {
        this.append = append;
    }

    public final File getAppend() {
        return this.append;
    }

    public final Reader chain(Reader rdr) {
        ConcatFilter newFilter = new ConcatFilter(rdr);
        newFilter.setPrepend(this.getPrepend());
        newFilter.setAppend(this.getAppend());
        return newFilter;
    }

    private final void initialize() throws IOException {
        Parameter[] params = this.getParameters();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                if ("prepend".equals(params[i].getName())) {
                    this.setPrepend(new File(params[i].getValue()));
                } else if ("append".equals(params[i].getName())) {
                    this.setAppend(new File(params[i].getValue()));
                }
                ++i;
            }
        }
        if (this.prepend != null) {
            if (!this.prepend.isAbsolute()) {
                this.prepend = new File(this.getProject().getBaseDir(), this.prepend.getPath());
            }
            this.prependReader = new BufferedReader(new FileReader(this.prepend));
        }
        if (this.append != null) {
            if (!this.append.isAbsolute()) {
                this.append = new File(this.getProject().getBaseDir(), this.append.getPath());
            }
            this.appendReader = new BufferedReader(new FileReader(this.append));
        }
    }

    private final /* synthetic */ void this() {
        this.prependReader = null;
        this.appendReader = null;
    }

    public ConcatFilter() {
        this.this();
    }

    public ConcatFilter(Reader in) {
        super(in);
        this.this();
    }
}

